/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.StringUtil;

/**
 * HTMLAREA エディターは、カラムのデータをテキストエリアで編集し、
 * HTML文字をエスケープして登録する場合に使用するクラスです。
 *
 * エスケープする以外はTEXTAREAと同様です
 *
 * @og.rev 5.5.8.0 (2012/11/01) 新規作成
 * @og.rev 6.4.4.2 (2016/04/01) Editor_TEXTAREA を継承するように変更。
 * @og.group データ編集
 *
 * @version  5.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Editor_HTMLAREA extends Editor_TEXTAREA {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.4.2 (2016/04/01)" ;

	// 6.4.4.2 (2016/04/01) Editor_TEXTAREA を継承するように変更。

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_HTMLAREA() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * コンストラクター。
	 *
	 * @og.rev 6.4.4.2 (2016/04/01) Editor_TEXTAREA を継承するように変更。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_HTMLAREA( final DBColumn clm ) {
		super( clm );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_HTMLAREA( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @og.rev 6.4.4.2 (2016/04/01) Editor_TEXTAREA を継承するように変更。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの編集用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		return super.getValue( StringUtil.htmlFilter(value) );

	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 3.1.0.0 (2003/03/20) 名前と行番号の区切り記号を "^" から "__" に変更。
	 * @og.rev 3.5.5.0 (2004/03/12) 名前と行番号の区切り記号("__")を、HybsSystem.JOINT_STRING  に変更。
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 * @og.rev 5.1.2.0 (2010/01/01) 先頭の'_'による書き込み制御を行わない。(他のクラスとの実装の共通化)
	 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
	 * @og.rev 6.4.4.2 (2016/04/01) Editor_TEXTAREA を継承するように変更。
	 *
	 * @param   row   行番号
	 * @param   value 入力値
	 *
	 * @return  データ表示/編集用の文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final int row,final String value ) {
		return super.getValue( row , StringUtil.htmlFilter(value) );

	}
}
