/**
 * <pre>
 * このドキュメントは、『はやぶさPlugIn』の Query PlugIn 仕様です。
 * 
 * Query は、データベースからの検索、登録を行うクラスを準備しています。
 * 
 * 
 * 基本的には、エンジン標準の DBTableModel オブジェクトを構築するか、その
 * オブジェクトの内容をデータベースに設定する作業を行います。
 * 
 * 
 * 通常、検索Query(SQL文)は、外部より指定されます。登録時も同様に、Queryは
 * 外部より指定されます。
 * 
 * 
 * これは、このフレームワークの特徴である、画面に業務ロジックを記述する
 * 最も基本的なところです。
 * 
 * 
 * ※ <a href="http://ja.wikipedia.org/wiki/Model_View_Controller">MVC(Model View Controller)</a>
 * MVCでは、アプリケーションの特定領域とデータアクセスのModel、ユーザーインタフェースのView、
 * イベント（主にユーザのアクション）に対して応答・処理するController、の3つに分割する方法。
 * 
 * それぞれの機能を分割する事で、プログラムの抽象度を高める働きはあるが、見た目と動作は本質的には
 * 不可分なものであり、従ってViewとControllerはいつでも分離できるとは限らない。
 * 
 * 『はやぶさフレームワーク』では、View で積極的に Controller する事で、不要なクラスの作成を
 * 押さえ、画面単位にわかり易い作りに出来る方を採用しました。
 * 
 * </pre>
 */
package org.opengion.plugin.query;
