/*!
 * common/jquery/jquery.blockUI.js を使用した検索中表示のクリア
 *
 * query.jsp に include された blockUI.js を、result.jsp に include された 
 * 自身(unblockUI.js)の $(document).ready を使用して、検索中レイヤーの破棄を行います。
 * 
 * openGion 6.3.4.1 (2015/08/08)
 * 
 * 5.7.7.1 (2014/06/13) headType="result" 時に、BODY にINSERTする文字列。
 * 5.7.8.1 (2014/07/18) ３ペイン等で、frame が多段階になっている場合の対応
 * 5.8.7.1 (2015/05/22) fnUnblockUI 未定義エラーに対応(6.2.4.0対応の適用)
 * 5.9.2.1 (2015/11/13) 判定修正
 */

$(function(){
	var qfrm=window.parent.frames['QUERY'];
	if(qfrm == null) {
		qfrm=window.parent.parent.frames['QUERY'];
	}
	if( qfrm && qfrm.$ && qfrm.$.fnUnblockUI ) {
		$(document).ready(function(){ qfrm.$.fnUnblockUI(); });
	}
});
