<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6020"
	title	= "表示・編種別"
	date	= "2014/11/25"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<table summary="layout" >
<tr>
	<og:column name="TEXT"		renderer="LABEL"	lbl="{@LBL.EDITOR.TEXT}(※)"		value="{@TEXT}"		writable="false" />
	<og:column name="NUMBER"	renderer="NUMBER"	lbl="RENDERER.NUMBER"				value="{@NUMBER}"	writable="false" />
	<og:column name="ENTCLM"	renderer="LABEL"	lbl="{@LBL.EDITOR.ENTCLM}(※)"		value="{@ENTCLM}"	writable="false" />
	<og:column name="MENU"		renderer="MENU"		lbl="RENDERER.MENU"					value="{@MENU}"		writable="false" codeName="LANG" />
</tr>
<tr>
	<og:column name="DBMENU"	renderer="DBLABEL"	lbl="RENDERER.DBLABEL"				value="{@DBMENU}"	writable="false"
		param="select  EMPNO , ENAME , DEPTNO from EMP order by DEPTNO,EMPNO"
	/>
	<og:column name="INMENU"	renderer="LABEL"	lbl="{@LBL.EDITOR.INMENU}(※)"		value="{@INMENU}"	writable="false" codeName="LANG" />
	<og:column name="INDBMENU"	renderer="DBLABEL"	lbl="RENDERER.DBLABEL"				value="{@INDBMENU}"	writable="false"
		param="select  EMPNO , ENAME , DEPTNO from EMP order by DEPTNO,EMPNO"
	/>
</tr>
<tr>
	<og:column name="DATALIST"	renderer="DBLABEL"	lbl="{@LBL.EDITOR.DATALIST}(※)"	value="{@DATALIST}"	writable="false"
		param="select  EMPNO , ENAME , DEPTNO from EMP order by DEPTNO,EMPNO"
	/>
	<og:column name="NUMMENU"	renderer="NUMBER"	lbl="{@LBL.EDITOR.NUMMENU}(※)"		value="{@NUMMENU}"	writable="false" />
	<og:column name="YMDMENU"	renderer="YMD"		lbl="{@LBL.EDITOR.YMDMENU}(※)"		value="{@YMDMENU}"	writable="false" />
	<og:column name="HMMENU"	renderer="HM"		lbl="{@LBL.EDITOR.HMMENU}(※)"		value="{@HMMENU}"	writable="false" />
</tr>
<tr>
	<og:column name="PASSWD"	renderer="PASSWD"	lbl="RENDERER.PASSWD"				value="{@PASSWD}"	writable="false" />
	<og:column name="TEXTAREA"	renderer="TEXTAREA"	lbl="RENDERER.TEXTAREA"				value="{@TEXTAREA}"	writable="false" />
<!--
	<og:column name="HTMLAREA"	renderer="HTMLPRE"	lbl="{@LBL.EDITOR.HTMLAREA}(※)"	value="{@HTMLAREA}"	writable="false" xssCheck="false" />
-->
	<!-- xssCheck は、BODY にのみ有効で、value の自動設定も止めるため、useRequestValue="false" も必要 -->
	<og:column name="HTMLAREA"	renderer="HTMLPRE"	lbl="{@LBL.EDITOR.HTMLAREA}(※)"	writable="false" useRequestValue="false" xssCheck="false" >{@HTMLAREA}</og:column>
	<og:column name="AUTOAREA"	renderer="AUTOAREA"	lbl="RENDERER.AUTOAREA"				value="{@AUTOAREA}"	writable="false" />
</tr>
<tr>
	<og:column name="HTML"		renderer="HTML"		lbl="RENDERER.HTML"					value="{@HTML}"		writable="false" />
	<og:column name="HM"		renderer="HM"		lbl="RENDERER.HM"					value="{@HM}"		writable="false" />
	<og:column name="YM"		renderer="YM"		lbl="RENDERER.YM"					value="{@YM}"		writable="false" />
	<og:column name="WRITABLE"	renderer="WRITABLE"	lbl="RENDERER.WRITABLE"				value="{@WRITABLE}"	writable="false" />
</tr>
<tr>
	<og:column name="YMD"		renderer="YMD"		lbl="RENDERER.YMD"					value="{@YMD}"		writable="false" />
	<og:column name="YMD2"		renderer="YMD"		lbl="{@LBL.EDITOR.YMD2}(※)"		value="{@YMD2}"		writable="false" />
	<og:column name="YMDH"		renderer="YMDH"		lbl="RENDERER.YMDH"					value="{@YMDH}"		writable="false" />
	<og:column name="COLUMN"	renderer="COLUMN"	lbl="RENDERER.COLUMN"				value="LANG"		writable="false" />
</tr>
<tr>
	<og:column name="RADIO"		renderer="RADIO"	lbl="RENDERER.RADIO"				value="{@RADIO}"	writable="false" codeName="LANG" />
<!-- 6.4.4.0 (2016/03/11) 廃止
	<og:column name="RADIO2"	renderer="RADIO"	lbl="{@LBL.EDITOR.RADIO2}(※)"		value="{@RADIO2}"	writable="false" codeName="LANG" />
-->
	<og:column name="CHBOX"		renderer="CHBOX"	lbl="RENDERER.CHBOX"				value="{@CHBOX}"	writable="false"				 />
	<!-- {@SUM.XXX} は、マルチバリューに対して、数値の場合は加算し、文字列の場合は、カンマ記号で連結します。 -->
	<og:column name="CHBOX2"	renderer="CHBOX2"	lbl="{@LBL.EDITOR.CHBOX2}(※)"		value="{@SUM.CHBOX2}"	writable="false" codeName="LANG" />
</tr>
<tr>
	<og:column name="DBRADIO"	renderer="DBLABEL"	lbl="{@LBL.EDITOR.DBRADIO}(※)"		value="{@DBRADIO}"	writable="false"
		param="select CLM,SNAME from GEA08 where system_id='**' and lang='ja' and clm like 'LANG.%'"
	/>
	<og:column name="HIDDEN"	renderer="LABEL"		lbl="{@LBL.EDITOR.HIDDEN}(※)"	value="{@HIDDEN}"	writable="false" />
<!--	<og:column name="CRYPT"		renderer="CRYPT"		lbl="RENDERER.CRYPT"			value="{@CRYPT}"	writable="false" />	-->
	<og:column name="DECIMAL"	renderer="DECIMAL"		lbl="RENDERER.DECIMAL"			value="{@DECIMAL}"	writable="false" />
</tr>
<tr>
	<og:column name="PN"		renderer="PN"			lbl="RENDERER.PN"				value="{@PN}"		writable="false" />
	<og:column name="COLOR"		renderer="COLOR"		lbl="RENDERER.COLOR"			value="{@COLOR}"	writable="false" />
	<og:column name="QUERY"		renderer="QUERY"		lbl="RENDERER.QUERY"								writable="false"
		param="select count(*) from GF41"
	/>
</tr>
<tr>
	<og:column name="BIT_BOX"	renderer="BITBOX"		lbl="BIT_BOX"	colspan="7" 	writable="false"	value="{@SUM.BIT_BOX}" />
</tr>
</table>

<hr />
<og:query command="NEW">
	SELECT A.ENAME   as LABELS
			, A.SAL  as VAL1
			, A.COMM as VAL2
			, A.JOB
			, B.EMPNO
			, B.MGR
			, B.HIREDATE
			, B.SAL || ':' || CASE B.DEPTNO WHEN 10 THEN '￥' WHEN 20 THEN '＄' WHEN 30 THEN '€' ELSE '¤' END AS SAL2
			, B.SAL
			, B.COMM
			, B.DEPTNO
			, C.DNAME
			, C.LOC
	FROM BONUS A left outer join EMP B
		on A.ENAME = B.ENAME
		left outer join DEPT C
			on B.DEPTNO = C.DEPTNO
	order by B.EMPNO
</og:query>

<og:columnEditor column="HIREDATE" renderer="DATE" param="yyyy/MM/dd" />
<og:columnEditor column="SAL2"  renderer="MONEY" dbType="S9" />
<og:columnEditor column="COMM"  renderer="MONEY" />
<og:columnEditor column="VAL1"  renderer="NUMBER" dbType="S9" />
<og:columnEditor column="EMPNO" renderer="DECIMAL" dbType="S9" />

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="NEW">
	<og:columnMarker column="SAL2" onMark="[DEPTNO]" markList="10" useFormatDeco="true">
		[$SAL2]
	</og:columnMarker>
	<og:columnMarker column="SAL2" onMark="[DEPTNO]" markList="20" useFormatDeco="true">
		<span style="background-color:#ccff00">[$SAL2 2]</span>
	</og:columnMarker>
	<og:columnMarker column="SAL2" onMark="[DEPTNO]" markList="30" useFormatDeco="true">
		<i>[$SAL2 4]</i>
	</og:columnMarker>
	<og:columnMarker column="HIREDATE" useFormatDeco="true">
		<span style="background-color:#ccff00">[$HIREDATE MM/dd(EEE)]</span>
	</og:columnMarker>
	<og:columnMarker column="EMPNO" onMark="[DEPTNO]" markList="20" useFormatDeco="true">
		<span style="background-color:#ffcc00">[$EMPNO #,###.0]</span>
	</og:columnMarker>
</og:viewMarker>

<og:view command="NEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
