<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script type="text/javascript" src="{@SYS.JSP}/custom/Chart.min.js"><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7301"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="NEW">
	SELECT 	 ENAME									<!-- 営業担当者 -->
			,SAL * 2 * DBMS_RANDOM.VALUE as SAL1		<!-- 売上( 1月) -->
			,SAL * 2.5 * DBMS_RANDOM.VALUE as SAL2		<!-- 売上( 2月) -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
</og:query>

<canvas id="mycanvas" height="400" width="400"></canvas>

<script type="text/javascript">
	// jsonで取得
	var querydata =
	<og:view
		viewFormType	= "JSON"
		command			= "NEW"
		useHilightRow	= "false"
		useAfterHtmlTag	= "false"
		useConsistency	= "false"
		pageSize		= "0" />
	;

	var datadata1   = [];
	var datadata2   = [];
	var datalabels = [];
	for(var i=0; i&lt; querydata.DATA.length; i++){
		datadata1[i]   = querydata.DATA[i].SAL1;
		datadata2[i]   = querydata.DATA[i].SAL2;
		datalabels[i] = querydata.DATA[i].ENAME;
	}

	var chartdata = {
		labels: datalabels,
		datasets: [{
			label: 'SAL1',		//凡例
			fill: false,		//面の表示
			lineTension: 0.5,		//線のカーブ
			data: datadata1,		
			backgroundColor: 	'rgba(255, 99, 132, 0.2)',
			borderColor:		'rgba(255,99,132,1)',
			borderWidth: 1
		},{
			label: 'SAL2',		//凡例
			fill: false,		//面の表示
			lineTension: 0.5,		//線のカーブ
			data: datadata2,		
			backgroundColor: [ "#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56","#FF6384", "#36A2EB", "#FFCE56" ],
			borderColor:		'rgba(75,192,192,1)',
			borderWidth: 1
		}]
	};

	<og:text>
	var myChart = new Chart( mycanvas,{
					type: '{@chartType}',
					data: chartdata,
					options: {
					     responsive: false
					}
				});
	</og:text>
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
