/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

// import org.opengion.fukurou.util.Attributes;
// import org.opengion.fukurou.util.StringUtil;
// import org.opengion.fukurou.util.TagBuffer;
// import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
// import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

import static org.opengion.fukurou.util.StringUtil.nval;

/**
 * TEXTRICH エディターは、カラムのデータをリッチテキストで編集する場合に
 * 使用するクラスです。
 * サイズ指定はsize1,size2で高さ,幅がpxで設定されます。
 * 初期値は250,600です。
 *
 * optionAttibutes属性にcleditorの設定が可能です。
 * 詳細は下記ページを参照してください。
 * http://www.premiumsoftware.net/cleditor/gettingstarted
 *
 * @og.rev 5.9.32.0 (2018/05/02) 新規作成
 * @og.group データ編集
 *
 * @version  5
 * @author   T.OTA
 * @since    JDK5.0,
 */
public class Editor_TEXTRICH extends Editor_TEXTAREA {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.9.6.0 (2018/05/07)" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 */
	public Editor_TEXTRICH() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

//	// デフォルトの値設定
//	private void defaultSet() {
//		size1 = "250";
//		size2 = "600";
//	}

	/**
	 * コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_TEXTRICH( final DBColumn clm ) {
		super( clm );

		// ※ 超絶特殊。未設定時は、super で、size1,2 に設定されているので、その値で判定します。
		if( cols1 == size1 ) { cols1 = "250"; }
		if( cols2 == size2 ) { cols2 = "600"; }

//		String  disabled = clm.isWritable() ? null : "disabled" ;
//
//		// size に、"height,width" を指定できるように変更
//		String param = StringUtil.nval( clm.getEditorParam(),clm.getViewLength() );
//		if( param != null && param.length() != 0 ) {
//			int st = param.indexOf( ',' );
//			if( st > 0 ) {
//				size1 = param.substring( 0, st );
//				size2 = param.substring( st + 1);
//			}else {
//				defaultSet();
//			}
//		}else {
//			defaultSet();
//		}
//
//		attributes = new Attributes();
//		attributes.addAttributes( clm.getEditorAttributes() );
//		tagBuffer.add( XHTMLTag.textareaAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_TEXTRICH( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの編集用文字列
	 */
	@Override
	public String getValue( final String value ) {
		final String id = nval( attributes.get( "id" ) , name );

		return super.getValue( value ) + createCLEditorSc( id );

//		String id = "";
//
//		TagBuffer tag = new TagBuffer( "textarea" );
//		tag.add( "name"    , name );
//
//		id = attributes.get( "id" );
//		optAttr = attributes.get( "optionAttributes" );
//		if( id == null || id.length() == 0 ) {
//			tag.add( "id"      , name );
//			id = name;
//		}
//		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );
//		tag.addBody( value );
//
//		return tag.makeTag() + createCLEditorSc(id);
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @param   row   行番号
	 * @param   value 入力値
	 *
	 * @return  データ表示/編集用の文字列
	 */
	@Override
	public String getValue( final int row,final String value ) {
		String newName = name + HybsSystem.JOINT_STRING + row;
		final String id = nval( attributes.get( "id" ) , newName );

		return super.getValue( row,value ) + createCLEditorSc( id );

//		String id = "";
//
//		TagBuffer tag = new TagBuffer( "textarea" );
//		String newName = name + HybsSystem.JOINT_STRING + row;
//		tag.add( "name"    , newName );
//		id = attributes.get( "id" );
//		if( id == null || id.length() == 0 ) {
//			tag.add( "id"      , newName );
//			id = newName;
//		}
//
//		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );
//		tag.addBody( value );
//
//		return tag.makeTag( row,value ) + createCLEditorSc(id);
	}

	/**
	 * CLEditorスクリプトを生成します。
	 *
	 * @param   id ID値
	 *
	 * @return  CLEditorスクリプト
	 */
	private String createCLEditorSc( final String id ) {

		StringBuilder buf = new StringBuilder( BUFFER_MIDDLE )
						.append("<script type='text/javascript'>")
						.append("var trg = $('#").append( id ).append("').cleditor({")
						.append("bodyStyle:''")
						.append(",height:"	).append(cols1)
						.append(",width:"	).append(cols2)
						.append(",controls: 'bold size | color highlight | removeformat | link unlink | undo redo'");

		String attr = attributes.get( "optionAttributes" );
		if(attr != null && attr.length() > 0) {
			buf.append(",").append(attr);
		}
		buf.append("})[0];")
			// editorをtextareaに反映(この処理で更新なしの場合も、><の文字ががエンコードされる。)
			.append("trg.updateTextArea();");
		// readonly属性が設定されている場合は、変更不可。
		if("readonly".equals(attributes.get("readonly"))) {
			buf.append("trg.disable('true');")
				// linkは新規ウィンドウに表示
				.append("$('#").append(id).append("').next('iframe').contents().find('a').attr('target','_blank');");
		}
		buf.append("</script>");

		return buf.toString();


//		StringBuilder js = new StringBuilder();
//		js.append("<script type='text/javascript'>");
//		js.append("var trg = $('#").append(id).append("').cleditor({");
//		js.append("bodyStyle:''");
//		js.append(",height:").append(size1);
//		js.append(",width:").append(size2);
//		js.append(",controls: 'bold size | color highlight | removeformat | link unlink | undo redo'");
//		String attr = attributes.get( "optionAttributes" );
//		if(attr != null && attr.length() > 0) {
//			js.append(",").append(attr);
//		}
//		js.append("})[0];");
//		// editorをtextareaに反映(この処理で更新なしの場合も、><の文字ががエンコードされる。)
//		js.append("trg.updateTextArea();");
//		// readonly属性が設定されている場合は、変更不可。
//		if("readonly".equals(attributes.get("readonly"))) {
//			js.append("trg.disable('true');");
//			// linkは新規ウィンドウに表示
//			js.append("$('#").append(id).append("').next('iframe').contents().find('a').attr('target','_blank');");
//		}
//		js.append("</script>");
//
//		return js.toString();
	}
}
