/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.system.HybsConst;

public final class ThrowUtil {
    public static final int MIN_STACK_SIZE = 3;
    private static final CaseBuilder C_BUF = new CaseBuilder();
    private static final StackTraceElement NULL_STE = new StackTraceElement("", "", "", -1);

    private ThrowUtil() {
    }

    public static String ogStackTrace(Throwable throwable) {
        return ThrowUtil.ogStackTrace(null, throwable);
    }

    public static String ogStackTrace(String string, Throwable throwable) {
        C_BUF.init().append("Version: ", "openGion 6.9.8.0 Release6 Builds (2018148)").append("Message: ", string);
        if (throwable != null) {
            C_BUF.append("Error  : ", throwable.getClass().getCanonicalName()).append("         ", throwable.getLocalizedMessage()).addStackTrace(throwable, 3);
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                C_BUF.append("Cause  : ", throwable2.getClass().getCanonicalName()).append("         ", throwable2.getLocalizedMessage()).addStackTrace(throwable2, 3);
            }
            for (Throwable throwable3 : throwable.getSuppressed()) {
                C_BUF.append("Suppressed : ", throwable3.getClass().getCanonicalName()).append("             ", throwable3.getLocalizedMessage()).addStackTrace(throwable3, 3);
            }
        }
        return C_BUF.toString().trim();
    }

    public static String ogThrowMsg(String string) {
        return ThrowUtil.ogThrowMsg(string, null);
    }

    public static String ogThrowMsg(String string, Throwable throwable) {
        C_BUF.init().append("Version: ", "openGion 6.9.8.0 Release6 Builds (2018148)").append("Message: ", string);
        if (throwable != null) {
            C_BUF.append("Error  : ", throwable.getClass().getCanonicalName()).append("         ", throwable.getLocalizedMessage());
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                C_BUF.append("Cause  : ", throwable2.getClass().getCanonicalName()).append("         ", throwable2.getLocalizedMessage());
            }
            for (Throwable throwable3 : throwable.getSuppressed()) {
                C_BUF.append("Suppressed : ", throwable3.getClass().getCanonicalName()).append("             ", throwable3.getLocalizedMessage());
            }
        }
        return C_BUF.toThrowMsg().trim();
    }

    public static StackTraceElement[] selectElement(Throwable throwable, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
        int n2 = 0;
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            String string = stackTraceElement.toString();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            String string2 = stackTraceElement.getClassName();
            boolean bl = true;
            if (n < 0 || n2 < n || string2.contains("org.opengion") || string2.contains("org.apache.jsp.jsp")) {
                arrayList.add(stackTraceElement);
                bl = true;
            } else if (bl) {
                arrayList.add(NULL_STE);
                bl = false;
            }
            ++n2;
        }
        return arrayList.toArray(new StackTraceElement[arrayList.size()]);
    }

    private static final class CaseBuilder {
        private static final String USE_KEY = "USE_KEY";
        private static final long CACHE_TIME = 3000L;
        private final ConcurrentMap<String, String> MSG_MAP = new ConcurrentHashMap<String, String>();
        private volatile long lastCall;
        private final List<String> list = new ArrayList<String>();

        public CaseBuilder init() {
            long l = System.currentTimeMillis();
            if (l - this.lastCall > 3000L) {
                this.lastCall = l;
                this.MSG_MAP.clear();
                this.list.clear();
            }
            return this;
        }

        public CaseBuilder append(String string, String string2) {
            String string3;
            if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty() && this.MSG_MAP.putIfAbsent(string3 = string2.trim(), USE_KEY) == null) {
                int n = string3.indexOf(10);
                if (n < 0) {
                    this.list.add(string + string3);
                } else {
                    String string4 = string3.substring(0, n).trim();
                    String string5 = string3.substring(n + 1).trim();
                    if (this.MSG_MAP.putIfAbsent(string4, USE_KEY) == null) {
                        this.list.add(string + string4);
                    }
                    if (this.MSG_MAP.putIfAbsent(string5, USE_KEY) == null) {
                        this.list.add(string + string5);
                    }
                }
            }
            return this;
        }

        public CaseBuilder addStackTrace(Throwable throwable, int n) {
            for (StackTraceElement stackTraceElement : ThrowUtil.selectElement(throwable, n)) {
                if (stackTraceElement == null || "".equals(stackTraceElement.getClassName())) {
                    this.append("    at   ", "....");
                    continue;
                }
                this.append("    at   ", stackTraceElement.toString());
            }
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (String string : this.list) {
                stringBuilder.append(HybsConst.CR).append(string);
            }
            return stringBuilder.toString();
        }

        public String toThrowMsg() {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (String string : this.list) {
                if (string.startsWith("    at   ")) continue;
                stringBuilder.append(HybsConst.CR).append(string);
            }
            return stringBuilder.toString();
        }
    }
}

