/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import java.util.UUID;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * TEXTAREA レンデラは、カラムのデータをリッチテキストで表示する場合に
 * 使用するクラスです。
 * readonlyのテキストエリアでname属性は付けません。(データは送信されません)
 * エリアの縦、横サイズはエディタのリッチテキストと同様にして算出されます。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 *  @og.rev 5.9.32.0 (2018/05/02) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Renderer_RICHTEXT extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.9.6.0 (2018/05/07)" ;

//	private final TagBuffer	tagBuffer = new TagBuffer();

	private  String		size1 = "150";
	private  String		size2 = "300";

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Renderer_RICHTEXT() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

//	// デフォルトの値設定
//	private void defaultSet() {
//		size1 = "150";
//		size2 = "300";
//	}

	/**
	 * コンストラクター
	 * textareaのサイズを決めるため、sizeとrowを決定する
	 * editorの計算を移植。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Renderer_RICHTEXT( final DBColumn clm ) {
		super();

		// size に、"height,width" を指定できるように変更
		final String param = StringUtil.nval( clm.getEditorParam(),clm.getViewLength() );
		if( param != null && param.length() != 0 ) {
			final int st = param.indexOf( ',' );
			if( st > 0 ) {
				size1 = param.substring( 0, st );
				size2 = param.substring( st + 1);
//			}else {
//				defaultSet();
			}
//		}else {
//			defaultSet();
		}
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return new Renderer_RICHTEXT( clm );
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		// uuidをidとして使用する
		final String uuid = UUID.randomUUID().toString();

		return new TagBuffer( "textarea" )
					.add( "id" , uuid )
	//				.add( tagBuffer.makeTag() )
					.addBody( value )
					.makeTag()
				+ createCLEditorSc( uuid );

//		// uuidをidとして使用する
//		String uuid = UUID.randomUUID().toString();
//
//		TagBuffer tag = new TagBuffer( "textarea" );
//		tag.add( "id" , uuid);
//		tag.add( tagBuffer.makeTag() );
//		tag.addBody( value );
//
//		return tag.makeTag() + createCLEditorSc(uuid);
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   row   行番号
	 * @param   value 入力値
	 *
	 * @return  データ表示用の文字列
	 */
	@Override
	public String getValue( final int row,final String value ) {
		// uuidをidとして使用する
		final String uuid = UUID.randomUUID().toString();

		return new TagBuffer( "textarea" )
					.add( "id" , uuid )
	//				.add( tagBuffer.makeTag() )
					.addBody( value )
					.makeTag( row,value )
				+ createCLEditorSc( uuid );

//		// uuidをidとして使用する
//		String uuid = UUID.randomUUID().toString();
//		TagBuffer tag = new TagBuffer( "textarea" );
//		tag.add( "id" , uuid);
//		tag.add( tagBuffer.makeTag() );
//		tag.addBody( value );
//
//		return tag.makeTag( row,value ) + createCLEditorSc(uuid);
	}

	/**
	 * CLEditorスクリプトを生成します。
	 *
	 * @param   id ID値
	 *
	 * @return  CLEditorスクリプト
	 */
	private String createCLEditorSc( final String id ) {
		return new StringBuilder( BUFFER_MIDDLE )
			.append( "<script type='text/javascript'>" )
			.append( "var trg = $('#").append( id ).append( "').cleditor({" )
			.append( "height:" ).append( size1 )
			.append( ",width:" ).append( size2 )
			.append( ",controls:''" )
			.append( ",bodyStyle:'background-color: transparent;'})[0];" )
			.append( "trg.disable('true');" )		// 操作の無効化
			.append( "trg.$toolbar.remove();" )	// メニューバーの削除
			.append( "trg.$main.css('background-color','transparent');" )		// bodyのstyle設定
			// linkは新規ウィンドウに表示
			.append( "$('#").append(id).append( "').next('iframe').contents().find('a').attr('target','_blank');" )
			.append( "</script>" )
		 	.toString();

//		StringBuilder js = new StringBuilder();
//		js.append("<script type='text/javascript'>");
//		js.append("var trg = $('#").append(id).append("').cleditor({");
//		js.append("height:").append(size1);
//		js.append(",width:").append(size2);
//		js.append(",controls:''");
//		js.append(",bodyStyle:'background-color: transparent;'})[0];");
//		js.append("trg.disable('true');");	// 操作の無効化
//		js.append("trg.$toolbar.remove();");	// メニューバーの削除
//		js.append("trg.$main.css('background-color','transparent');");	// bodyのstyle設定
//		// linkは新規ウィンドウに表示
//		js.append("$('#").append(id).append("').next('iframe').contents().find('a').attr('target','_blank');");
//		js.append("</script>");
//		return js.toString();
	}
}
