<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false">
<!-- 2018/06/29 DELETE リッチテキスト実装により、自動リンクは削除
	<script type="text/javascript" src="{@SYS.JSP}/common/option/urlAutoLink.js"><!-- --></script>
 -->
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQ"
	title	= "標準(FAQ表示)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
>
	2018/06/29	T.OTA	05200-180319-01 ﾃｷｽﾄｴﾘｱをﾘｯﾁﾃｷｽﾄに変更。
</og:comment>

<!-- この画面限定動作、スタイルのためとりあえずcommonには持ち込みません -->
<script style="text/javascript">
	$(function(){
	     $("#qtable a").click(function(){
	     $('html,body').animate({ scrollTop: $($(this).attr("href")).offset().top-60 }, 'fast','swing');
	     $('#back-title-link a').attr('href','#'+$(this).attr('id'));
	     $('#back-title-link').css('display','block');
	     return false;
	     })
	});

	$(function(){
	     $("#back-title-link a").click(function(){
	     $('html,body').animate({ scrollTop: $($(this).attr("href")).offset().top-60 }, 'fast','swing');
	     $('#back-title-link').css('display','none');
	     return false;
	     })
	});

</script>

<!-- 明細ｽﾀｲﾙ指定-->
<style type="text/css">
	div#atable{
		padding:2px;
	}
	div#qtable{
		padding:2px;
	}
	div.FAQBUNRUI1	{
		font-weight:bold;
		font-size:medium;
		width:80%;
		border-left: 5px solid #1e50a2;
		border-bottom: 1px solid #1e50a2;
		margin:4px;
		padding:5px;
	}
	div.FAQBUNRUI2	{
		font-weight:bold;
		 font-size:small;
		 text-indent:1em;
		 margin:4px;
	}
	div.FAQBUNRUI3	{
		font-weight:bold;
		text-indent:1em;
		font-size:x-small;
	}
	div.FAQ_TITLEWRAP{
		margin:5px 0 0 0;
	}
	div.FAQTITLE{
		border-left: 5px solid #d3381c;
		padding-left: 5px;
		margin:5px 0px 0px 2em;
		font-weight:bold;
		font-size:small;
	}
	div#atable div.FAQTITLE{
		color:#17184b;
	}
	span.FAQNO{
		font-size:small;
		margin-left:15px;
	}
	div.FAQNAIYO	{
		
		margin-left:2em;
		margin-bottom:15px;
		padding-left:5px;
		border-left: 1px solid #ce5242;
		border-bottom: 1px solid #ce5242;
		width:90%
	}
	pre {
		white-space: -moz-pre-wrap; /* Mozilla */
		white-space: -pre-wrap;     /* Opera 4-6 */
		white-space: -o-pre-wrap;   /* Opera 7 */
		white-space: pre-wrap;      /* CSS3 */
		word-wrap: break-word;      /* IE 5.5+ */
	}

</style>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- とりあえず小分類が増えた時の事は考えずに作成します -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request" dbid="RESOURCE">
		SELECT	A.CDBNRUI		AS DAICD
				,A.TITLE		AS DAITITLE
				,B.CDBNRUI
				,B.TITLE
				,C.KBFAQ
				,B.NAIYO
				,A.SYSTEM_ID
				,CASE WHEN A.SYSTEM_ID = '**' THEN '1'
						ELSE '0' END SYS_SEQNO
				,A.SEQNO
				,B.SEQNO
				,B.QANO
				,'' FILE1
				,'' FILE2
				,'' FILE3
				,B.UNIQ
		FROM	(GE80 A LEFT OUTER JOIN GE80 C
				ON	A.SYSTEM_ID in ( C.SYSTEM_ID , '**' )
				AND	A.SYSCODE in ( C.SYSCODE , '*' )
				AND	C.CDBNRUI LIKE A.CDBNRUI{@DBF.CON}'%'
				AND C.FGJ = '1'
				AND C.KBFAQ >= '1'
				) LEFT OUTER JOIN GE80 B
				ON	A.SYSTEM_ID in ( B.SYSTEM_ID , '**' )
				AND	A.SYSCODE IN ( B.SYSCODE , '*' )
				AND	C.CDBNRUI = B.CDBNRUI
				AND	B.KBFAQ = '0'
				AND	B.FGJ = '1'
				<og:where startKey="and">
					<og:and value = "B.QANO			LIKE	'%{@QANO}%'"		/>	<!-- GE80(FAQ)》質問番号 LIKE %画面》質問番号%		-->
					<og:and value = "B.CDBNRUI		LIKE	'{@CDBNRUI}%'"		/>	<!-- GE80(FAQ)》分類 LIKE  画面》分類%				-->
					<og:and value = "B.KNRNGUI		LIKE	'%{@KNRNGUI}%'"		/>	<!-- GE80(FAQ)》関連画面ID LIKE %画面》関連画面ID	-->
					<og:and value = "(B.TITLE		LIKE	'%{@KEYWORD}%'	OR
									  B.NAIYO		LIKE	'%{@KEYWORD}%'	OR
									  B.TAG			LIKE	'%{@KEYWORD}%')"	/>	<!-- GE80(FAQ)》ﾀｲﾄﾙ､内容､ﾀｸﾞｷｰﾜｰﾄﾞ LIKE %画面》ｷｰﾜｰﾄﾞ%	-->
				</og:where>
			WHERE	A.SYSTEM_ID	IN	('{@SYS.SYSTEM_ID}','**')
		<og:where startKey="and">
			<og:and value = "A.FGJ			=		'1'"			/>	<!-- GE80(FAQ)》状態ﾌﾗｸﾞ IN ('0','1')				-->
			<og:and value = "A.KBFAQ		=		'1'"				/>	<!-- GE80(FAQ)》FAQ区分 = '0'						-->
			<og:and value = "A.SYSCODE		IN		('{@SYSCODE}','*')"		/>	<!-- GE80(FAQ)》ｼｽﾃﾑｺｰﾄﾞ = 画面》ｼｽﾃﾑｺｰﾄﾞ			-->
			<og:and value = "B.UNIQ IS NOT NULL" />
		</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "SYS_SEQNO,A.SYSCODE,A.SEQNO,B.SEQNO" />
</og:query>
<!-- 2018/06/29 PREからRICHLABELに変更
<og:columnEditor columns="NAIYO" renderer="PRE" scope="request"/>
-->
<og:columnEditor columns="NAIYO" renderer="RICHLABEL" scope="request" />
<og:columnEditor columns="CDBNRUI" editor="DBMENU" scope="request" dbid="RESOURCE">
	SELECT	CDBNRUI,TITLE
	FROM	GE80
	WHERE	FGJ	IN	('0','1')
	AND		SYSTEM_ID in ('{@SYS.SYSTEM_ID}','**')
	AND		SYSCODE in ('{@USER.SYSCODE}','*')
	AND		KBFAQ != '0'
	ORDER BY SYSTEM_ID,SYSCODE,SEQNO
</og:columnEditor>
<!-- ViewMarkerTag	-->
<og:viewMarker command="{@command}">
	<!-- 分類名-->
	<og:columnMarker column="DAITITLE">
		<div class="FAQBUNRUI1">[DAITITLE]</div>
	</og:columnMarker>
	<og:columnMarker column="CDBNRUI" markList="[KBFAQ]"  onMark="1">
		<span><!-- --></span>
	</og:columnMarker>
	<og:columnMarker column="CDBNRUI" markList="[KBFAQ]"  onMark="2">
		<div class="FAQBUNRUI2">[CDBNRUI]</div>
	</og:columnMarker>
	<og:columnMarker column="CDBNRUI" markList="[KBFAQ]"  onMark="3">
		<div class="FAQBUNRUI3">[CDBNRUI]</div>
	</og:columnMarker>
	<!-- ﾀｲﾄﾙ-->
	<og:columnMarker column="TITLE">
		<div class="FAQTITLE">[TITLE]<span class="FAQNO"><og:message lbl="MSG0084" val0="[QANO]"/></span></div>
	</og:columnMarker>
	<!-- 内容-->
	<og:columnMarker column="NAIYO">
		<span class="FAQNAIYO">[NAIYO]</span>
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<!-- 添付ﾌｧｲﾙ-->
	<og:link column="FILE1" href="filedown.jsp" useGamenId="false" keys="UNIQ,fname" vals="[UNIQ],FILE1" />
	<og:link column="FILE2" href="filedown.jsp" useGamenId="false" keys="UNIQ,fname" vals="[UNIQ],FILE2" />
	<og:link column="FILE3" href="filedown.jsp" useGamenId="false" keys="UNIQ,fname" vals="[UNIQ],FILE3" />
</og:viewLink>

<!-- 上矢印 -->
<div style="position:fixed;top:10px;right:10px;display:none;" id="back-title-link">
	<a href="#faqtable"><og:img src="{@SYS.JSP}/image/arrow-up.png" alt="back to question"/></a>
</div>

<!-- DB検索結果を表示させます。 -->
<og:img src="{@SYS.JSP}/image/speech-balloon-orange-q48.png" alt="Question" />
<div id="qtable">
<og:view
	viewFormType = "CustomData" 
	command      = "{@command}" 
	writable     = "false"
	columnGroup = "CDBNRUI,DAITITLE"
	useAfterHtmlTag  = "false"
	noDisplay    = ""
	scope="request">
	<og:thead rowspan="1">
		<tr><td><!-- --></td></tr>
	</og:thead>
	<!-- 分類表示	-->
	<og:tbody rowspan="1">
			[$DAITITLE]
			[$CDBNRUI]				<!-- 分類-->
			<div class="FAQ_TITLEWRAP"><a href="#[$QANO]" id="[$QANO]TITLE">[$TITLE]</a></div>	<!-- ﾀｲﾄﾙ-->
	</og:tbody>
</og:view>
</div>

<!-- DB検索結果を表示させます。 -->
<hr width="95%"/>
<og:img src="{@SYS.JSP}/image/speech-balloon-green-a48.png" alt="Answer" />
<div id="atable">
<og:view
	viewFormType = "CustomData" 
	command      = "VIEW" 
	writable     = "false"
	useAfterHtmlTag  = "false"
	columnGroup = "CDBNRUI,DAITITLE"
	noDisplay    = ""
	scope="request">
	<og:thead rowspan="1">
		<tr><td><!-- --></td></tr>
	</og:thead>
	<!-- 分類表示	-->
	<og:tbody rowspan="1">
			[$DAITITLE]
			[$CDBNRUI]				<!-- 分類-->
			<div class="FAQ_TITLEWRAP">[$TITLE]</div>	<!-- ﾀｲﾄﾙ-->
		<div  id="[$QANO]">
			<div class="FAQNAIYO">[$NAIYO]</div>													<!-- 内容-->
		</div>
	<!-- 添付ﾌｧｲﾙ	-->
	<table>
		<tr>
			<td>[$FILE1]</td>						<!-- 添付1-->
		</tr>
		<tr>
			<td>[$FILE2]</td>						<!-- 添付2-->
		</tr>
		<tr>
			<td>[$FILE3]</td>						<!-- 添付3-->
		</tr>
	</table>
	</og:tbody>
</og:view>
</div>

<!-- 2018/06/29 DELETE リッチテキスト実装により、自動リンクは削除
<script>
	 $("span.FAQNAIYO").urlAutoLink();
</script>
 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
