<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:key name="ext" match="method/htmlExtend" use="htmlExtend" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <xsl:variable name="systemId"  select="systemId" />
    <ROWSET tableName="GE12">
      <EXEC_SQL>delete from GE12 where SYSTEM_ID='**' and KBSAKU='0'</EXEC_SQL>
      <xsl:for-each select="fieldDoc">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="fieldDoc" />
          </xsl:attribute>
          <SYSTEM_ID><xsl:value-of select="$systemId" /></SYSTEM_ID>
          <PARAM_ID><xsl:value-of select="paramId" /></PARAM_ID>
          <SEQNO><xsl:value-of select="seq" /></SEQNO>
          <TITLE><xsl:value-of select="title" /></TITLE>
          <PARAM><xsl:value-of select="param" /></PARAM>
          <CONTENTS><xsl:value-of select="contents" /></CONTENTS>
          <PARAM_LVL><xsl:value-of select="paramLevel" /></PARAM_LVL>
          <FGCRYPT>
            <xsl:variable name="crypt" select="fgcrypt" />
            <xsl:choose>
              <xsl:when test="$crypt!='1'">0</xsl:when>
              <xsl:otherwise><xsl:value-of select="$crypt" /></xsl:otherwise>
            </xsl:choose>
          </FGCRYPT>
          <KBSAKU>0</KBSAKU>
          <FGJ>1</FGJ>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
