/*
 * showModalDialogを上書きして、IE限定のshowModalDialogではなく、独自実装のダイアログを表示します。
 * 内部でIframeを作成し、その中にURLの内容を表示します。
 * JSP内でこの.jsとhtml5modalDialog.cssを読み込む事で、エンジンのポップアップは自動的にこのタイプに変更されます。
 * コントロール可能な最上位フレームにiframeを作成し、表示します。
 * クロスドメインの小さなフレーム内で利用した場合はフレーム内に内容が表示しきれず、スクロールが必要になります。
 * ポップアップ内の閉じるボタンが存在する場合は、Windowを閉じてしまうため注意が必要です。
 *
 * 元：https://github.com/Mehuge/showModalDialog/tree/master/showModalDialog
 * PromiseがIEで利用できない事と、jQuery1.4対応、エンジンとの互換性の変更を行っています。
 *
 * ユーザ側が利用する可能性のあるファンクションは、全てポップアップ側でCallする以下のファンクションです。
 * getPopParent(); //呼び元のwindowオブジェクト取得
 * getPopArgs();   //Call時の引数配列取得
 * setPopCallback( f ); // Close時のCallbackセット
 * popClose();     //ポップアップを閉じる
 *
 * [Options]
 * width,height,left,top,closeIcon
 *
 * @og.rev 5.8.9.0 (2015/08/07) Takahashi Masakazu & oota
 * @og.rev 5.9.1.3 (2015/10/30) 出来る限り上位フレームで表示する、URLを絶対パス変換してから利用する
 * @og.rev 5.9.5.1 (2016/02/12) ドラッグ、リサイズ処理等の追加
 * @og.rev 5.9.6.0 (2016/03/01) style変更
 * @og.rev 5.9.8.0 (2015/05/02) close時の処理追加
 * @og.rev 5.9.8.1 (2016/05/13) ajax利用をやめる
 * @og.rev 5.9.12.2 (2016/09/16) frame_checkとhybsDraggableの引数修正対応
 * @og.rev 5.9.16.0 (2017/01/13) close時のfocus変更
 * @og.rev 5.9.16.1 (2017/01/20) close時にfocusをblur
 * @og.rev 5.9.20.0 (2017/05/02) close時にwindowをemptyした上でiframeをnullにする
 * @og.rev 5.9.27.4 (2017/12/28) キャレット対応
*/
function showModalDialog(tgturl, args, options, p_this,p_out_Array,p_append) {
    options = options || {};
    var closeIcon = options.closeIcon || '../image/close.gif';
    // 絶対パスに変換
    closeIcon = absolutePath( closeIcon );
    tgturl = absolutePath( tgturl );
    
    var rtn;
//    var tgt_frame= frame_check(window); // 5.9.1.3
	var tgt_window= frame_check(window); //5.9.12.2 (2016/09/16)
    var tgt_frame= tgt_window.document.body; 
    var close_callback = function(){}; // 5.9.5.1
    tgt_frame.popParent = window;

    // 5.9.8.1 (2016/05/13)
    //元々ajaxでのsuccess応答でiframeを作成していたが、即時実行とする。
//    $.ajax({
//    	url:tgturl
//    	,success:function (r) {
    (function(){
    		var cover,iframe,content;
	        cover = $('<div>')
	            .addClass('popcover')
//	            .appendTo(document.body);
	            .appendTo( tgt_frame );
	        var close = function () {
	        		$("input").first().focus().blur(); // 2017/01/20 focusが当たらなくなる問題対策
	        		if( getPopParent() != null ){
	        			if( p_this ){
		        			p_this.focus(); // 5.9.16.0 (2017/01/13)
		        		}
		        		else{
			        		getPopParent().focus(); // 5.9.8.0(2016/05/02)
			        	}
		        	}
	        		if( arguments.length == 0){
		        		close_callback();
		        	}
		        	if( iframe != null ){
			        	var iframeWindow
							 = iframe.contentWindow; // 2017/04/28
						$(iframeWindow).empty();
						iframe.attr('src', 'about:blank');
			        	iframe.empty(); // 2017/01/20 focusが当たらなくなる問題対策
		                iframe.remove();
		                iframe=null;
		            }
	                content.remove();
	                cover.remove();
	                tgt_frame.popParent = null; // 5.9.8.0 (2016/05/02)
	            };
	        content = $('<div>')
	            .addClass('popdialog')
	            .css({
	                width: options.width || '85%',
	                height: options.height || '85%',
	                left: options.left || '5%',
	                top: options.top || '5%',
	                display: 'none'
	            })
//	            .appendTo(document.body);
	            .appendTo( tgt_frame );
	       
	       // 5.9.5.1 resizediv,headdiv
	        var resizediv = $('<div>')
	        		.addClass('popresize')
	        		.css({
	        			position: 'absolute',
	        			bottom: '0px',
	        			right: '0px',
	        			padding: '0',
	        			margin: '0',
	        			cursor: 'nw-resize'
	        		})
	        		.appendTo( content );
	        
	        // 5.9.6.0 margin,paddingをcssファイルに
	        var headdiv = $('<div>')
	        		.addClass('pophead')
	        		.css({
	        			position: 'absolute',
	        			top: '0px',
	        			right: '0px'
	        		})
	        		.bind("click",function(){
	            		close();
	            	})
	        		.appendTo( content )
	            
	        iframe = $('<iframe>').appendTo(content).attr("src", tgturl)
	            .bind("load", function () {
	                content.css({ display: 'block' });
	            });
	            
	        var closeButton= $('<div>')
	        	.addClass('closeButton')
	            .css({ width: '100%', left: '0px', top: '0px' })
	        	.appendTo(cover)
	        	.bind("click",function(){
	            	close();
	            })
	            .append('<img src="'+closeIcon+'" style="left:' +content.css("left")+ ';"/>');
	        showModalDialog.dialogArguments = args;
	        // ポップアップ先からCallされる
	        showModalDialog.returnValue = function (v) {
	            close(v);
				ogPchangeData(v,p_this,p_out_Array,p_append); // 独自関数
	        };
	        showModalDialog.cancel = function () {
	            close();
	        };
	        showModalDialog.setCallback = function(f){
	        	close_callback = f;
	        }
	        showModalDialog.getPopParent = function(){ // 5.9.6.1 (2016/03/04)
	        	return tgt_frame.popParent;
	        }
	        
	        // 元画面アンロード時 5.9.5.1
	        $(tgt_frame.popParent).unload( function(){close(1);} );
	        
	        //hybsDraggable( content, tgt_frame );
	        hybsDraggable( content, tgt_window ); // 5.9.12.2 (2016/09/16) window渡しに変更
	        hybsResizable( resizediv, tgt_frame );
   })();
}

// ポップアップの呼び元のwindowオブジェクト取得
// @og.rev 5.9.6.1 (2016/03/04) 新規作成
function getPopParent() {
	if(parent.document.body.popParent){
			return parent.document.body.popParent;
	}
	else if(parent.parent.document.body.popParent){
			return parent.parent.document.body.popParent;
	}
	else if(parent.parent.parent.document.body.popParent){
			return parent.parent.parent.document.body.popParent;
	}
	return null;
}

// dialogArguments取得の代わり
// 引数を取得したい場合はこの関数をCallしてください。
// @og.rev 5.9.5.1 (2016/02/12) 新規作成
// @og.rev 5.9.6.1 (2016/03/04) popParent利用化
function getPopArgs() {
	if( typeof window.dialogArguments != "undefined" ){
		return window.dialogArguments;
	}
	else{
		var popp = getPopParent();
		if( popp != null){
			return popp.showModalDialog.dialogArguments;
		}
//		if(parent.document.body.popParent){
//			return parent.document.body.popParent.showModalDialog.dialogArguments;
//		}
//		else if(parent.parent.document.body.popParent){
//			return parent.parent.document.body.popParent.showModalDialog.dialogArguments;
//		}
	}
}



// close時に実行したい処理がある場合に無名関数でセットします。
// setPopCallback( function(){ rtnPopup('1'); } );
// setPopCallback( function(){ getPopParent().orgFunc('1'); } );
// ※rtnValueでの自動Closeする際、立ち上げ元unload時の自動close処理、この２つではcllback処理はされません。
// @og.rev 5.9.5.1 (2016/02/12) 新規作成
// @og.rev 5.9.6.1 (2016/03/04) popParent利用化
function setPopCallback( f ) {
	var popp = getPopParent();
	if( popp != null){
		popp.showModalDialog.setCallback(f);
	}
//	if(parent.document.body.popParent){
//		parent.document.body.popParent.showModalDialog.setCallback(f);
//	}
//	else if(parent.parent.document.body.popParent){
//		parent.parent.document.body.popParent.showModalDialog.setCallback(f);
//	}
}

// 閉じる
// @og.rev 5.9.6.1 (2016/03/04) 新規作成
function popClose() {
	var popp = getPopParent();
	if( popp != null){
		popp.showModalDialog.cancel();
	}
}


// コントロール可能な上位フレームを探して返す 5.9.1.3 (2015/10/30)
// 該当最上位フレーム(通常はindex.jsp)にjQueryとcssが必要
// 5.9.12.2(2016/09/16) returnをbodyではなくwindow本体に変更する
function frame_check(_tgtwindow){
	// 上位フレーム無しの場合
	if(_tgtwindow.parent.document.URL == _tgtwindow.document.URL){
//		return _tgtwindow.document.body ;
		return _tgtwindow ;
	}
	//それ以外の場合はコントロール可能な親フレームを返す
	// 親フレームがコントロール可能な場合は再帰処理。try-cathcで判定しておく
	try{
		var ck = $(_tgtwindow.parent.document.body); // 読める場合はコントロール可能なはず
		var rtn = frame_check(_tgtwindow.parent);
		// frameの場合と、既にpopcoverが存在する場合はNG
//		if( rtn.getElementsByTagName('frame').length > 0 ){
		if( rtn.document.body.getElementsByTagName('frame').length > 0 ){
//			return _tgtwindow.document.body
			return _tgtwindow;
		}
//		else if ( $(rtn).find('.popcover').length > 0 ){
		else if ( $(rtn.document.body).find('.popcover').length > 0 ){
//			return _tgtwindow.document.body
			return _tgtwindow;
		}
		else{
			return rtn;
		}
	}
	catch(e){
//		return _tgtwindow.document.body ;
		return _tgtwindow;
	}
//	return _tgtwindow.document.body ;
	return _tgtwindow ;
}

// 絶対パスに変換
function absolutePath(path) {
    var e = document.createElement('span');
    e.innerHTML = '<a href="' + path + '" />';
    return e.firstChild.href;
}

// ogPopupのshowDialog呼出し以降の処理をそのまま別ﾒｿｯﾄﾞ化
function ogPchangeData(ret_val, p_this,p_out_Array, p_append){
	var	_oldTmpVal;
	// 戻り値が文字列の場合は、配列に変換
	if( ( ret_val != null ) && ( typeof ret_val !== "object" ) ){
		ret_val = new Array( ret_val );
	}

	// 5.8.5.0 (2015/02//6) キャレットの位置を取得
	var getCaretPositionIE = function( elem ){
		elem.focus();
		// 5.9.27.4 (2017/12/28) selection廃止対応
		if (document.selection != undefined) {
			var range = document.selection.createRange();
			range.moveStart( "character", - elem.value.length );
			var caret_position = range.text.length;
			return caret_position;
		}
		else{
			var index = elem.selectionStart;
			var length = elem.selectionEnd - index;
			// キャレット位置を挿入した文字列の最後尾に移動する場合の例
			//elem.focus();
			//var newCaretPosition = index + txt.length;
			//elem.setSelectionRange(
			//newCaretPosition, newCaretPosition);
			return index; // 5.9.29.3 (2018/02/23)
		}
	}

	// 5.5.3.0 changeイベントを起こすオブジェクトを保存しておいて、後からキックする
	var changes_obj = new Array();

	// 5.8.3.0, 5.8.3.1
	// 出力引数に、ポップアップからの戻り値を設定
	if( ret_val != null && p_out_Array != null ) {
		for( j=0; ( j<p_out_Array.length && j<ret_val.length ) ; j++ ) {
			if( p_out_Array[j] != '' ) {
				tmp = p_this.form.elements[p_out_Array[j]];
				if( tmp != null ) {
					// ヘッダー固定のBulkSet対応
					if( p_out_Array[j].indexOf( "h_" ) == 0 && tmp.length ) {
						for( var k=0; k<tmp.length; k++) {
							_oldTmpVal = tmp[k].value;

							if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
								var caret_position = getCaretPositionIE(tmp[k]);
								tmp[k].value = tmp[k].value.substring(0,caret_position) + ret_val[j] + tmp[k].value.substring(caret_position,tmp[k].value.length); 
							}
							else{
								tmp[k].value = ret_val[j];
							}
							// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
							if( _oldTmpVal != ret_val[j] ){
								changes_obj[changes_obj.length] = tmp[k];
							}
						}
					}
					else {
						_oldTmpVal = tmp.value;

						if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
							var caret_position = getCaretPositionIE(tmp);
							tmp.value = tmp.value.substring(0,caret_position) + ret_val[j] + tmp.value.substring(caret_position,tmp.value.length); 
						}
						else{
							tmp.value = ret_val[j];
						}
						// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
						if( _oldTmpVal != ret_val[j] ){
							changes_obj[changes_obj.length] = tmp;
						}
					}
				}
			}
		}
	}
	// 5.5.3.0
	for( i=0; i<changes_obj.length; i++){
		$(changes_obj[i]).change();
	}
		
	// 5.5.1.5 (2012/04/12) 先頭が_RENEWの場合は[1]をRENEW付きでcall
	if( ret_val != null && ret_val[0] == '_RENEW' ){
		if(ret_val[1].indexOf('?') > 0 ){
			location.href=ret_val[1]+'&command=RENEW';
		}
		else{
			location.href=ret_val[1]+'?command=RENEW';
		}
	}
}

// 独自実装のdrag移動(jQueryのプラグインは使わない)
// @og.rev 5.9.5.1 (2016/02/12) 新規作成
// @og.rev 5.9.12.2 (2016/09/16) 引数をbodyからwindow化してスクロール時の動作修正、ドラッグのスムーズ化、冗長処理の削除
function hybsDraggable( _tgt, _tgtwin ){
	var dragging = false;
	var x,y;
	var left,top;
	var _tgtdoc = _tgtwin.document.body;
	var _content
	$(_tgt).mousedown( function(evt){
		    x = evt.offsetX || evt.layerX;//相対位置
		    y = evt.offsetY || evt.layerY;
		    if( !dragging ){
			    dragging = true;
			    var rect = $(this).offset();
//			    var left = window.pageXOffset || window.document.documentElement.scrollLeft;
//			    var top  = window.pageYOffset || window.document.documentElement.scrollTop;
//			    this.style.left = left + rect.left + 'px';
//			    this.style.top  = top  + rect.top  + 'px';

				// 内側のドラッグ対策
			    _content = $('<div>')
	            .addClass('resizecover')
	            .css({
	                width: '99%',
	                height: '99%',
	                left:  '0px',
	                top:  '20px',
	                position: 'absolute',
	                background: 'transparent'
	            }).appendTo( this )
	            .click(function(){ $(this).remove();});

			    return false;
			}
			else{
				dragging = false;
			}
		});
	$(_tgtdoc).mouseup( function(evt){
	  if(dragging){
		  dragging = false;

		  var rect = $(_tgt).offset();
//		  if( rect.left < 0 ){ rect.left = 0; }
//		  if( rect.top < 0 ){ rect.top = 0; }
//		  $(_tgt).css('left', (rect.left ) + 'px');
//		  $(_tgt).css('top',  (rect.top )  + 'px');

		  if( rect.left < 0 ){ $(_tgt).css('left','0px'); }
		  if( rect.top < 0 ){ $(_tgt).css('top',  '0px'); }
		  _content.remove();
		}
	});
	$(_tgtdoc).mousemove( function(evt){
	  if(dragging){
	    left = _tgtwin.pageXOffset || _tgtwin.document.documentElement.scrollLeft;
		top  = _tgtwin.pageYOffset || _tgtwin.document.documentElement.scrollTop;
	    $(_tgt).css('left', (evt.clientX  - x +left) + 'px'); 
	    $(_tgt).css('top', (evt.clientY - y + top) + 'px');
	    return false;
	  }
	});
}


// 独自実装のリサイズ処理(jQueryのプラグインは使わない)
// @og.rev 5.9.5.1 (2016/02/12) 新規作成
function hybsResizable( _tgt, _tgtdoc ){
	var dragging = false;
	var _tgtParent;
	var _content
	var x,y;
	var pheight,pwidth;
	$(_tgt).mousedown( function(evt){
		    x = evt.clientX;
		    y = evt.clientY;
		    _tgtParent = this.parentNode;
		    pheight = $(_tgtParent).height();
		    pwidth = $(_tgtParent).width();
		    if( !dragging ){
			    dragging = true;
			    
			    // 内側のドラッグ対策
			    _content = $('<div>')
	            .addClass('resizecover')
	            .css({
	                width: '99%',
	                height: '99%',
	                left:  '0px',
	                top:  '0px',
	                position: 'absolute',
	                background: 'transparent'
	            }).appendTo( _tgtParent )
	            .click(function(){ $(this).remove();});
			    
			    
			    evt.stopPropagation();
			    return false;
			}
			evt.stopPropagation();
		});
	$(_tgtdoc).mouseup( function(evt){
	  if(dragging){
		  dragging = false;
		  if( $(_tgtParent).width() < 50 ){ $(_tgtParent).width( '50px' );}
		  if( $(_tgtParent).height() < 50 ){ $(_tgtParent).height( '50px' );}
		  _content.remove();
		}
	});
	$(_tgtdoc).mousemove( function(evt){
	  if(dragging){
	    var left = x - evt.clientX;
	    var top  = y - evt.clientY;
	    $(_tgtParent).width( pwidth - left + 'px');
	    $(_tgtParent).height( pheight - top + 'px');
	    return false;
	  }
	});
	
}

// defaultの上書き
// @og.rev 5.9.1.3 (2015/10/30) 上位フレーム表示対応
// @og.rev 5.9.4.3 (2016/01/15) 返せない場合、一段階までは親を見るように変更
// @og.rev 5.9.8.0 (2016/05/02) popParent取得方法変更
function rtnPopup( rtnValue ) {
	window.returnValue = rtnValue;
	var popp = getPopParent();
	if( popp != null){
		popp.showModalDialog.returnValue(rtnValue);
	}
	
	//parent.showModalDialog.returnValue(rtnValue);
//	if(parent.document.body.popParent){
//		parent.document.body.popParent.showModalDialog.returnValue(rtnValue); // 5.9.1.3
//	}
//	else if(parent.parent.document.body.popParent){
//		parent.parent.document.body.popParent.showModalDialog.returnValue(rtnValue);
//	}
}

// defaultの上書き 
function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,command,p_append,event ) {
	var height , width , url , sTmp , param , ret_val , tmp , i , j , _oldTmpVal ;

	if( p_height != null ) { height = p_height; }
	if( p_width  != null ) { width	= p_width;	}
	
	// 5.8.3.0 (2014/01/09) height,width の "px" 処理の修正
	height = p_height ? parseInt(p_height, 10) + "px" : "85%" ;
	width  = p_width  ? parseInt(p_width , 10) + "px" : "85%" ;

	// ポップアップ画面定義
	url  =	p_pgid + "?command=" + ( command ? command : "NEW" );
//	sTmp = 'resizable:on; dialogHeight:' + height + ';dialogWidth:' + width;		// 5.7.5.0 (2014/04/04)
	sTmp = {};
	sTmp.height = height;
	sTmp.width  = width;
	
	if( event ) {
//		sTmp = sTmp + ';dialogLeft:' + event.screenX + 'px;' + 'dialogTop:' + event.screenY + 'px';
		sTmp.left = event.screenX + 'px';
		sTmp.top = event.screenY + 'px';
	}

	// 入力引数の設定
	if( p_in_Array != null ) {
		for( i=0; i<p_in_Array.length; i+=2 ) {
			url = url + "&" + p_in_Array[i] + "=" + encodeURIComponent( p_in_Array[i+1]);  // 5.2.0.0 (2010/09/01)
		}
	}

	// ポップアップ画面
	param = "";
	if( ( p_out_Array != null ) && ( document.getElementById( p_out_Array[0] ) ) ){
		param = document.getElementById( p_out_Array[0] ).value;
	}
	// oota modify 引数を変更
	// ret_val = showModalDialog( url,param,sTmp);
	ret_val = showModalDialog( url,param,sTmp ,p_this,p_out_Array,p_append );

	// 以降の処理をshowModalDialogとして別ﾒｿｯﾄﾞ化
}
