/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.octavia.LbMethod;
import org.openstack4j.model.octavia.LbPoolV2;
import org.openstack4j.model.octavia.Protocol;
import org.openstack4j.model.octavia.SessionPersistence;
import org.openstack4j.model.octavia.builder.LbPoolV2Builder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.octavia.domain.ListItem;

@JsonRootName(value="pool")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaLbPoolV2
implements LbPoolV2 {
    private String id;
    @JsonProperty(value="project_id")
    private String projectId;
    private String name;
    private String description;
    private Protocol protocol;
    @JsonProperty(value="lb_algorithm")
    private LbMethod lbMethod;
    @JsonProperty(value="session_persistence")
    private SessionPersistence sessionPersistence;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    @JsonProperty(value="listener_id")
    private String listenerId;
    private List<ListItem> listeners;
    private List<ListItem> members;
    @JsonProperty(value="healthmonitor_id")
    private String healthMonitorId;

    @Override
    public LbPoolV2Builder toBuilder() {
        return new LbPoolV2ConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public LbMethod getLbMethod() {
        return this.lbMethod;
    }

    @Override
    public SessionPersistence getSessionPersistence() {
        return this.sessionPersistence;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public List<ListItem> getListeners() {
        return this.listeners;
    }

    @Override
    public List<ListItem> getMembers() {
        return this.members;
    }

    @Override
    public String getHealthMonitorId() {
        return this.healthMonitorId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("name", (Object)this.name).add("description", (Object)this.description).add("protocol", (Object)this.protocol).add("lbMethod", (Object)this.lbMethod).add("sessionPersistence", (Object)this.sessionPersistence).add("adminStateUp", this.adminStateUp).add("listenerId", (Object)this.listenerId).add("listeners", this.listeners).add("members", this.members).add("healthMonitorId", (Object)this.healthMonitorId).toString();
    }

    public static LbPoolV2Builder builder() {
        return new LbPoolV2ConcreteBuilder();
    }

    public static class LbPoolsV2
    extends ListResult<OctaviaLbPoolV2> {
        @JsonProperty(value="pools")
        List<OctaviaLbPoolV2> lbPools;

        @Override
        protected List<OctaviaLbPoolV2> value() {
            return this.lbPools;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lbPools", this.lbPools).toString();
        }
    }

    public static class LbPoolV2ConcreteBuilder
    implements LbPoolV2Builder {
        private OctaviaLbPoolV2 m;

        @Override
        public LbPoolV2 build() {
            return this.m;
        }

        public LbPoolV2ConcreteBuilder() {
            this(new OctaviaLbPoolV2());
        }

        public LbPoolV2ConcreteBuilder(OctaviaLbPoolV2 m) {
            this.m = m;
        }

        @Override
        public LbPoolV2Builder from(LbPoolV2 in) {
            this.m = (OctaviaLbPoolV2)in;
            return this;
        }

        @Override
        public LbPoolV2Builder projectId(String projectId) {
            this.m.projectId = projectId;
            return this;
        }

        @Override
        public LbPoolV2Builder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public LbPoolV2Builder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public LbPoolV2Builder protocol(Protocol protocol) {
            this.m.protocol = protocol;
            return this;
        }

        @Override
        public LbPoolV2Builder lbMethod(LbMethod lbMethod) {
            this.m.lbMethod = lbMethod;
            return this;
        }

        @Override
        public LbPoolV2Builder sessionPersistence(SessionPersistence sessionPersistence) {
            this.m.sessionPersistence = sessionPersistence;
            return this;
        }

        @Override
        public LbPoolV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public LbPoolV2Builder listenerId(String listenerId) {
            this.m.listenerId = listenerId;
            return this;
        }
    }
}

