/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.compute.FlavorService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.FlavorAccess;
import org.openstack4j.openstack.compute.domain.ExtraSpecsWrapper;
import org.openstack4j.openstack.compute.domain.NovaFlavor;
import org.openstack4j.openstack.compute.domain.NovaFlavorAccess;
import org.openstack4j.openstack.compute.internal.BaseComputeServices;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class FlavorServiceImpl
extends BaseComputeServices
implements FlavorService {
    @Override
    public List<? extends Flavor> list() {
        return this.list(null);
    }

    @Override
    public List<? extends Flavor> list(boolean detail) {
        return this.list(detail, null);
    }

    @Override
    public List<? extends Flavor> list(Map<String, String> filteringParams) {
        return this.list(true, filteringParams);
    }

    @Override
    public List<? extends Flavor> list(boolean detail, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NovaFlavor.Flavors> flavorInvocation = this.get(NovaFlavor.Flavors.class, this.uri("/flavors" + (detail ? "/detail" : ""), new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public Flavor get(String flavorId) {
        Preconditions.checkNotNull((Object)flavorId);
        return this.get(NovaFlavor.class, this.uri("/flavors/%s", flavorId)).execute();
    }

    @Override
    public ActionResponse delete(String flavorId) {
        Preconditions.checkNotNull((Object)flavorId);
        return this.deleteWithResponse(this.uri("/flavors/%s", flavorId)).execute();
    }

    @Override
    public Flavor create(Flavor flavor) {
        Preconditions.checkNotNull((Object)flavor);
        return this.post(NovaFlavor.class, this.uri("/flavors", new Object[0])).entity(flavor).execute();
    }

    @Override
    public Flavor create(String name, int ram, int vcpus, int disk, int ephemeral, int swap, float rxtxFactor, boolean isPublic) {
        Preconditions.checkNotNull((Object)name);
        return this.create((Flavor)NovaFlavor.builder().name(name).ram(ram).vcpus(vcpus).disk(disk).swap(swap).ephemeral(ephemeral).rxtxFactor(rxtxFactor).isPublic(isPublic).build());
    }

    @Override
    public Map<String, String> listExtraSpecs(String flavorId) {
        Preconditions.checkNotNull((Object)flavorId);
        ExtraSpecsWrapper wrapper = this.get(ExtraSpecsWrapper.class, this.uri("/flavors/%s/os-extra_specs", flavorId)).execute();
        return wrapper != null ? wrapper.getExtraSpecs() : null;
    }

    @Override
    public Map<String, String> createAndUpdateExtraSpecs(String flavorId, Map<String, String> spec) {
        Preconditions.checkNotNull((Object)flavorId);
        Preconditions.checkNotNull(spec);
        return this.post(ExtraSpecsWrapper.class, this.uri("/flavors/%s/os-extra_specs", flavorId)).entity(ExtraSpecsWrapper.wrap(spec)).execute().getExtraSpecs();
    }

    @Override
    public void deleteExtraSpecs(String flavorId, String key) {
        Preconditions.checkNotNull((Object)flavorId);
        Preconditions.checkNotNull((Object)key);
        this.delete(Void.class, this.uri("/flavors/%s/os-extra_specs/%s", flavorId, key)).execute();
    }

    @Override
    public String getSpec(String flavorId, String key) {
        Preconditions.checkNotNull((Object)flavorId);
        Preconditions.checkNotNull((Object)key);
        Map extraSpec = this.get(HashMap.class, this.uri("/flavors/%s/os-extra_specs/%s", flavorId, key)).execute();
        return extraSpec == null ? null : (String)extraSpec.get(key);
    }

    @Override
    public List<? extends FlavorAccess> listFlavorAccess(String flavorId) {
        Preconditions.checkNotNull((Object)flavorId);
        return this.get(NovaFlavorAccess.FlavorAccesses.class, this.uri("/flavors/%s/os-flavor-access", flavorId)).execute().getList();
    }

    @Override
    public List<? extends FlavorAccess> addTenantAccess(String flavorId, String tenantId) {
        Preconditions.checkNotNull((Object)flavorId);
        Preconditions.checkNotNull((Object)tenantId);
        NovaFlavorAccess.AddTenantAccess addTenantAccess = new NovaFlavorAccess.AddTenantAccess();
        addTenantAccess.setTenantId(tenantId);
        return this.post(NovaFlavorAccess.FlavorAccesses.class, this.uri("/flavors/%s/action", flavorId)).entity(addTenantAccess).execute().getList();
    }

    @Override
    public List<? extends FlavorAccess> removeTenantAccess(String flavorId, String tenantId) {
        Preconditions.checkNotNull((Object)flavorId);
        Preconditions.checkNotNull((Object)tenantId);
        NovaFlavorAccess.RemoveTenantAccess removeTenantAccess = new NovaFlavorAccess.RemoveTenantAccess();
        removeTenantAccess.setTenantId(tenantId);
        return this.post(NovaFlavorAccess.FlavorAccesses.class, this.uri("/flavors/%s/action", flavorId)).entity(removeTenantAccess).execute().getList();
    }
}

