/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.xml;

/**
 * JSP/XMLファイルを読み取って、構築される最上位の OGDocument オブジェクト を処理する フィルタインターフェースです。
 *
 * JspSaxParser での copyDirectry されるときに、このフィルターが呼ばれるように設定できます。
 *
 * @og.rev 5.1.9.0 (2010/08/01) 新規作成
 *
 * @version  5.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK6.0,
 */
public interface JspParserFilter {

	/**
	 * ドキュメントオブジェクト を変換します。
	 *
	 * 引数に null が設定された場合も、正常に処理を行います。(return null とする)
	 * 後続処理を行いたくない場合にも、null を返します。
	 *
	 * @param	doc	処理を行うドキュメントオブジェクト
	 *
	 * @return	処理した結果のドキュメントオブジェクト
	 */
	OGDocument filter( final OGDocument doc );
}
