/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * Ajaxツリーテーブルクラス用のパラメータ定数設定クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 4.3.1.0 (2008/09/03) 新規作成
 * @og.group その他
 *
 * @version  4.0
 * @author	 Hiroki Nakamura
 * @since    JDK5.0,
 */
public class ViewAjaxTreeTableParam {
	/** パラメータ定数 {@value} */
	public static final String CHILD_SEARCH_JSP       = "h_child_search_jsp" ;
	/** パラメータ定数 {@value} */
	public static final String CHILD_SEARCH_KEYS      = "h_child_search_keys" ;
	/** パラメータ定数 {@value} */
	public static final String LVL_CLM_KEY            = "h_lvl_clm_key" ;
	/** パラメータ定数 {@value} */
	public static final String IMG_COLLAPSED          = "h_img_collapsed"   ;
	/** パラメータ定数 {@value} */
	public static final String IMG_EXPANDED           = "h_img_expanded"  ;
	/** パラメータ定数 {@value} */
	public static final String IMG_NO_SUB             = "h_img_nosub"  ;
	/** パラメータ定数 {@value} */
	public static final String EXPAND_ALL             = "h_expand_all" ; // 4.3.3.0 (2008/10/01)
	/** パラメータ定数 {@value} */
	public static final String CHILD_VIEW_START_NO    = "h_child_view_start_no" ; // 4.3.3.0 (2008/10/01)
	/** パラメータ定数 {@value} */
	public static final String EXPAND_CONTROL_CLM_KEY = "h_exp_ctrl_clm_key" ; // 4.3.5.0 (2008/02/01)
}
