/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

import org.opengion.fukurou.security.HybsCryptography ;

/**
 * パスワード情報など、重要な情報の暗号化された情報を表示する場合に使用するクラスです。
 *
 * このクラスの暗号化は秘密キーによる可逆変換なので、変換方式と秘密キーが判ると
 * 元に戻すことが可能です。それでも、何もしないよりははるかにましです。
 * データベース等へ登録した暗号化されたデータを表示する場合に、使用します。
 *
 * このクラスは、不変オブジェクトとして、共有されます。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 * @og.group データ表示
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_CRYPT extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;
	private static final CellRenderer dbCell = new Renderer_CRYPT() ;

	private final HybsCryptography licence = new HybsCryptography() ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param	value 入力値
	 *
	 * @return	データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		return licence.decrypt( value );
	}
}
