/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import oracle.cloudstorage.util.Throwables;

public enum IO {
    in,
    out;

    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final OutputStream noopOutput;
    private static final IExceptionHandler defaultExceptionHandler;

    public static ReadReader read(Reader reader) {
        return new ReadReader(reader);
    }

    public static ReadInputStream read(InputStream inputStream) {
        return new ReadInputStream(inputStream);
    }

    static {
        noopOutput = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        defaultExceptionHandler = new IExceptionHandler(){

            @Override
            public void onException(Throwable t, Context context) {
                String message = "Exception thrown after reading " + context.count + " from " + context.inputDescription + " into " + context.outputDescription;
                throw new RuntimeException(message, t);
            }
        };
    }

    public static interface IExceptionHandler {
        public void onException(Throwable var1, Context var2);
    }

    public static class Context {
        private long count = 0L;
        private long duration = 0L;
        private int bufferSize = 4096;
        private EnumSet<IO> keepOpen = EnumSet.noneOf(IO.class);
        String inputDescription = "";
        String outputDescription = "";

        private void copy(Context that) {
            this.count = that.count;
            this.duration = that.duration;
            this.bufferSize = that.bufferSize;
            this.keepOpen = that.keepOpen;
            this.inputDescription = that.inputDescription;
            this.outputDescription = that.outputDescription;
        }

        protected long getCount() {
            return this.count;
        }

        protected void setCount(long count) {
            this.count = count;
        }

        protected long getDuration() {
            return this.duration;
        }

        protected void setDuration(long duration) {
            this.duration = duration;
        }

        protected String getInputDescription() {
            return this.inputDescription;
        }

        protected void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        protected String getOutputDescription() {
            return this.outputDescription;
        }

        protected void setOutputDescription(String outputDescription) {
            this.outputDescription = outputDescription;
        }
    }

    public static class ReadReader
    extends Read<ReadReader, Reader, Writer> {
        private final Reader input;

        ReadReader(Reader reader) {
            this.input = reader;
        }

        @Override
        Reader getInput() {
            return this.input;
        }

        @Override
        public Context into(OutputStream outputStream) {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            return this.into(writer);
        }

        @Override
        protected void copy(Writer writer) throws IOException {
            char[] buffer = new char[4096];
            this.context.count = 0L;
            int n = 0;
            while (-1 != (n = this.input.read(buffer))) {
                writer.write(buffer, 0, n);
                this.context.count += n;
            }
        }

        @Override
        public String toString() {
            StringWriter writer = new StringWriter();
            this.into(writer);
            return writer.toString();
        }
    }

    public static class ReadInputStream
    extends Read<ReadInputStream, InputStream, OutputStream> {
        private final InputStream input;

        private ReadInputStream(InputStream inputStream) {
            this.input = inputStream;
        }

        @Override
        InputStream getInput() {
            return this.input;
        }

        @Override
        public Context into(Writer writer) {
            InputStreamReader reader = new InputStreamReader(this.getInput());
            ReadReader read = IO.read(reader);
            read.context.copy(this.context);
            return read.into(writer);
        }

        @Override
        void copy(OutputStream output) throws IOException {
            byte[] buffer = new byte[this.context.bufferSize];
            int n = 0;
            while (-1 != (n = this.input.read(buffer))) {
                output.write(buffer, 0, n);
                this.context.count += n;
            }
        }

        @Override
        public String toString() {
            StringWriter writer = new StringWriter();
            this.into(writer);
            return writer.toString();
        }
    }

    private static class Closing<C extends Closeable>
    implements Closeable {
        private final C delegate;
        private final boolean keepOpen;

        public <D extends C> Closing(D delegate, boolean keepOpen) {
            this.delegate = delegate;
            this.keepOpen = keepOpen;
        }

        @Override
        public void close() {
            if (this.keepOpen) {
                return;
            }
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class Read<R extends Read<R, I, O>, I extends Closeable, O extends Closeable> {
        private IExceptionHandler exceptionHandler = IO.access$100();
        protected final Context context = new Context();

        abstract I getInput();

        abstract void copy(O var1) throws Exception;

        public R buffer(int bufferSize) {
            this.context.bufferSize = bufferSize;
            Read self = this;
            return (R)self;
        }

        public R keepOpen(IO ... keepOpen) {
            for (IO io : keepOpen) {
                this.context.keepOpen.add(io);
            }
            Read self = this;
            return (R)self;
        }

        public R with(IExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler == null ? defaultExceptionHandler : exceptionHandler;
            Read self = this;
            return (R)self;
        }

        public abstract String toString();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Context into(O output) {
            long start = System.nanoTime();
            Closing closingOutput = null;
            Closing closingInput = null;
            Exception t = null;
            try {
                closingOutput = new Closing(output, this.context.keepOpen.contains((Object)out));
                closingInput = new Closing(this.getInput(), true);
                this.context.count = 0L;
                this.copy(output);
            }
            catch (Exception e) {
                try {
                    this.exceptionHandler.onException(e, this.context);
                    t = e;
                }
                catch (Throwable throwable) {
                    this.context.duration = System.nanoTime() - start;
                    Throwable ct = null;
                    for (Closeable c : new Closeable[]{closingOutput, closingInput}) {
                        if (c == null) continue;
                        try {
                            c.close();
                        }
                        catch (Throwable e2) {
                            if (ct == null) {
                                ct = e2;
                                continue;
                            }
                            Throwables.addSuppressed(ct, e2);
                        }
                    }
                    if (ct != null) {
                        if (t == null) {
                            throw new RuntimeException(ct);
                        }
                        Throwables.addSuppressed(t, ct);
                    }
                    throw throwable;
                }
                this.context.duration = System.nanoTime() - start;
                Throwable ct = null;
                for (Closeable c : new Closeable[]{closingOutput, closingInput}) {
                    if (c == null) continue;
                    try {
                        c.close();
                    }
                    catch (Throwable e3) {
                        if (ct == null) {
                            ct = e3;
                            continue;
                        }
                        Throwables.addSuppressed(ct, e3);
                    }
                }
                if (ct != null) {
                    if (t == null) {
                        throw new RuntimeException(ct);
                    }
                    Throwables.addSuppressed(t, ct);
                }
            }
            this.context.duration = System.nanoTime() - start;
            Throwable ct = null;
            for (Closeable c : new Closeable[]{closingOutput, closingInput}) {
                if (c == null) continue;
                try {
                    c.close();
                }
                catch (Throwable e) {
                    if (ct == null) {
                        ct = e;
                        continue;
                    }
                    Throwables.addSuppressed(ct, e);
                }
            }
            if (ct != null) {
                if (t == null) {
                    throw new RuntimeException(ct);
                }
                Throwables.addSuppressed(t, ct);
            }
            return this.context;
        }
    }
}

