/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfTableColumn;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.type.PositiveInteger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfTable
extends TableTableElement {
    private int mCurrentNumberOfColumns = 0;

    public OdfTable(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfTableColumn getTableColumn(int c) {
        List<OdfTableColumn> list = this.getTableColumnList();
        if (list.size() > c) {
            return list.get(c);
        }
        return null;
    }

    public List<OdfTableColumn> getTableColumnList() {
        return this.makeTableColumnList();
    }

    public int getTableColumnCount() {
        return this.mCurrentNumberOfColumns;
    }

    public OdfTableColumn addTableColumn() {
        return this.addTableColumn(1);
    }

    public OdfTableColumn addTableColumn(int repeat) {
        Node ref = this.getFirstChild();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableColumn)) continue;
            ref = n.getNextSibling();
        }
        OdfTableColumn tce = (OdfTableColumn)((Object)this.getOwnerDocument().createElementNS(TableTableColumnElement.ELEMENT_NAME.getUri(), TableTableColumnElement.ELEMENT_NAME.getQName()));
        tce = ref != null ? (OdfTableColumn)((Object)this.insertBefore((Node)((Object)tce), ref)) : (OdfTableColumn)((Object)this.appendChild((Node)((Object)tce)));
        if (repeat > 1) {
            tce.setTableNumberColumnsRepeatedAttribute(new Integer(repeat));
        }
        this.mCurrentNumberOfColumns += repeat;
        return tce;
    }

    public OdfTableColumn addStyledTableColumn(String styleName) {
        OdfTableColumn result = this.addTableColumn();
        result.setStyleName(styleName);
        return result;
    }

    private List<OdfTableColumn> makeTableColumnList() {
        ArrayList<OdfTableColumn> list = new ArrayList<OdfTableColumn>();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (n instanceof OdfTableColumn) {
                OdfTableColumn col = (OdfTableColumn)((Object)n);
                if (col.getTableNumberColumnsRepeatedAttribute() == null) {
                    list.add(col);
                    continue;
                }
                for (int i = 0; i < col.getTableNumberColumnsRepeatedAttribute(); ++i) {
                    list.add(col);
                }
                continue;
            }
            if (!(n instanceof OdfTableRow)) continue;
            break;
        }
        return list;
    }

    public List<OdfTableColumn> makeStyledColumnList(List<String> styleList) {
        ArrayList<OdfTableColumn> list = new ArrayList<OdfTableColumn>();
        OdfFileDom owner = (OdfFileDom)((Object)this.getOwnerDocument());
        for (String styleName : styleList) {
            OdfTableColumn col = new OdfTableColumn(owner);
            col.setStyleName(styleName);
            list.add(col);
        }
        return list;
    }

    public void setColumnList(List<OdfTableColumn> cl) {
        ArrayList<Node> rmList = new ArrayList<Node>();
        for (Node n : new DomNodeList(this.getChildNodes())) {
            if (!(n instanceof OdfTableColumn)) continue;
            rmList.add(n);
        }
        for (Node n : rmList) {
            this.removeChild(n);
        }
        Node ref = this.getFirstChild();
        OdfTableColumn prev = null;
        for (OdfTableColumn tce : cl) {
            if (prev == null || prev != tce) {
                this.insertBefore((Node)((Object)tce), ref);
                prev = tce;
                continue;
            }
            if (tce == null) continue;
            tce.setTableNumberColumnsRepeatedAttribute(new PositiveInteger(tce.getTableNumberColumnsRepeatedAttribute() + 1).intValue());
        }
    }

    public Node appendRow(Node aNewChild) throws DOMException {
        Node aNode = super.appendChild(aNewChild);
        if (aNode instanceof OdfTableRow) {
            OdfTableRow aRow = (OdfTableRow)((Object)aNode);
            aRow.inheritSpannedCells(0);
        } else if (aNode instanceof OdfTableColumn) {
            ++this.mCurrentNumberOfColumns;
        }
        return aNode;
    }
}

