/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class CountryCode
implements OdfDataType {
    private String mCountryCode;

    public CountryCode(String countryCode) throws IllegalArgumentException {
        if (countryCode == null || !countryCode.matches("^[A-Za-z0-9]{1,8}$")) {
            throw new IllegalArgumentException("parameter is invalidate for datatype CountryCode");
        }
        if (!W3CSchemaType.isValid("token", countryCode)) {
            throw new IllegalArgumentException("parameter is invalidate for datatype CountryCode");
        }
        this.mCountryCode = countryCode;
    }

    public String toString() {
        return this.mCountryCode;
    }

    public static CountryCode valueOf(String stringValue) throws IllegalArgumentException {
        return new CountryCode(stringValue);
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null || !stringValue.matches("^[A-Za-z0-9]{1,8}$")) {
            return false;
        }
        return W3CSchemaType.isValid("token", stringValue);
    }
}

