/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.listeners;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class AbstractListenerDispatcher<TListener>
implements Iterable<TListener> {
    private final Set<TListener> listeners = new CopyOnWriteArraySet<TListener>();
    private final List<WeakReference<TListener>> weakListeners = new CopyOnWriteArrayList<WeakReference<TListener>>();
    private volatile boolean shutdown = false;

    public final void addListener(TListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown()) {
            return;
        }
        this.listeners.add(listener);
    }

    public final void addWeakListener(TListener listener) {
        if (listener == this) {
            throw new IllegalArgumentException("Adding this instance to itself is not allowed");
        }
        if (this.isShutdown() || this.listeners.contains(listener)) {
            return;
        }
        this.removeListener(listener);
        WeakReference<TListener> weakReference = new WeakReference<TListener>(listener);
        this.weakListeners.add(weakReference);
        this.cleanWeakListeners();
    }

    public final void removeListener(TListener listener) {
        if (this.listeners.remove(listener)) {
            return;
        }
        for (WeakReference<TListener> ref : this.weakListeners) {
            Object refValue = ref.get();
            if (refValue == listener) {
                this.weakListeners.remove(ref);
                return;
            }
            if (refValue != null) continue;
            this.weakListeners.remove(ref);
        }
    }

    public final void removeAllListeners() {
        this.listeners.clear();
        this.weakListeners.clear();
    }

    public final void shutdown() {
        this.shutdown = true;
        this.removeAllListeners();
    }

    public final boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public final Iterator<TListener> iterator() {
        this.cleanWeakListeners();
        return new ListenerIterator(this.listeners.iterator(), this.weakListeners.iterator());
    }

    private void cleanWeakListeners() {
        for (WeakReference<TListener> ref : this.weakListeners) {
            if (ref.get() != null) continue;
            this.weakListeners.remove(ref);
        }
    }

    private static final class ListenerIterator<TListener>
    implements Iterator<TListener> {
        private final Iterator<TListener> strongIterator;
        private final Iterator<WeakReference<TListener>> weakIterator;
        private boolean useStrongIterator = true;
        private TListener nextWeakListener;

        private ListenerIterator(Iterator<TListener> strongIterator, Iterator<WeakReference<TListener>> weakIterator) {
            this.strongIterator = strongIterator;
            this.weakIterator = weakIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.useStrongIterator) {
                if (this.strongIterator.hasNext()) {
                    return true;
                }
                this.useStrongIterator = false;
            }
            return this.getNextWeakListener() != null;
        }

        @Override
        public TListener next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useStrongIterator) {
                return this.strongIterator.next();
            }
            TListener next = this.nextWeakListener;
            this.nextWeakListener = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private TListener getNextWeakListener() {
            Iterator<WeakReference<TListener>> weakIterator = this.weakIterator;
            Object nextWeakListener = this.nextWeakListener;
            while (nextWeakListener == null && weakIterator.hasNext()) {
                WeakReference<TListener> currentRef = weakIterator.next();
                nextWeakListener = currentRef.get();
            }
            this.nextWeakListener = nextWeakListener;
            return this.nextWeakListener;
        }
    }
}

