/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeParseException;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.ObjectConverter;

public class JDBC42ObjectConverter
implements ObjectConverter {
    @Override
    public boolean setObject(FBField field, Object object) throws SQLException {
        if (object instanceof LocalDate) {
            switch (field.requiredType) {
                case 91: {
                    LocalDate localDate = (LocalDate)object;
                    field.setFieldData(field.getDatatypeCoder().encodeLocalDate(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof LocalTime) {
            switch (field.requiredType) {
                case 92: {
                    LocalTime localTime = (LocalTime)object;
                    field.setFieldData(field.getDatatypeCoder().encodeLocalTime(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            switch (field.requiredType) {
                case 91: {
                    field.setFieldData(field.getDatatypeCoder().encodeLocalDate(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth()));
                    return true;
                }
                case 92: {
                    field.setFieldData(field.getDatatypeCoder().encodeLocalTime(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano()));
                    return true;
                }
                case 93: {
                    field.setFieldData(field.getDatatypeCoder().encodeLocalDateTime(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano()));
                    return true;
                }
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        } else if (object instanceof OffsetTime || object instanceof OffsetDateTime) {
            switch (field.requiredType) {
                case -1: 
                case 1: 
                case 12: {
                    field.setString(object.toString());
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public <T> T getObject(FBField field, Class<T> type) throws SQLException {
        switch (field.requiredType) {
            case 91: {
                switch (type.getName()) {
                    case "java.time.LocalDate": {
                        if (field.isNull()) {
                            return null;
                        }
                        DatatypeCoder.RawDateTimeStruct raw = field.getDatatypeCoder().decodeDateRaw(field.getFieldData());
                        return (T)LocalDate.of(raw.year, raw.month, raw.day);
                    }
                    case "java.time.LocalDateTime": {
                        if (field.isNull()) {
                            return null;
                        }
                        DatatypeCoder.RawDateTimeStruct raw = field.getDatatypeCoder().decodeDateRaw(field.getFieldData());
                        return (T)LocalDate.of(raw.year, raw.month, raw.day).atStartOfDay();
                    }
                }
                break;
            }
            case 92: {
                switch (type.getName()) {
                    case "java.time.LocalTime": {
                        if (field.isNull()) {
                            return null;
                        }
                        DatatypeCoder.RawDateTimeStruct raw = field.getDatatypeCoder().decodeTimeRaw(field.getFieldData());
                        return (T)LocalTime.of(raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
                    }
                    case "java.time.LocalDateTime": {
                        if (field.isNull()) {
                            return null;
                        }
                        DatatypeCoder.RawDateTimeStruct raw = field.getDatatypeCoder().decodeTimeRaw(field.getFieldData());
                        return (T)LocalTime.of(raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos()).atDate(LocalDate.of(1970, 1, 1));
                    }
                }
                break;
            }
            case 93: {
                if (!"java.time.LocalDateTime".equals(type.getName())) break;
                if (field.isNull()) {
                    return null;
                }
                DatatypeCoder.RawDateTimeStruct raw = field.getDatatypeCoder().decodeTimestampRaw(field.getFieldData());
                return (T)LocalDateTime.of(raw.year, raw.month, raw.day, raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
            }
            case -1: 
            case 1: 
            case 12: {
                try {
                    switch (type.getName()) {
                        case "java.time.LocalDate": {
                            return (T)(field.isNull() ? null : LocalDate.parse(field.getString().trim()));
                        }
                        case "java.time.LocalTime": {
                            return (T)(field.isNull() ? null : LocalTime.parse(field.getString().trim()));
                        }
                        case "java.time.LocalDateTime": {
                            return (T)(field.isNull() ? null : LocalDateTime.parse(field.getString().trim()));
                        }
                        case "java.time.OffsetTime": {
                            return (T)(field.isNull() ? null : OffsetTime.parse(field.getString().trim()));
                        }
                        case "java.time.OffsetDateTime": {
                            return (T)(field.isNull() ? null : OffsetDateTime.parse(field.getString().trim()));
                        }
                    }
                    break;
                }
                catch (DateTimeParseException e) {
                    throw new SQLException("Unable to convert value '" + field.getString() + "' to type " + type, e);
                }
            }
        }
        throw new SQLNonTransientException(String.format("Unsupported conversion requested for field %s (JDBC type %s) requested type: %s", field.getName(), JDBCType.valueOf(field.requiredType), type.getName()));
    }
}

