/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;

public class DefaultBlrCalculator
implements BlrCalculator {
    public static final DefaultBlrCalculator CALCULATOR_DIALECT_3 = new DefaultBlrCalculator(3);
    private final short dialect;

    public DefaultBlrCalculator(short dialect) {
        this.dialect = dialect;
    }

    @Override
    public byte[] calculateBlr(RowDescriptor rowDescriptor) throws SQLException {
        ByteArrayOutputStream bout = this.getByteArrayOutputStream(rowDescriptor.getCount());
        for (FieldDescriptor field : rowDescriptor) {
            this.calculateFieldBlr(bout, field, field.getLength());
        }
        bout.write(255);
        bout.write(76);
        return bout.toByteArray();
    }

    @Override
    public byte[] calculateBlr(RowDescriptor rowDescriptor, RowValue rowValue) throws SQLException {
        ByteArrayOutputStream bout = this.getByteArrayOutputStream(rowValue.getCount());
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldValue fieldValue = rowValue.getFieldValue(idx);
            FieldDescriptor field = rowDescriptor.getFieldDescriptor(idx);
            int actualDataLength = fieldValue.getFieldData() != null ? fieldValue.getFieldData().length : 0;
            this.calculateFieldBlr(bout, field, actualDataLength);
        }
        bout.write(255);
        bout.write(76);
        return bout.toByteArray();
    }

    private ByteArrayOutputStream getByteArrayOutputStream(int fieldCount) {
        int approximateSize = 8 + 5 * fieldCount;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(approximateSize);
        int parameterCount = 2 * fieldCount;
        bout.write(this.dialect <= 1 ? 4 : 5);
        bout.write(2);
        bout.write(4);
        bout.write(0);
        bout.write(parameterCount);
        bout.write(parameterCount >> 8);
        return bout;
    }

    private void calculateFieldBlr(ByteArrayOutputStream bout, FieldDescriptor field, int len) throws SQLException {
        int fieldType = field.getType() & 0xFFFFFFFE;
        switch (fieldType) {
            case 448: {
                bout.write(37);
                bout.write(len);
                bout.write(len >> 8);
                break;
            }
            case 452: {
                bout.write(14);
                bout.write(len);
                bout.write(len >> 8);
                break;
            }
            case 32766: {
                bout.write(14);
                bout.write(0);
                bout.write(0);
                break;
            }
            case 480: {
                bout.write(27);
                break;
            }
            case 482: {
                bout.write(10);
                break;
            }
            case 530: {
                bout.write(11);
                break;
            }
            case 570: {
                bout.write(12);
                break;
            }
            case 560: {
                bout.write(13);
                break;
            }
            case 510: {
                bout.write(35);
                break;
            }
            case 520: {
                bout.write(9);
                bout.write(0);
                break;
            }
            case 540: {
                bout.write(9);
                bout.write(0);
                break;
            }
            case 496: {
                bout.write(8);
                bout.write(field.getScale());
                break;
            }
            case 500: {
                bout.write(7);
                bout.write(field.getScale());
                break;
            }
            case 580: {
                bout.write(16);
                bout.write(field.getScale());
                break;
            }
            case 550: {
                bout.write(9);
                bout.write(field.getScale());
                break;
            }
            case 32764: {
                bout.write(23);
                break;
            }
            default: {
                throw new FbExceptionBuilder().exception(335544713).toSQLException();
            }
        }
        bout.write(7);
        bout.write(0);
    }

    @Override
    public int calculateIoLength(FieldDescriptor fieldDescriptor) throws SQLException {
        switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
            case 452: {
                return fieldDescriptor.getLength() + 1;
            }
            case 448: {
                return 0;
            }
            case 482: 
            case 496: 
            case 500: 
            case 560: 
            case 570: {
                return -4;
            }
            case 480: 
            case 510: 
            case 520: 
            case 540: 
            case 550: 
            case 580: {
                return -8;
            }
            case 32766: {
                return 0;
            }
            case 32764: {
                return 2;
            }
        }
        throw new FbExceptionBuilder().exception(335544573).toSQLException();
    }

    @Override
    public int calculateIoLength(FieldDescriptor fieldDescriptor, FieldValue fieldValue) throws SQLException {
        int fieldType = fieldDescriptor.getType() & 0xFFFFFFFE;
        if (fieldType == 452) {
            return (fieldValue.getFieldData() != null ? fieldValue.getFieldData().length : 0) + 1;
        }
        return this.calculateIoLength(fieldDescriptor);
    }
}

