/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.URITransformer;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class AnyURI
implements OdfDataType {
    private URI mURI;

    public AnyURI(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("parameter can not be null for AnyURI");
        }
        if (!W3CSchemaType.isValid("anyURI", URITransformer.decodePath(uri.toString()))) {
            Logger.getLogger(AnyURI.class.getName()).log(Level.SEVERE, "parameter is invalidate for datatype AnyURI");
            throw new IllegalArgumentException("parameter is invalidate for datatype anyURI");
        }
        this.mURI = uri;
    }

    public String toString() {
        return URITransformer.decodePath(this.mURI.toString());
    }

    public static AnyURI valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null) {
            throw new IllegalArgumentException("parameter can not be null for AnyURI");
        }
        try {
            URI uri = new URI(URITransformer.encodePath(stringValue).toString());
            return new AnyURI(uri);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(AnyURI.class.getName()).log(Level.SEVERE, "parameter is invalidate for datatype anyURI", ex);
            throw new IllegalArgumentException("parameter is invalidate for datatype anyURI");
        }
    }

    public URI getURI() {
        return this.mURI;
    }

    public static boolean isValid(URI uri) {
        boolean isValid = false;
        if (uri != null) {
            isValid = W3CSchemaType.isValid("anyURI", uri.toString());
        }
        return isValid;
    }

    public static String encodePath(String path) {
        return URITransformer.encodePath(path);
    }

    public static String decodePath(String path) {
        return URITransformer.decodePath(path);
    }
}

