/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.KanaFilter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.StorageAPI;
import org.opengion.hayabusa.io.StorageAPIFactory;

public class FileDownload
extends HttpServlet {
    private static final long serialVersionUID = 539020110901L;
    private static final String[][] CONTENT_TYPE_TABLE = new String[][]{{"jpg", "image/pjpeg"}, {"gif", "image/gif"}, {"txt", "text/plain"}, {"xls", "application/vnd.ms-excel"}, {"odp", "application/vnd.oasis.opendocument.presentation"}, {"ods", "application/vnd.oasis.opendocument.spreadsheet"}, {"odt", "application/vnd.oasis.opendocument.text"}};
    private static final int EXTENTION = 0;
    private static final int CONTENT_TYPE = 1;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        boolean bl = HybsSystem.sysBool("USE_FILEDOWNLOAD_HAN_ZEN");
        String string2 = HybsSystem.sys("CLOUD_STORAGE");
        boolean bl2 = false;
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
        }
        String string3 = httpServletRequest.getParameter("file");
        String string4 = httpServletRequest.getParameter("name");
        String string5 = null;
        boolean bl3 = StringUtil.nval((String)httpServletRequest.getParameter("inline"), (boolean)false);
        String string6 = bl3 ? "inline" : "attachment";
        boolean bl4 = StringUtil.nval((String)httpServletRequest.getParameter("useStringConvert"), (boolean)true);
        if (bl4) {
            string3 = new String(string3.getBytes("ISO-8859-1"), "UTF-8");
        }
        String string7 = string3;
        boolean bl5 = HybsSystem.sysBool("USE_FILEDOWNLOAD_CHECKKEY");
        if (bl5 && ((string = httpServletRequest.getParameter("key")) == null || !string.equals(HybsCryptography.getMD5((String)string3)))) {
            String string8 = "\u30a2\u30af\u30bb\u30b9\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002(URL\u30c1\u30a7\u30c3\u30af)";
            throw new HybsSystemException(string8);
        }
        string3 = HybsSystem.url2dir(string3);
        string = this.getContentType(string3);
        httpServletResponse.setContentType(string);
        if (string4 == null || string4.length() == 0) {
            string4 = this.getFileName(string3);
        } else if (bl4) {
            string4 = new String(string4.getBytes("ISO-8859-1"), "UTF-8");
        }
        if (bl) {
            string4 = KanaFilter.han2zen((String)string4);
        }
        string5 = StringUtil.urlEncode((String)string4);
        string4 = httpServletRequest.getHeader("User-Agent").indexOf("MSIE") >= 0 || httpServletRequest.getHeader("User-Agent").indexOf("Trident") >= 0 || httpServletRequest.getHeader("User-Agent").indexOf("Edge") >= 0 ? new String(string4.getBytes("Windows-31J"), "ISO-8859-1") : MimeUtility.encodeWord((String)string4, (String)"UTF-8", (String)"B");
        httpServletResponse.setHeader("Content-disposition", string6 + "; filename=\"" + string4 + "\"; " + "filename*=UTF-8''" + string5);
        httpServletResponse.setHeader("Cache-Control", "public");
        FileInputStream fileInputStream = null;
        ServletOutputStream servletOutputStream = null;
        InputStream inputStream = null;
        String string9 = null;
        try {
            int n;
            Object object;
            if (bl2) {
                object = httpServletRequest.getSession(true);
                StorageAPI storageAPI = StorageAPIFactory.newStorageAPI(string2, HybsSystem.sys("CLOUD_STORAGE_CONTAINER"), object);
                inputStream = storageAPI.get(string7, (HttpSession)object);
                Map<String, String> map = storageAPI.getInfo(string7, (HttpSession)object);
                string9 = map.get("SIZE");
            } else {
                fileInputStream = new FileInputStream(string3);
                inputStream = fileInputStream;
                string9 = String.valueOf(fileInputStream.available());
            }
            httpServletResponse.setHeader("Content-Lnegth", string9);
            servletOutputStream = httpServletResponse.getOutputStream();
            object = new byte[4096];
            while ((n = inputStream.read((byte[])object)) != -1) {
                servletOutputStream.write((byte[])object, 0, n);
                servletOutputStream.flush();
            }
        }
        catch (Throwable throwable) {
            Closer.ioClose(inputStream);
            Closer.ioClose((Closeable)fileInputStream);
            Closer.ioClose(servletOutputStream);
            throw throwable;
        }
        Closer.ioClose((Closeable)inputStream);
        Closer.ioClose((Closeable)fileInputStream);
        Closer.ioClose((Closeable)servletOutputStream);
    }

    private String getExtention(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return "";
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf(HybsSystem.FS);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private String getContentType(String string) {
        String string2 = this.getExtention(string);
        for (int i = 0; i < CONTENT_TYPE_TABLE.length; ++i) {
            if (!CONTENT_TYPE_TABLE[i][0].equalsIgnoreCase(string2)) continue;
            return CONTENT_TYPE_TABLE[i][1];
        }
        return "application/octet-stream";
    }
}

