/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.ClusterService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.Cluster;
import org.openstack4j.model.sahara.NodeGroup;
import org.openstack4j.openstack.sahara.domain.SaharaCluster;
import org.openstack4j.openstack.sahara.domain.SaharaClusterUnwrapped;
import org.openstack4j.openstack.sahara.domain.actions.SaharaActions;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class ClusterServiceImpl
extends BaseSaharaServices
implements ClusterService {
    @Override
    public List<? extends Cluster> list() {
        return this.get(SaharaCluster.Clusters.class, this.uri("/clusters", new Object[0])).execute().getList();
    }

    @Override
    public Cluster get(String clusterId) {
        Preconditions.checkNotNull((Object)clusterId);
        return this.get(SaharaCluster.class, this.uri("/clusters/%s", clusterId)).execute();
    }

    @Override
    public Cluster create(Cluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        SaharaClusterUnwrapped unwrapped = new SaharaClusterUnwrapped(cluster);
        return this.post(SaharaCluster.class, this.uri("/clusters", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String clusterId) {
        Preconditions.checkNotNull((Object)clusterId);
        return this.deleteWithResponse(this.uri("/clusters/%s", clusterId)).execute();
    }

    @Override
    public Cluster resizeNodeGroup(String clusterId, String groupName, int count) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)groupName);
        return this.put(SaharaCluster.class, this.uri("/clusters/%s", clusterId)).entity(new SaharaActions.ResizeNodeGroupAction(groupName, count)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public Cluster addNodeGroup(String clusterId, NodeGroup nodeGroup) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)nodeGroup);
        return this.put(SaharaCluster.class, this.uri("/clusters/%s", clusterId)).entity(new SaharaActions.AddNodeGroupAction(nodeGroup)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

