/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.trove.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.trove.InstanceService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.trove.Instance;
import org.openstack4j.model.trove.InstanceCreate;
import org.openstack4j.openstack.trove.domain.TroveInstance;
import org.openstack4j.openstack.trove.internal.BaseTroveServices;

public class DBInstanceServiceImpl
extends BaseTroveServices
implements InstanceService {
    @Override
    public List<? extends Instance> list() {
        return this.get(TroveInstance.DBInstances.class, this.uri("/instances", new Object[0])).execute().getList();
    }

    @Override
    public Instance get(String instanceId) {
        Preconditions.checkNotNull((Object)instanceId);
        TroveInstance instance = this.get(TroveInstance.class, this.uri("/instances/%s", instanceId)).execute();
        return instance;
    }

    @Override
    public Instance create(InstanceCreate instanceCreate) {
        return this.post(TroveInstance.class, this.uri("/instances", new Object[0])).entity(instanceCreate).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/instances/%s", id)).execute();
    }
}

