package gf;

import java.util.ArrayList;
import java.util.List;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.penguin.math.statistics.HybsMahalanobis;

/**
 * マハラノビス距離の計算を行います。
 * penguinパッケージを利用します。
 * 
 * @version 5.0
 * @author T.OTA
 * @since JDK1.7
 
 */
public class GFX030A extends BizLogic_TABLE {
	List<double[]>	dataList	= new ArrayList<double[]>();

	/**
	 * メインカーソルの各行で呼ばれるロジックを定義します
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean befall( int row ) {
		double[] lineData = new double[2];

		// 検査ﾃﾞｰﾀを全て格納する
		String clm1 = var( "COLUMN_NAME1" );
		String clm2 = var( "COLUMN_NAME2" );

		if( isEmpty( line( clm1 ) ) ) {
			lineData[0] = 0;
		}
		else {
			lineData[0] = lined( clm1 );
		}

		if( isEmpty( line( clm2 ) ) ) {
			lineData[1] = 0;
		}
		else {
			lineData[1] = lined( clm2 );
		}

		dataList.add( lineData );
		return true;
	}

	/**
	 * 空ﾁｪｯｸ
	 * @param str
	 * @return true:空 false:空でない
	 */
	private boolean isEmpty( String str ) {
		if( "".equals( str ) || str == null ) { return true; }
		return false;
	}

	/**
	 * 最後の行の終わりで呼び出し
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		StringBuilder sb = new StringBuilder();

		// ﾏﾊﾗﾉﾋﾞｽ計算の初期化処理
		HybsMahalanobis rtn = new HybsMahalanobis( (double[][]) dataList.toArray( new double[dataList.size()][2] ) );

		String[] setData = new String[3];
		row = 0;

		sb.append( "pointBackgroundColor:[" );

		for( int i = 0; i < dataList.size(); i++ ) {
			double[] data = dataList.get( i );
			// ﾏﾊﾗﾋﾞｽ距離による正常範囲ﾃﾞｰﾀ判定
			boolean flgCheck = rtn.check( data );

			// CALC列にに判定結果を設定
			setData[0] = String.valueOf( data[0] );
			setData[1] = String.valueOf( data[1] );
			setData[2] = String.valueOf( flgCheck );	// CALC列
			table.setValues( setData, row );			// ﾃｰﾌﾞﾙﾓﾃﾞﾙに再設定

			// 点の背景色を設定
			if( i != 0 ) {
				sb.append( "," );
			}
			if( flgCheck ) {
				// 正常ﾃﾞｰﾀ
				sb.append( "'black'" );
			}
			else {
				// 異常ﾃﾞｰﾀ
				sb.append( "'red'" );
			}

			row++;
		}
		sb.append( "]" );

		rtn(sb.toString());

		return true;
	}
}
