/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.common.Link;
import org.openstack4j.model.compute.Flavor;
import org.openstack4j.model.compute.builder.FlavorBuilder;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="flavor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NovaFlavor
implements Flavor {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private Integer ram;
    private Integer vcpus;
    private Integer disk;
    @JsonProperty(value="OS-FLV-EXT-DATA:ephemeral")
    private int ephemeral;
    private int swap;
    @JsonProperty(value="rxtx_factor")
    private float rxtxFactor = 1.0f;
    @JsonProperty(value="OS-FLV-DISABLED:disabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean disabled;
    @JsonProperty(value="rxtx_quota")
    private Integer rxtxQuota;
    @JsonProperty(value="rxtx_cap")
    private Integer rxtxCap;
    @JsonProperty(value="os-flavor-access:is_public")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean isPublic;
    private List<GenericLink> links;

    public static FlavorBuilder builder() {
        return new FlavorConcreteBuilder();
    }

    @Override
    public FlavorBuilder toBuilder() {
        return new FlavorConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRam() {
        return this.ram == null ? 0 : this.ram;
    }

    @Override
    public int getVcpus() {
        return this.vcpus == null ? 0 : this.vcpus;
    }

    @Override
    public int getDisk() {
        return this.disk == null ? 0 : this.disk;
    }

    @Override
    public int getSwap() {
        return this.swap;
    }

    @Override
    public float getRxtxFactor() {
        return this.rxtxFactor;
    }

    @Override
    public int getEphemeral() {
        return this.ephemeral;
    }

    @Override
    @JsonIgnore
    public int getRxtxQuota() {
        return this.rxtxQuota == null ? 0 : this.rxtxQuota;
    }

    @Override
    @JsonIgnore
    public int getRxtxCap() {
        return this.rxtxCap == null ? 0 : this.rxtxCap;
    }

    @Override
    @JsonIgnore
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public Boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public List<? extends Link> getLinks() {
        return this.links;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("vcpus", (Object)this.vcpus).add("ram", (Object)this.ram).add("disk", (Object)this.disk).add("ephemeral", this.ephemeral).add("swap", this.swap).add("rxtx_factor", this.rxtxFactor).add("disabled", (Object)this.disabled).add("rxtx_quota", (Object)this.rxtxQuota).add("rxtx_cap", (Object)this.rxtxCap).add("is_public", (Object)this.isPublic).add("links", this.links).addValue((Object)"\n").toString();
    }

    public static class FlavorConcreteBuilder
    implements FlavorBuilder {
        private NovaFlavor m;

        FlavorConcreteBuilder() {
            this(new NovaFlavor());
        }

        FlavorConcreteBuilder(NovaFlavor model) {
            this.m = model;
        }

        @Override
        public FlavorBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public FlavorBuilder ram(int ram) {
            this.m.ram = ram;
            return this;
        }

        @Override
        public FlavorBuilder vcpus(int vcpus) {
            this.m.vcpus = vcpus;
            return this;
        }

        @Override
        public FlavorBuilder disk(int disk) {
            this.m.disk = disk;
            return this;
        }

        @Override
        public FlavorBuilder swap(int swap) {
            this.m.swap = swap;
            return this;
        }

        @Override
        public FlavorBuilder rxtxFactor(float rxtxFactor) {
            this.m.rxtxFactor = rxtxFactor;
            return this;
        }

        @Override
        public FlavorBuilder isPublic(boolean isPublic) {
            this.m.isPublic = isPublic;
            return this;
        }

        @Override
        public Flavor build() {
            return this.m;
        }

        @Override
        public FlavorBuilder from(Flavor in) {
            this.m = (NovaFlavor)in;
            return this;
        }

        @Override
        public FlavorBuilder ephemeral(int ephemeral) {
            this.m.ephemeral = ephemeral;
            return this;
        }

        @Override
        public FlavorBuilder id(String id) {
            this.m.id = id;
            return this;
        }
    }

    public static class Flavors
    extends ListResult<NovaFlavor> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="flavors")
        List<NovaFlavor> flavors;

        @Override
        public List<NovaFlavor> value() {
            return this.flavors;
        }
    }
}

