/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.Closeable;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.StorageAPI;

public class StorageAPI_azure
implements StorageAPI {
    private CloudBlobContainer blobContainer = null;

    public StorageAPI_azure(String string, HttpSession httpSession) {
        String string2 = HybsSystem.sys((String)"CLOUD_STORAGE_AZURE_KEY");
        if (StringUtil.isNull((String)string2)) {
            String string3 = "Azure\u7528\u8a8d\u8a3c\u30ad\u30fc\u304c\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string3);
        }
        try {
            CloudStorageAccount cloudStorageAccount = CloudStorageAccount.parse((String)string2);
            CloudBlobClient cloudBlobClient = cloudStorageAccount.createCloudBlobClient();
            this.blobContainer = cloudBlobClient.getContainerReference(string);
            this.blobContainer.createIfNotExists();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b3\u30f3\u30c6\u30ca\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002container:");
            stringBuilder.append(string);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void add(InputStream inputStream, String string, String string2, HttpSession httpSession) {
        BlobOutputStream blobOutputStream = null;
        try {
            int n;
            CloudBlockBlob cloudBlockBlob = this.blobContainer.getDirectoryReference(string).getBlockBlobReference(string2);
            blobOutputStream = cloudBlockBlob.openOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                blobOutputStream.write(byArray, 0, n);
                blobOutputStream.flush();
            }
        }
        catch (Exception exception) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u3078\u306e\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002updFolder:");
                stringBuilder.append(string);
                stringBuilder.append(" updFileName:");
                stringBuilder.append(string2);
                stringBuilder.append(" errInfo:");
                stringBuilder.append(exception);
                throw new HybsSystemException(stringBuilder.toString());
            }
            catch (Throwable throwable) {
                Closer.ioClose(blobOutputStream);
                Closer.ioClose((Closeable)inputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)blobOutputStream);
        Closer.ioClose((Closeable)inputStream);
    }

    public InputStream get(String string, HttpSession httpSession) {
        CloudBlockBlob cloudBlockBlob = null;
        BlobInputStream blobInputStream = null;
        try {
            cloudBlockBlob = this.blobContainer.getBlockBlobReference(string);
            blobInputStream = cloudBlockBlob.openInputStream();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return blobInputStream;
    }

    public void copy(String string, String string2, HttpSession httpSession) {
        Closeable closeable = null;
        try {
            CloudBlockBlob cloudBlockBlob = this.blobContainer.getBlockBlobReference(string);
            CloudBlockBlob cloudBlockBlob2 = this.blobContainer.getBlockBlobReference(string2);
            cloudBlockBlob2.startCopy(cloudBlockBlob);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002oldFilePath:");
            stringBuilder.append(string);
            stringBuilder.append(" newFilePath:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        finally {
            Closer.ioClose(closeable);
        }
    }

    public void delete(String string, HttpSession httpSession) {
        try {
            CloudBlockBlob cloudBlockBlob = this.blobContainer.getBlockBlobReference(string);
            cloudBlockBlob.delete();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, HttpSession httpSession) {
        String string4 = string + string3;
        String string5 = string + string2;
        if (this.exists(string4, httpSession) && bl) {
            String string6 = string + "_backup/" + string3 + "_" + System.currentTimeMillis() + '.' + FileUtil.getExtension((String)string3);
            this.copy(string4, string6, httpSession);
        }
        this.copy(string5, string4, httpSession);
        this.delete(string5, httpSession);
    }

    public boolean exists(String string, HttpSession httpSession) {
        boolean bl = true;
        try {
            CloudBlockBlob cloudBlockBlob = this.blobContainer.getBlockBlobReference(string);
            if (!cloudBlockBlob.exists()) {
                bl = false;
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return bl;
    }

    public String[] list(String string, HttpSession httpSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (ListBlobItem listBlobItem : this.blobContainer.listBlobs(string)) {
                if (!(listBlobItem instanceof CloudBlob)) continue;
                arrayList.add(((CloudBlob)listBlobItem).getName());
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002startsWith:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append("e");
            throw new HybsSystemException(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Map<String, String> getInfo(String string, HttpSession httpSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CloudBlob cloudBlob = null;
        try {
            cloudBlob = this.blobContainer.getBlobReferenceFromServer(string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002path:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        BlobProperties blobProperties = cloudBlob.getProperties();
        hashMap.put("SIZE", String.valueOf(blobProperties.getLength()));
        hashMap.put("LASTMODIFIED", simpleDateFormat.format(blobProperties.getLastModified()));
        return hashMap;
    }
}

