/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.io;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Future;
import oracle.cloudstorage.text.Strings;

class Md5Stream {
    private final MessageDigest md5er;
    private final oracle.cloudstorage.concurrent.Future<String> futureMd5;

    public Md5Stream() {
        this(null);
    }

    public Md5Stream(oracle.cloudstorage.concurrent.Future<String> futureMd5) {
        try {
            this.md5er = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.futureMd5 = futureMd5 == null ? new oracle.cloudstorage.concurrent.Future() : futureMd5;
    }

    protected final void digest() {
        if (this.futureMd5.isDone()) {
            return;
        }
        byte[] digest = this.md5er.digest();
        String md5 = Strings.toHex(digest);
        this.futureMd5.set(md5);
    }

    protected void update(byte[] bytes, int offset, int read) {
        if (bytes == null) {
            this.md5er.update((byte)read);
        } else {
            this.md5er.update(bytes, offset, read);
        }
    }

    public Future<String> getFutureMd5() {
        return this.futureMd5;
    }

    public void reset() {
        this.md5er.reset();
        this.futureMd5.set(null, false);
    }
}

