/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sendgrid.ASM;
import com.sendgrid.Attachments;
import com.sendgrid.Content;
import com.sendgrid.Email;
import com.sendgrid.MailSettings;
import com.sendgrid.Personalization;
import com.sendgrid.TrackingSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Mail {
    @JsonProperty(value="from")
    public Email from;
    @JsonProperty(value="subject")
    public String subject;
    @JsonProperty(value="personalizations")
    public List<Personalization> personalization;
    @JsonProperty(value="content")
    public List<Content> content;
    @JsonProperty(value="attachments")
    public List<Attachments> attachments;
    @JsonProperty(value="template_id")
    public String templateId;
    @JsonProperty(value="sections")
    public Map<String, String> sections;
    @JsonProperty(value="headers")
    public Map<String, String> headers;
    @JsonProperty(value="categories")
    public List<String> categories;
    @JsonProperty(value="custom_args")
    public Map<String, String> customArgs;
    @JsonProperty(value="send_at")
    public long sendAt;
    @JsonProperty(value="batch_id")
    public String batchId;
    @JsonProperty(value="asm")
    public ASM asm;
    @JsonProperty(value="ip_pool_name")
    public String ipPoolId;
    @JsonProperty(value="mail_settings")
    public MailSettings mailSettings;
    @JsonProperty(value="tracking_settings")
    public TrackingSettings trackingSettings;
    @JsonProperty(value="reply_to")
    public Email replyTo;
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapper();

    public Mail() {
    }

    public Mail(Email from, String subject, Email to, Content content) {
        this.setFrom(from);
        this.setSubject(subject);
        Personalization personalization = new Personalization();
        personalization.addTo(to);
        this.addPersonalization(personalization);
        this.addContent(content);
    }

    @JsonProperty(value="from")
    public Email getFrom() {
        return this.from;
    }

    public void setFrom(Email from) {
        this.from = from;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="asm")
    public ASM getASM() {
        return this.asm;
    }

    public void setASM(ASM asm) {
        this.asm = asm;
    }

    @JsonProperty(value="personalizations")
    public List<Personalization> getPersonalization() {
        return this.personalization;
    }

    public void addPersonalization(Personalization personalization) {
        if (this.personalization == null) {
            this.personalization = new ArrayList<Personalization>();
            this.personalization.add(personalization);
        } else {
            this.personalization.add(personalization);
        }
    }

    @JsonProperty(value="content")
    public List<Content> getContent() {
        return this.content;
    }

    public void addContent(Content content) {
        Content newContent = new Content();
        newContent.setType(content.getType());
        newContent.setValue(content.getValue());
        if (this.content == null) {
            this.content = new ArrayList<Content>();
            this.content.add(newContent);
        } else {
            this.content.add(newContent);
        }
    }

    @JsonProperty(value="attachments")
    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public void addAttachments(Attachments attachments) {
        Attachments newAttachment = new Attachments();
        newAttachment.setContent(attachments.getContent());
        newAttachment.setType(attachments.getType());
        newAttachment.setFilename(attachments.getFilename());
        newAttachment.setDisposition(attachments.getDisposition());
        newAttachment.setContentId(attachments.getContentId());
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachments>();
            this.attachments.add(newAttachment);
        } else {
            this.attachments.add(newAttachment);
        }
    }

    @JsonProperty(value="template_id")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @JsonProperty(value="sections")
    public Map<String, String> getSections() {
        return this.sections;
    }

    public void addSection(String key, String value) {
        if (this.sections == null) {
            this.sections = new HashMap<String, String>();
            this.sections.put(key, value);
        } else {
            this.sections.put(key, value);
        }
    }

    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put(key, value);
        } else {
            this.headers.put(key, value);
        }
    }

    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    public void addCategory(String category) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
            this.categories.add(category);
        } else {
            this.categories.add(category);
        }
    }

    @JsonProperty(value="custom_args")
    public Map<String, String> getCustomArgs() {
        return this.customArgs;
    }

    public void addCustomArg(String key, String value) {
        if (this.customArgs == null) {
            this.customArgs = new HashMap<String, String>();
            this.customArgs.put(key, value);
        } else {
            this.customArgs.put(key, value);
        }
    }

    @JsonProperty(value="send_at")
    public long sendAt() {
        return this.sendAt;
    }

    public void setSendAt(long sendAt) {
        this.sendAt = sendAt;
    }

    @JsonProperty(value="batch_id")
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @JsonProperty(value="ip_pool_name")
    public String getIpPoolId() {
        return this.ipPoolId;
    }

    public void setIpPoolId(String ipPoolId) {
        this.ipPoolId = ipPoolId;
    }

    @JsonProperty(value="mail_settings")
    public MailSettings getMailSettings() {
        return this.mailSettings;
    }

    public void setMailSettings(MailSettings mailSettings) {
        this.mailSettings = mailSettings;
    }

    @JsonProperty(value="tracking_settings")
    public TrackingSettings getTrackingSettings() {
        return this.trackingSettings;
    }

    public void setTrackingSettings(TrackingSettings trackingSettings) {
        this.trackingSettings = trackingSettings;
    }

    @JsonProperty(value="reply_to")
    public Email getReplyto() {
        return this.replyTo;
    }

    public void setReplyTo(Email replyTo) {
        this.replyTo = replyTo;
    }

    public String build() throws IOException {
        return SORTED_MAPPER.writeValueAsString((Object)this);
    }

    public String buildPretty() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    static {
        SORTED_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

