﻿rem /***************************************************************************/
rem /*  このファイルでは、openGionを起動するための環境変数を設定します。       */
rem /*  必要に応じて各種パラメーターを変更します。                             */
rem /***************************************************************************/

rem /***************************************************************************/
rem /*  DB接続先を指定します。(設定必須)                                       */
rem /***************************************************************************/
set REALM_DRIVER=oracle.jdbc.OracleDriver
set REALM_URL=jdbc:oracle:thin:@localhost:1521:XE
set REALM_NAME=GF
set REALM_PASSWORD=GF

rem /***************************************************************************/
rem /*  HTTP,AJP,シャットダウンポートを指定します。(任意設定)                  */
rem /***************************************************************************/
set SHUTDOWN_PORT=8006
set CONNECTOR_PORT=8824
set AJP_PORT=8010

rem /***************************************************************************/
rem /*  Java・Tomcat・OpenOfficeのバージョンを設定します。(標準推奨)           */
rem /***************************************************************************/
set JDK_VER=jdk180u121x64
set TOMCAT_VER=tomcat8.5.33
set OPENOFFICE_VER=openoffice3.2

rem /***************************************************************************/
rem /*  コンテキスト名、及び自動インストールタイプを指定します。(標準推奨)     */
rem /*   DEV_CTXT  : 開発用コンテスト                                          */
rem /*   CORE_CTXT : コアシステム用コンテキスト                                */
rem /*   INSTALL_CONTEXTS : 初回起動時にDB環境のインストールを行うコンテキスト */
rem /*                      [%CORE_CTXT%,%DEV_CTXT%]:Full版(含開発環境)        */
rem /*                      [%CORE_CTXT%]           :コアシステムのみ          */
rem /***************************************************************************/
rem set DEV_CTXT=gf
rem set CORE_CTXT=ge
rem set INSTALL_CONTEXTS=%CORE_CTXT%,%DEV_CTXT%

rem /***************************************************************************/
rem /*  Javaの設定です                                                         */
rem /*  メモリの使用量等を指定します                                           */
rem /***************************************************************************/
set JAVA_OPTS=-Xms64m -Xmx512m
rem set JAVA_OPTS=-Xms1024m -Xmx1024m -Xss256k -XX:PermSize=32m -XX:MaxPermSize=128m

call %~dp0\const.bat
