/****************************************************************************/
/* GF46 ( 位置情報ｻﾝﾌﾟﾙ )                                                   */
/*                                                                          */
/* Created : 2018/06/08 16:45:27                                            */
/****************************************************************************/
CREATE TABLE GF46 (
   LOC_ID       VARCHAR2 ( 100 )                    NOT NULL            /*  10 位置ID   */
 , COL_ID       NUMBER   (   3 )                    NOT NULL            /*  20 列ID     */
 , ROW_ID       NUMBER   (   3 )                    NOT NULL            /*  30 行ID     */
 , FGCELLEDIT   VARCHAR2 (   1 )                                        /*  40 枡編集F  */
 , CELLNAME     VARCHAR2 ( 100 )                                        /*  50 枡名     */
 , VALUE        VARCHAR2 ( 100 )                                        /*  60 値       */
 , COLOR        VARCHAR2 (  50 )                                        /*  70 色記号   */
 , CDJ          VARCHAR2 (   2 )                    NOT NULL            /*  80 状況ｺｰﾄﾞ */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ   */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ */
 , DYSET        VARCHAR2 (  14 )                                        /* 820 登録日時 */
 , PGSET        VARCHAR2 (  10 )                                        /* 830 作成PG   */
 , PGPSET       VARCHAR2 (  10 )                                        /* 840 作成親PG */
 , USRSET       VARCHAR2 (  10 )                                        /* 850 作成社員 */
 , DYUPD        VARCHAR2 (  14 )                                        /* 860 更新日時 */
 , PGUPD        VARCHAR2 (  10 )                                        /* 870 更新PG   */
 , PGPUPD       VARCHAR2 (  10 )                                        /* 880 更新親PG */
 , USRUPD       VARCHAR2 (  10 )                                        /* 890 更新者   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GF46S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF46T00 
  BEFORE INSERT ON GF46
  FOR EACH ROW 
  BEGIN 
    SELECT GF46S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
