/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.TokenService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import org.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import org.openstack4j.openstack.identity.v3.domain.KeystoneService;
import org.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class TokenServiceImpl
extends BaseOpenStackService
implements TokenService {
    @Override
    public Token get(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneToken.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse check(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.head(ActionResponse.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse delete(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.deleteWithResponse("/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public List<? extends Service> getServiceCatalog(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneService.Catalog.class, this.uri("auth/catalog", new Object[0])).header("X-Subject-Token", tokenId).execute().getList();
    }

    @Override
    public List<? extends Project> getProjectScopes(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneProject.Projects.class, this.uri("auth/projects", new Object[0])).header("X-Subject-Token", tokenId).execute().getList();
    }

    @Override
    public List<? extends Domain> getDomainScopes(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneDomain.Domains.class, this.uri("auth/domains", new Object[0])).header("X-Subject-Token", tokenId).execute().getList();
    }
}

