/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.common;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TelemetryDateDeserializer
extends StdDeserializer<Date> {
    private static final String MILLIS_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    public TelemetryDateDeserializer() {
        this(null);
    }

    public TelemetryDateDeserializer(Class<?> vc) {
        super(vc);
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String date = jsonParser.getText();
        SimpleDateFormat sdf = new SimpleDateFormat(MILLIS_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return sdf.parse(this.getParseableDate(date));
        }
        catch (ParseException e) {
            throw new JsonParseException(jsonParser, "Could not process telemetry date", (Throwable)e);
        }
    }

    private String getParseableDate(String date) {
        String[] sdate = date.split("\\.");
        if (sdate.length > 1) {
            return sdate[0] + "." + this.getExpectedDecimals(sdate[1]);
        }
        return date + ".000";
    }

    private String getExpectedDecimals(String decimals) {
        return (decimals + "000").substring(0, 3);
    }
}

