/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFileFilter;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsFileFilter;
import org.opengion.fukurou.util.StringUtil;

public abstract class AbstractFileOperation
implements FileOperation {
    private static final int BUFFER_SIZE = 4096;
    protected final String path;
    protected final String bucket;

    public AbstractFileOperation() {
        this.path = "";
        this.bucket = "";
    }

    public AbstractFileOperation(String string, String string2) {
        this.path = this.editPath(this.replaceFileSeparetor(string2));
        this.bucket = string;
        if (StringUtil.isNull(this.bucket)) {
            String string3 = "\u30d0\u30b1\u30c3\u30c8\u672a\u6307\u5b9a\u3067\u3059\u3002hayabusa\u5229\u7528\u3067\u306f\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u306e\u300cCLOUD_BUCKET\u300d\u306b\u30d0\u30b1\u30c3\u30c8\u540d\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002";
            throw new RuntimeException(string3);
        }
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002write(InputStream is)";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002read()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public boolean delete() {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002delete()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public boolean copy(String string) {
        String string2 = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002copy(String)";
        throw new UnsupportedOperationException(string2);
    }

    @Override
    public boolean move(String string) {
        boolean bl = false;
        bl = this.copy(string);
        if (bl) {
            bl = this.delete();
        }
        return bl;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.drawName(this.path);
    }

    @Override
    public String getParent() {
        return this.drawParent(this.path);
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean exists() {
        return this.isDirectory() | this.isFile();
    }

    @Override
    public FileOperation[] listFiles() {
        return this.listFiles(new HybsFileFilter());
    }

    @Override
    public FileOperation[] listFiles(FileOperationFileFilter fileOperationFileFilter) {
        String string = "\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002listFiles(FileOperationFileFilter)";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    public boolean renameTo(FileOperation fileOperation) {
        return this.move(fileOperation.getPath());
    }

    @Override
    public FileOperation getParentFile() {
        return null;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createNewFile() throws IOException {
        boolean bl = false;
        if (!this.exists()) {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                this.write(byteArrayInputStream);
                bl = true;
            }
            catch (Throwable throwable) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable;
            }
            Closer.ioClose(byteArrayInputStream);
        }
        return bl;
    }

    @Override
    public boolean setLastModified(long l) {
        return true;
    }

    @Override
    public FileOperation getCanonicalFile() throws IOException {
        return this;
    }

    public String toString() {
        return this.path;
    }

    protected String editPath(String string) {
        if (StringUtil.isNull(string)) {
            return "";
        }
        String string2 = string;
        if ("/".equals(string2.substring(0, 1))) {
            string2 = string2.substring(1);
        }
        string2 = string2.replaceAll("//", "/");
        string2 = this.rTrim(string2, '.');
        string2 = this.rTrim(string2, '/');
        return string2;
    }

    protected String drawParent(String string) {
        int n = string.lastIndexOf("/");
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(0, string.lastIndexOf("/"));
        }
        if ("/".equals(File.separator)) {
            string2 = File.separator + string2;
        }
        return string2;
    }

    protected String drawName(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(string.lastIndexOf("/") + 1);
        }
        return string2;
    }

    protected String setDirTail(String string) {
        if (StringUtil.isNull(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (!"/".equals(string.substring(string.length() - 1))) {
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    protected String rTrim(String string, char c) {
        String string2 = string;
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
            n = i;
            if (n != 0) continue;
            string2 = "";
        }
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected String replaceFileSeparetor(String string) {
        if (StringUtil.isNull(string)) {
            return "";
        }
        return string.replaceAll("\\\\", "/");
    }

    protected FileOperation[] filter(List<FileOperationInfo> list, FileOperationFileFilter fileOperationFileFilter) {
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        for (int i = 0; i < list.size(); ++i) {
            if (!fileOperationFileFilter.accept(list.get(i))) continue;
            arrayList.add(list.get(i));
        }
        return arrayList.toArray(new FileOperationInfo[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }
}

