/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.opengion.fukurou.model.AbstractFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFileFilter;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.HybsFileFilter;

public class DefaultFileOperation
extends AbstractFileOperation {
    private final File file;

    public DefaultFileOperation(String string) {
        this.file = new File(string);
    }

    public DefaultFileOperation(String string, String string2) {
        this(string2);
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        Files.copy(inputStream, Paths.get(this.file.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        return new FileInputStream(this.file.getPath());
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean copy(String string) {
        boolean bl = false;
        try {
            Files.copy(Paths.get(this.file.getPath(), new String[0]), Paths.get(string, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public boolean move(String string) {
        boolean bl = false;
        try {
            Files.move(Paths.get(this.file.getPath(), new String[0]), Paths.get(string, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public FileOperation[] listFiles() {
        return this.listFiles(new HybsFileFilter());
    }

    @Override
    public FileOperation[] listFiles(FileOperationFileFilter fileOperationFileFilter) {
        if (!this.exists()) {
            return new FileOperationInfo[0];
        }
        File file = null;
        try {
            file = this.file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return new FileOperationInfo[0];
        }
        File[] fileArray = file.listFiles();
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        for (File file2 : fileArray) {
            FileOperationInfo fileOperationInfo = new FileOperationInfo();
            fileOperationInfo.setPath(file2.getPath());
            fileOperationInfo.setName(file2.getName());
            fileOperationInfo.setParent(file2.getParent());
            fileOperationInfo.setLastModifiedValue(file2.lastModified());
            fileOperationInfo.setCanWrite(file2.canWrite());
            fileOperationInfo.setCanRead(file2.canRead());
            fileOperationInfo.setHidden(file2.isHidden());
            if (file2.isFile()) {
                fileOperationInfo.setFile(true);
                fileOperationInfo.setSize(file2.length());
            } else if (file2.isDirectory()) {
                fileOperationInfo.setDirectory(true);
            }
            arrayList.add(fileOperationInfo);
        }
        Object[] objectArray = this.filter(arrayList, fileOperationFileFilter);
        return objectArray;
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public boolean renameTo(FileOperation fileOperation) {
        return this.file.renameTo(new File(fileOperation.getPath()));
    }

    @Override
    public FileOperation getParentFile() {
        return new DefaultFileOperation(this.getParent());
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    @Override
    public boolean setLastModified(long l) {
        return this.file.setLastModified(l);
    }

    @Override
    public FileOperation getCanonicalFile() throws IOException {
        File file = this.file.getCanonicalFile();
        return new DefaultFileOperation(file.getPath());
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public static void main(String[] stringArray) {
    }
}

