/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.model.FileOperationFileFilter;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.ModifyFileFilter;

public final class HybsFileFilter
implements FileFilter,
FileOperationFileFilter {
    private final List<FileFilter> list = new ArrayList<FileFilter>();
    private final List<FileOperationFileFilter> foList = new ArrayList<FileOperationFileFilter>();
    private final boolean isUseDIR;

    public HybsFileFilter(boolean bl) {
        this.isUseDIR = bl;
    }

    public HybsFileFilter() {
        this(false);
    }

    @Override
    public boolean accept(File file) {
        if (file != null && (file.isFile() || this.isUseDIR)) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this.list.get(i);
                if (fileFilter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean accept(FileOperationInfo fileOperationInfo) {
        if (fileOperationInfo != null && (fileOperationInfo.isFile() || this.isUseDIR)) {
            int n = this.foList.size();
            for (int i = 0; i < n; ++i) {
                FileOperationFileFilter fileOperationFileFilter = this.foList.get(i);
                if (fileOperationFileFilter.accept(fileOperationInfo)) continue;
                return false;
            }
        }
        return true;
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.list.add(fileFilter);
        }
    }

    public void addFileFilter(FileOperationFileFilter fileOperationFileFilter) {
        if (fileOperationFileFilter != null) {
            this.foList.add(fileOperationFileFilter);
        }
    }

    public void startsWith(String string) {
        this.startsWith(string, false);
    }

    public void startsWith(String string, boolean bl) {
        if (string != null) {
            StartsWithFilter startsWithFilter = new StartsWithFilter(string, bl);
            this.list.add(startsWithFilter);
            this.foList.add(startsWithFilter);
        }
    }

    public void endsWith(String string) {
        this.endsWith(string, false);
    }

    public void endsWith(String string, boolean bl) {
        if (string != null) {
            EndsWithFilter endsWithFilter = new EndsWithFilter(string, bl);
            this.list.add(endsWithFilter);
            this.foList.add(endsWithFilter);
        }
    }

    public void instr(String string) {
        this.instr(string, false);
    }

    public void instr(String string, boolean bl) {
        if (string != null) {
            InstrFilter instrFilter = new InstrFilter(string, bl);
            this.list.add(instrFilter);
            this.foList.add(instrFilter);
        }
    }

    public void fileEquals(String string) {
        this.fileEquals(string, false);
    }

    public void fileEquals(String string, boolean bl) {
        if (string != null) {
            EqualsFilter equalsFilter = new EqualsFilter(string, bl);
            this.list.add(equalsFilter);
            this.foList.add(equalsFilter);
        }
    }

    public void matches(String string) {
        this.matches(string, false);
    }

    public void matches(String string, boolean bl) {
        if (string != null) {
            MatchesFilter matchesFilter = new MatchesFilter(string, bl);
            this.list.add(matchesFilter);
            this.foList.add(matchesFilter);
        }
    }

    public void lastModified(String string) {
        if (string != null) {
            ModifyFileFilter modifyFileFilter = new ModifyFileFilter(string);
            this.list.add(modifyFileFilter);
            this.foList.add(modifyFileFilter);
        }
    }

    private long getByteSize(String string) {
        if (string == null) {
            return -1L;
        }
        String string2 = string;
        int n = string2.length();
        if (n > 0 && 'B' == string2.charAt(n - 1)) {
            string2 = string2.substring(0, n - 1);
            --n;
        }
        long l = -1L;
        long l2 = -1L;
        if (n > 0) {
            char c = string2.charAt(n - 1);
            switch (c) {
                case 'K': {
                    l2 = 1024L;
                    break;
                }
                case 'M': {
                    l2 = 0x100000L;
                    break;
                }
                case 'G': {
                    l2 = 0x40000000L;
                    break;
                }
            }
            if (l2 > 0L) {
                string2 = string2.substring(0, n - 1);
                --n;
            } else {
                l2 = 1L;
            }
        }
        if (n > 0) {
            l = l2 * Long.parseLong(string2);
        }
        return l;
    }

    public void isLarger(String string) {
        long l = this.getByteSize(string);
        if (l >= 0L) {
            IsLargerFilter isLargerFilter = new IsLargerFilter(l);
            this.list.add(isLargerFilter);
            this.foList.add(isLargerFilter);
        }
    }

    public void isSmaller(String string) {
        long l = this.getByteSize(string);
        if (l >= 0L) {
            this.list.add(new IsSmallerFilter(l));
        }
    }

    public void isHidden(String string) {
        this.isHidden(string, false);
    }

    public void isHidden(String string, boolean bl) {
        if (string != null) {
            IsHiddenFilter isHiddenFilter = new IsHiddenFilter(string, bl);
            this.list.add(isHiddenFilter);
            this.foList.add(isHiddenFilter);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("no[").append(i).append("]=");
            stringBuilder.append(this.list.get(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    private static class IsHiddenFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final boolean flg;
        private final boolean rvse;

        IsHiddenFilter(String string, boolean bl) {
            this.flg = Boolean.parseBoolean(string);
            this.rvse = bl;
        }

        @Override
        public boolean accept(File file) {
            return file.isHidden() ^ !this.flg ^ this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            return fileOperationInfo.isHidden() ^ !this.flg ^ this.rvse;
        }
    }

    private static class IsSmallerFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final long size;

        IsSmallerFilter(long l) {
            this.size = l;
        }

        @Override
        public boolean accept(File file) {
            return file.length() < this.size;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            return fileOperationInfo.length() < this.size;
        }
    }

    private static class IsLargerFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final long size;

        IsLargerFilter(long l) {
            this.size = l;
        }

        @Override
        public boolean accept(File file) {
            return file.length() >= this.size;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            return fileOperationInfo.length() >= this.size;
        }
    }

    private static class MatchesFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final Pattern pattern;
        private final boolean rvse;

        MatchesFilter(String string, boolean bl) {
            this.pattern = Pattern.compile(string, 2);
            this.rvse = bl;
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            if (matcher.find()) {
                return !this.rvse;
            }
            return this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            Matcher matcher = this.pattern.matcher(fileOperationInfo.getName());
            if (matcher.find()) {
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class EqualsFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final String[] eqstr;
        private final int cnt;
        private final boolean rvse;

        EqualsFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.eqstr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.eqstr[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().equalsIgnoreCase(this.eqstr[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!fileOperationInfo.getName().equalsIgnoreCase(this.eqstr[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class InstrFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final String[] instr;
        private final int cnt;
        private final boolean rvse;

        InstrFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.instr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.instr[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (file.getName().indexOf(this.instr[i]) < 0) continue;
                return !this.rvse;
            }
            return this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            for (int i = 0; i < this.cnt; ++i) {
                if (fileOperationInfo.getName().indexOf(this.instr[i]) < 0) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class EndsWithFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final String[] sfix;
        private final int cnt;
        private final boolean rvse;

        EndsWithFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.sfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.sfix[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().endsWith(this.sfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!fileOperationInfo.getName().endsWith(this.sfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class StartsWithFilter
    implements FileFilter,
    FileOperationFileFilter {
        private final String[] pfix;
        private final int cnt;
        private final boolean rvse;

        StartsWithFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.pfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.pfix[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().startsWith(this.pfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }

        @Override
        public boolean accept(FileOperationInfo fileOperationInfo) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!fileOperationInfo.getName().startsWith(this.pfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }
}

