<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2000"
	title	= "テーブルスペース"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLESPACE_NAME,SYSTEM_ID,TBLSYU,NAME_JA"
/>

<og:entry command = "{@command}" />

<og:value command="SET" key="TITLE" ><og:message lbl="TABLESPACE_NAME" /></og:value>

<table><tr><td>
<og:chartCreate
	title		= "{@LBL.TABLESPACE_NAME}"
	width		= "300"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Pie"
	>
			select TABLESPACE_NAME,
					SUM(INITIAL_AUTO) AS KEI
			from GF02
		<og:where>
			<og:and value = "FGJ             in  ('0','1')"              />
			<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
			<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
			<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		</og:where>
			group by TABLESPACE_NAME
			order by TABLESPACE_NAME
	</og:chartDataset>
</og:chartCreate>
</td><td>
<og:chartCreate
	title		= "{@LBL.TABLESPACE_NAME}"
	width		= "300"
	height		= "200"
>
	<og:chartDataset
		chartType	= "Bar"
	>
			select TABLESPACE_NAME,
					SUM(INITIAL_AUTO) AS KEI
			from GF02
		<og:where>
			<og:and value = "FGJ             in  ('0','1')"              />
			<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
			<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
			<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
		</og:where>
			group by TABLESPACE_NAME
			order by TABLESPACE_NAME
	</og:chartDataset>
</og:chartCreate>
</td></tr>
</table>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select TABLESPACE_NAME,TABLE_NAME,
				SUM(INITIAL_AUTO) AS KEI, SUM(INITIAL_AUTO)/100 AS RATIO,
				GROUPING(TABLESPACE_NAME) || GROUPING(TABLE_NAME) AS SYOKEI
		from GF02
	<og:where>
		<og:and value = "FGJ             in  ('0','1')"              />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"       />
		<og:and value = "TBLSYU          like '{@TBLSYU}%'"          />
		<og:and value = "TABLESPACE_NAME like '{@TABLESPACE_NAME}%'" />
	</og:where>
		group by ROLLUP(TABLESPACE_NAME,TABLE_NAME)
		order by TABLESPACE_NAME,TABLE_NAME
</og:query>

<og:columnEditor column="KEI" renderer="NUMBER" />

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	startNo    = "{@startNo}"
	checked    = "{@checked}"
	pageSize   = "{@pageSize}"
	rowspan    = "1"
	headerSkipCount = "0"
>
	<og:thead rowspan="1">
		<tr><td>[TABLESPACE_NAME]</td><td>[TABLE_NAME]</td><td>[KEI]</td>
		<td>[RATIO]</td></tr>
	</og:thead>
	<og:tbody usableKey="SYOKEI" usableList="00" rowspan="1">
		<tr><td>[TABLESPACE_NAME]</td><td>[TABLE_NAME]</td><td>[KEI]</td>
		<td><img width="[RATIO]px"  align="left" height="10px" src="{@SYS.JSP}/image/space_red.gif" alt="[RATIO]" /></td></tr>
	</og:tbody>
	<og:tbody usableKey="SYOKEI" usableList="01" rowspan="1" >
		<tr class="row_h"><td>[TABLESPACE_NAME]</td><td class="label">SYOKEI</td><td>[KEI]</td>
		<td></td></tr>
	</og:tbody>
	<og:tbody usableKey="SYOKEI" usableList="11" rowspan="1" >
		<tr class="row_h"><td class="label">GOKEI</td><td></td><td>[KEI]</td>
		<td></td></tr>
	</og:tbody>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
