package org.opengion.hayabusa.io;

import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

/**
 * クラウド別のクラス生成
 * 
 * @og.rev 5.10.8.0 (2019/02/01) 新規作成
 * @og.group
 *
 * @version 5.0
 * @author Takahashi Masakazu
 * @sinse JDK7.0
 */
public class HybsFileOperationFactory {
	private static String defPlugin=HybsSystem.sys("CLOUD_TARGET");
	
	/**
	 * コンストラクタはprivate化しておきます。
	 */
	private HybsFileOperationFactory(){
		// コンストラクタ
	}

	/**
	 * fukurouのFileOperationFactoryを呼び出してFOInterfaceを取得します。
	 * plugin,buketを指定しない場合はシステムリソースを利用します。
	 * 
	 * @param plugin
	 * @param buket
	 * @param path
	 * @return FileOperationインタフェース
	 */
	public static FileOperation create(String plugin, String buket, String path) {
		return FileOperationFactory.newStorageOperation(StringUtil.nval(plugin, defPlugin), buket, path);
	}
	
	/**
	 * ディレクトリとファイル名を指定用です。
	 * 
	 * @param plugin
	 * @param buket
	 * @param dir
	 * @param file
	 * @return FileOperationインタフェース
	 */
	public static FileOperation create(String plugin, String buket, String dir, String file) {
		StringBuilder sb = new StringBuilder(HybsSystem.BUFFER_SMALL);
		sb.append(dir).append(HybsSystem.FS).append(file);
		return create(plugin, buket, sb.toString());
	}
	
	/**
	 * FileOperation(ディレクトリ)とファイル名を指定用です。
	 * 
	 * @param plugin
	 * @param buket
	 * @param dir
	 * @param file
	 * @return FileOperationインタフェース
	 */
	public static FileOperation create(String plugin, String buket, FileOperation dir, String file) {
		StringBuilder sb = new StringBuilder(HybsSystem.BUFFER_SMALL);
		sb.append(dir.getPath()).append(HybsSystem.FS).append(file);
		return create(plugin, buket, sb.toString());
	}
}
