/* version: 0.0.1 
 * author : Sen Li
 * date   : 2012/05/10
 * 機能   : ガント図の描画
 *          2012/10/01 Takahashi Masakazu stackGantt機能追加
 *          2012/10/12 S.Li IEバグ対応、要素がコピー(cloneNode)後、selectの選択状態が初期に戻ってしまう不具合の対応
 *          2013/01/31 S.Li ①終了日は開始日と同じで、開始終了時間が未設定の場合は開始時間を0000、終了時間を2400に見なす。
 *							②ガント時間の14桁対応(12桁以降無視するように)
 *							③レンダラ―（日付、時間）の対応
 *			2013/02/22 Takahashi Masakazu ガントマーカーが範囲外の場合は描画しないように変更
 *			2013/02/22 K.H 積上げガントと融合。色コードを番号で指定できる機能を追加
 *			2013/03/01 時間単位、日単位のガントの条件を変更（10以下、40番台を日単位と考える）
 *			2013/03/08 内部積上げガント対応
 *					   firefox対応(getAttribute化,innerText対応,all.tagsの$().find化、配列への[キャスト],undefined系の処理変更)
 *			2013/03/15 firefox追加対応(画像titleセット等),Endのみの指定でマーカーを出す、時間指定の休日取得対応
 *			2013/03/22 13 : 日(週) 追加。parseInt( gantZoom ,10 ) <= 13 に変更(10→13)
 *			2013/04/19 ガントバーが期間を超える場合の処理変更
 *			2013/05/10 5.6.4.2 (2013/05/17) paddingLeft,paddingRigth 属性追加
 *          2013/06/17 S.Li スクロール部分のプルダウン(select)要素を無効にする(左右分割の時、プルダウンの選択値が更新されない不具合対応)
 *          2013/06/17 S.Li 負荷積上げの高さ計算バグの修正
 *          2013/09/03 S.Li ガントバーの移動歩幅単位（moveStep 1:日、2:時間、3:分）の属性追加
 *          2013/09/11 S.Li margeRows="true"の負荷積み上げ対応
 *			2015/09/04 5.9.0.0 all.tagsの箇所の対応（HTML5対応）6.3.6.1からの移植
 *			2016/01/09 5.9.4.1 IE11.removeChildの仕様変更対応,split処理追加,capacityのセット方法修正
 *			2016/01/22 5.9.4.4 get/setAttribute及びevent.button対応
 *			2016/02/19 5.9.5.2 5.9.4.4の対応漏れ
 *			2017/09/01 5.9.24.0 Edge対応
 *			2018/07/20 5.10.1.2 積み上げ修正など
 */

/*
 * 変数を隠蔽するため、クロージャー化します。
 */
var adjustGanttTable = (function(){

var debugMsg;							// テストメッセージ

// 属性変数
var gantZoom;							// ガントズーム
var gantStartDate;						// ガントの描画開始日付(時間)
var gantEndDate;						// 
var daySpan;
var skipHoliday;						// 休日を飛ばすか
var arrCalender;						// カレンダー配列
var verticalShift = "true";				// ガントバー要素の縦方向でずらす
var paddingLeft   = 0;					// 5.6.4.2 (2013/05/17) ガントバーの間の左区切りスペース 
var paddingRigth  = 0;					// 5.6.4.2 (2013/05/17) ガントバーの間の右区切りスペース 
var margeRows	  = "false";			// 複数行のマージ、条件：前の行のデータと一致する時
var fixedCols	  = 0;					// 列固定、固定列の数
var useBgColor	  = "true";				// 縞々背景色の使用 2012/09/26 ADD
// StackGantt用 2012/10/01
// var stdUpper	  = 1.0;	// 2012/09/26 DEL
// var stdCost	  = 1.0;	// 2012/09/26 DEL
// var stdLower	  = 0;		// 2012/09/26 DEL
var viewGantt	  = "true";				// stack時のガント積上げ
var viewMode	  = "1";				// stack時のガント積上げ
var stackHoliday  = "true";				// 休日も積上げするかどうか

// 全域変数
var hoursPreDay;						// 一日の描画時間数
var gantStartTime;						// 始業時間
var gantEndTime;						// 終業時間
var gantDaySpan;						// 一日の時間数

// ガントバー移動用の変数
var hilightBar = null;
var startX;
var oriLeft;
var oriWidth;
var oriPixelLeft;
var cnBunkatu  = 3;
var startDateInputObj = null;
var endDateInputObj = null;
var startTimeInputObj = null;
var endTimeInputObj = null;
var calenderDays=0;
// Mouse Action
var cnMNone    = 0;
var cnMLeft    = 1;
var cnMMiddle  = 2;
var cnMRight   = 3;
var nLeftRightLimit = 2;		// sayu no tukamishiro no saishou-chi
var nMAction;

// システム定数
var SYS_BAR_HEIGHT		 	= 10;		// ガントバー要素の高さ
var SYS_MIN_HEIGHT_SHIFT 	= 40;		// ガントバー要素の縦方向でずらす場合の行高さ
var SYS_MIN_HEIGHT_NO_SHIFT = 30;		// ガントバー要素の縦方向でずらさない場合の行高さ
var SYS_MARKER_OFFSET_H	 	= 3;		// マーカーとバーの縦方向の相対位置
var SYS_CELLPADDING			= 0;		// 
var SYS_NUMBER_CELLS		= 3;		// viewTableの番号列の数
var SYS_OFFSET_LEFT			= -1;		// 
// stackGantt用 2012/10/01
var SYS_STD_COST			= 'stdcost';  //標準工数内の場合に付くクラス名
var SYS_UPPER_COST			= 'uppercost';//工数が超えた場合に付くクラス名
var SYS_LOWER_COST			= 'lowercost';//工数が不足した場合に付くクラス名
var SYS_WARN_COST			= 'warncost';
var SYS_ERROR_COST			= 'errorcost';
var SYS_WARN_BOUND		 	= 1.5;		  //標準能力 ～ 標準能力*1.5 の間は警告域とする。
var SYS_STDCOST				= 1;		  //2012/09/26 ADD	
var SYS_LINK_TARGET			= "CONTENTS"; //デフォルトリンク先 2012/09/27 ADD
// var SYS_BAR_PADDING			= 2;		  //ガントバーの間の区切りスペース 2013/05/13 ADD
/*
    ZOOM  ラベル        日数ピクセル変換率          ヘッダ上      ヘッダ下    1文字(CSS)
  ==================================================================================
     0 : １週間 日数 *  8 * 6       48    48px =  1日  [02/   ]      [23(EE)]       8px
     1 : ２週間 日数 *  8 * 3       24    24px =  1日  [02/]         [23 ]          8px
     2 : １ヶ月 日数 *  12* 1       12    12px =  1日  [2]           [3]           12px
     3 : ２ヶ月 日数 *  8 * 7  /  7  8    56px =  7日  [2004/  ]     [02/03  ]      8px
     4 : ３ヶ月 日数 *  8 * 7  / 14  4    56px = 14日  [2004/  ]     [02/03  ]      8px
     5 : ４ヶ月 日数 *  9 * 10 / 30  3    90px = 30日  [2004/     ]  [02/03     ]   9px
     6 : ６ヶ月 日数 * 10 / 6  / 30  2    60px = 30日  [2004/ ]      [02/03 ]      10px
     7 : １年   日数 *  9 / 10 / 90  1    90px = 90日  [2004/     ]  [02/03     ]   9px
     8 : ２年   日数 *  9 / 10 /180  0.5  90px =180日  [2004/     ]  [02/03     ]   9px
     9 : ３年   日数 * 10 / 6  /180  0.33 60px =180日  [2004/ ]      [02/03 ]      10px
    10 : 週単位 日数 *  8 / 3  /  7  3.43 24px =  7日  [19W]         [12 ]          8px
    11 : 予約済み(他物10件使用済み)
    12 : 予約済み(他物 8件使用済み)
    13 : 日(週) 日数 *  8 * 2        16   16px =  1日  [23]          [EE]           8px
  ========================================================================================
    20 :  1時間   時間 * 12 * 4        48 48px = 1時間 [02日]        [07h ]        12px
    21 :  1時間2  時間 * 12 * 2        24 24px = 1時間 [02]          [07]          12px
    22 :  2時間   時間 * 12 * 4  /  2  24 48px = 2時間 [02日]        [07h ]        12px
    23 :  2時間2  時間 * 12 * 2  /  2  12 24px = 2時間 [02]          [07]          12px
    24 :  4時間   時間 * 12 * 4  /  4  12 48px = 4時間 [02日]        [07h ]        12px
    25 :  4時間2  時間 * 12 * 2  /  4   6 24px = 4時間 [02]          [07]          12px
    26 :  6時間   時間 * 12 * 4  /  6   8 48px = 6時間 [02日]        [07h ]        12px
    27 :  6時間2  時間 * 12 * 2  /  6   4 24px = 6時間 [02]          [07]          12px
    28 :  8時間   時間 * 12 * 4  /  8   6 48px = 8時間 [02日]        [07h ]        12px
    29 :  8時間2  時間 * 12 * 2  /  8   3 24px = 8時間 [02]          [07]          12px
    30 : 12時間   時間 * 12 * 4  / 12   4 48px =12時間 [02日]        [07h ]        12px
    31 : 12時間2  時間 * 12 * 2  / 12   2 24px =12時間 [02]          [07]          12px
  ========================================================================================
    DAY   : １週間 日数 * 12 * 4     48   48px =  1日  [02/   ]      [23(EE)]       8px		(廃止)
    WEEK  : 週単位 日数 * 12 / 3.5   3.43 42px =  7日  [19W   ]      [12    ]       8px		(廃止)
    MONTH : １年   日数 * 12 / 12     1   90px = 30日  [2004/     ]  [02/03     ]   9px		(廃止)
    40 : 積上(日)                    48   48px =  1日  [02/   ]      [23(EE)]       8px		// 2013/02/22
    41 : 積上(週)                    3.43 48px =  7日  [19W]         [12 ]          8px		// 2013/02/22
    42 : 積上(月) 月数 * 1            1   90px = 30日  [2004/     ]  [02/03     ]   9px		// 2013/02/22
*/
// ガントセル幅
var unitPixel = {"0" : 48 ,"1" : 24 ,"2" : 12 ,"3" : 56 ,"4" : 56 ,"5" : 90 ,"6" : 60 ,"7" : 90 ,"8" : 90 ,"9" : 60 ,"10": 24 ,"13": 16 ,"20": 48 ,"21": 24 ,"22": 48 ,"23": 24 ,"24": 48 ,"25": 24 ,"26": 48 ,"27": 24 ,"28": 48 ,"29": 24 ,"30": 48 ,"31": 24
					,"DAY" : 48 ,"WEEK": 48,"MONTH" : 90 ,"40" : 48 ,"41": 48,"42" : 90 };
// ガントセル毎の日数・時間数
var unitSpan  = {"0" : 1  ,"1" : 1  ,"2" : 1  ,"3" : 7  ,"4" : 14 ,"5" : 30 ,"6" : 30 ,"7" : 90 ,"8" :180 ,"9" :180 ,"10":  7 ,"13":  1 ,"20":  1 ,"21":  1 ,"22":  2 ,"23":  2 ,"24":  4 ,"25":  4 ,"26":  6 ,"27":  6 ,"28":  8 ,"29":  8 ,"30": 12 ,"31": 12 
					,"DAY" : 1  ,"WEEK":  7,"MONTH" : 30 ,"40" : 1  ,"41":  7,"42" : 30 };

// 2013/02/22 色番号の対応表
//var colorNoList = { "1":"black", "2":"lightblue", "3":"blue", "4":"lightgreen", "5":"green", "6":"orange", "7":"pink", "8":"red", "9":"brown", "10":"purple", "11":"black2", "12":"yellow", "13":"violet", "14":"navy", "15":"glay", "16":"darkgreen"
//					,"17":"teal", "18":"indigo", "19":"chocolate", "20":"slategray", "21":"darkslategray" };
// 2013/03/08 ０から９までの対応に変更
//var colorNoList = { "0":"blue", "1":"orange", "2":"pink", "3":"purple", "4":"yellow", "5":"violet", "6":"green", "7":"navy"
//					, "8":"chocolate","9":"teal" };

// 5.6.3.1 (2013/04/05) 色を増やします。
var colorNoList = {
		"0"  : "blue"		, "1"  : "black"	, "2"  : "brown"	, "3"  : "green"		, "4"  : "lightblue"	, "5" :  "lightgreen"	,
		"6"  : "orange"		, "7"  : "pink"		, "8"  : "purple"	, "9"  : "red"			, "10" : "yellow"		,
		"11" : "navy"		, "12" : "teal"		, "13" : "gray"		, "14" : "indigo"		, "15" : "slategray"	,
		"16" : "chocolate"	, "17" : "darkgreen", "18" : "violet"	, "19" : "darkslategray", "20" : "lime"			,
		"21" : "aqua"		, "22" : "maroon"	, "23" : "olive"	, "24" : "silver"		, "25" : "fuchsia"		,
		"BK" : "black2"		, "WT" : "white2"	, "BL" : "blue2"	, "RD" : "red2"			, "YL" : "yellow2"		, length : 26
	} ;

//リストオブジェクト
function List(){
	this.head    = null; 
	this.end     = null; 
	this.current = null;
	this.size    = 0;
} 

//リストにノードを追加する
List.prototype.add = function( inObj ){ 
	var node = { obj:inObj ,next:null }; 
	if( this.head ){ 
		this.end.next = node; 
		this.end	  = node; 
	}
	else{ 
		this.head    = node; 
		this.end     = node; 
		this.current = node; 
	} 
	this.size++;
} 

//リストから次のノードを取得する
List.prototype.next = function(){ 
	var node = null;
	if( this.current ){ 
		node		 = this.current.obj; 
		this.current = this.current.next;
	}
	return node; 
} 

//リストから次のノードが存在するかを確認する
List.prototype.hasnext = function(){ 
	if( this.current != null ) return true; 
	return false; 
}

// Arrayコピー用のメソッドを追加する。
Array.prototype.clone = function(){
    return Array.apply(null,this)
}
// Arrayに要素の存在チェックするためのメソッドを追加する。
Array.prototype.contains = function( value ){
	for(var i = 0; i < this.length; i++){
		if(this[i] === value){
			return true;
		}
	}
	return false;
};
// 全ての文字列 org を dest に置き換える   2013/01/31 ADD
function replaceAll( expression, org, dest ){
    return expression.split( org ).join( dest );
}
// 数値の符号判定 2013/09/03 ADD
function sign( inNum ){
	var rtn = 1;
	if( inNum != Math.abs( inNum )){
		rtn = -1;
	}
    return rtn;
}
// ２つの日付の差分を計算する
function compareDate( inDate1, inDate2) {
	if( inDate1 == null || inDate2 == null ){return 0;}
	if( inDate1.length != 8 || inDate2.length != 8 ){return 0;}
	var year1  = inDate1.substring( 0 ,4 );
	var month1 = inDate1.substring( 4 ,6 );
	var day1   = inDate1.substring( 6 ,8 );
	var year2  = inDate2.substring( 0 ,4 );
	var month2 = inDate2.substring( 4 ,6 );
	var day2   = inDate2.substring( 6 ,8 );
    var dt1 = new Date(year1, month1 - 1, day1);
    var dt2 = new Date(year2, month2 - 1, day2);
    var diff = dt1 - dt2;
    var diffDay = diff / 86400000;		// 1日の86400000ミリ秒数
    return diffDay;
}
//x.x時間⇒時分HH24MM
function toTime( inHour ) {
	var hour  = ( "00" + Math.floor( inHour ).toString()).slice(-2); 
	var minus = ("00" + Math.floor(( inHour - Math.floor( inHour )) * 60 ).toString()).slice(-2);
	return  hour + minus;
}
//時分HH24MM⇒x.x時間へ変換
function toHour( inTime ) {
	var hour  = inTime.substring( 0 ,2);
	var minus = inTime.substring( 2 ,4);
	var rtnHour = parseInt( hour ,10 ) + parseInt( minus ,10 ) / 60;
	return Math.round( rtnHour*100 )/100;
}
// 月を足します rtnDayは日(0だと月末) 2012/10/01
function addMonth( inDate, addMnt, rtnDay ) {
	var year  = inDate.substring( 0 ,4 );
	var month = inDate.substring( 4 ,6 );
	var day   = inDate.substring( 6 );
	var adjustMonth = 1;
	if (rtnDay == 0 ){
		var adjustMonth = 0;
	}

	var addY = Math.floor((Number(month) + Number(addMnt) - Number(adjustMonth)) / 12);
	month = (Number(month) + Number(addMnt) - Number(adjustMonth)) % 12;
	year = Number(year) + Number(addY);

	var rtnDate = new Date( year, month, rtnDay );
	return rtnDate.getFullYear() + ( "00" + ( rtnDate.getMonth() + 1 ) ).slice( -2 ) + ("00" + rtnDate.getDate()).slice( -2 );
}
//n日後、n日前の日付を求める
function addDays( inDate ,inDays ,inFGCal ) {
	var year  = inDate.substring( 0 ,4 );
	var month = inDate.substring( 4 ,6 );
	var day   = inDate.substring( 6 ,8 );
	var rtnDate = new Date( year, month - 1, day );
	var baseSec = rtnDate.getTime();

	//カレンダー参照
	var startDate = inDate.substring( 0 ,8 );
	var diffDayS   = compareDate( startDate ,gantStartDate );
	var workDays = 0;
	var countDays = 0;
	// カレンダー参照かつ休日を飛ばす場合かつ時間単位のガントの場合
//	if( inFGCal == "1" && skipHoliday == "true" && parseInt( gantZoom ,10 ) >= 20){
	if( inFGCal == "1" && skipHoliday == "true" 
		&& !(parseInt( gantZoom ,10 ) <= 13) && !(parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) && !isNaN(gantZoom)){ // 5.6.2.0 (2013/03/01)
		// 前方へ移動
		if( inDays > 0 ){
			//カレンダーの日数
//			for( var i = diffDayS ; workDays <= inDays && i <=calenderDays ;i++ ){
			for( var i = diffDayS ; workDays <= inDays; i++ ){
				if( arrCalender[i] == null || arrCalender[i] == "0" ){ workDays++;}
				countDays++;
			}
			countDays--;
		}
		// 後方へ移動
		else if( inDays < 0 ){
			//カレンダーの日数
//			for( var i = diffDayS ; workDays >= inDays && i >=0 ;i-- ){
			for( var i = diffDayS ; workDays >= inDays ;i-- ){
				if( arrCalender[i] == null || arrCalender[i] == "0" ){ workDays--;}
				countDays--;
			}
			countDays++;
		}
	}
	//カレンダー参照しないOR休日出力されている
	else{
		countDays = inDays;
	}
	var addSec  = countDays * 86400000;	// 1日の86400000ミリ秒数
	var targetSec = baseSec + addSec;
	rtnDate.setTime( targetSec );
	return rtnDate.getFullYear() + ( "00" + ( rtnDate.getMonth() + 1 ) ).slice( -2 ) + ("00" + rtnDate.getDate()).slice( -2 );
}

//n時間後、n時間前の時間を求める
function addTimes( inFullTime ,inHours ) {
	//元の日付
	var oDate = inFullTime.substring( 0 ,8 );
	//元の時分
	var oTime = inFullTime.substring( 8 ,12);
	if( !oTime ){ oTime = gantStartTime; }
	//開始・終了時刻の範囲外対応 2013/09/03 ADD
	if( oTime > gantEndTime ){ 
		oTime = gantEndTime;
	}else if( oTime < gantStartTime ){
		oTime = gantStartTime;
	}
	//時間の加算
	var resultTime = toHour( oTime ) + inHours;
	var diffDays = 0;
	var overTime = 0;

	//後方の日付超える場合
	if( resultTime >= toHour( gantEndTime )){
		diffDays = Math.floor( ( resultTime - toHour( gantEndTime )) / gantDaySpan ) + 1;
		overTime = ( resultTime - toHour( gantEndTime )) % gantDaySpan  + toHour( gantStartTime );
	}
	//前方の日付超える場合
	else if( resultTime < toHour( gantStartTime )){
		diffDays = Math.floor(( resultTime - toHour( gantStartTime )) / gantDaySpan );
		if(( resultTime - toHour( gantStartTime )) % gantDaySpan == 0 ){
			overTime = toHour( gantStartTime );
		}else{
			overTime = toHour( gantEndTime ) + ( resultTime - toHour( gantStartTime )) % gantDaySpan;
		}
	}
	//日付超えない場合
	else{
		diffDays = 0;
		overTime = resultTime;
	}
	//
	var fgCal = '1'; //カレンダー参照
	var rtnDate = addDays( oDate ,diffDays ,fgCal );

	return rtnDate + toTime( overTime );
}
// 日付からカラム位置を計算する(先頭0）2012/10/01
function dateColumnNo( inDate ) {
	if( inDate == null ){return 0;}
	var diffDay = compareDate( inDate, gantStartDate );
	// 2013/03/15 時間ガントはそのままだと休日判定に問題があるので暫定的にunitSpan=1にする
	if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){
	    return Math.floor(diffDay/unitSpan[gantZoom]);
	}
	else{ return diffDay;}
}
// 対象日が休日かどうか 休日ならtrue 2012/10/01
function isHoliday( inDate ){
	var targetClm = dateColumnNo( inDate );
	var rtn = "true";
	if( arrCalender[targetClm] == '1'){ rtn = "true"; }
	else{ rtn = "false"; }
	return rtn;
}
// 対象日の間に休日が何個あるか 2012/10/01
function holidayCount( inDate1, inDate2 ){
	var st = dateColumnNo(inDate1);
	var en = dateColumnNo(addDays( inDate2 ,-1 ,0 ));
	var rtn = 0;
	for( i = st; i <= en; i++ ){
		if( arrCalender[i] == '1'){ rtn++; }
	}
	return rtn;
}

// 日付(YYYYMMDD)の入力欄への反映
// 5.9.4.4 hilightBar.xxxをgetAttributeに変更
function performDateChange( nMyMAction, movedSpan ,fgCal ){
	startDateInputObj = document.getElementById( hilightBar.getAttribute("startDateInput") );
	switch ( hilightBar.getAttribute("type") ){
		case "0" :
			startDateInputObj.value = addDays( hilightBar.getAttribute("startDT") ,movedSpan ,fgCal ) 
			break;
		case "1" :
			endDateInputObj   = document.getElementById( hilightBar.getAttribute("endDateInput") );
			switch ( nMyMAction ){
				case cnMLeft :
					startDateInputObj.value = addDays( hilightBar.getAttribute("startDT") ,movedSpan ,fgCal ) ;
					break;
				case cnMRight:
					endDateInputObj.value = addDays( hilightBar.getAttribute("endDT") ,movedSpan ,fgCal ) ;
					break;
				case cnMMiddle:
					startDateInputObj.value = addDays( hilightBar.getAttribute("startDT") ,movedSpan ,fgCal ) ;
					endDateInputObj.value = addDays( hilightBar.getAttribute("endDT") ,movedSpan ,fgCal ) 
					break;
				default:
			}
			break;
		default:
	}
}
// 時間（HH24MM）日付(YYYYMMDD)の入力欄への反映
// 5.9.4.4 hilightBar.xxxをgetAttributeに変更
function performTimeChange( nMyMAction, movedSpan ){
	startTimeInputObj = document.getElementById( hilightBar.getAttribute("startTimeInput") );
	switch ( hilightBar.type ){
		case "0" :
			var newFullTime = addTimes( hilightBar.getAttribute("startDT") ,movedSpan );
			var newDate     = newFullTime.substring( 0 ,8 );
			var newTime     = newFullTime.substring( 8 ,12 );
			var diffDays    = compareDate( newDate ,hilightBar.getAttribute("startDT").substring( 0 ,8) );
			//開始日付の反映
			performDateChange( cnMLeft ,diffDays ,'0');
			//開始時刻の反映
			if( startTimeInputObj ){
				startTimeInputObj.value = newTime;
			}
			break;
		case "1" :
			endTimeInputObj   = document.getElementById( hilightBar.getAttribute("endTimeInput") );
			switch ( nMAction ){
				case cnMLeft :
					//開始日付、時刻の計算
					var newFullTime = addTimes( hilightBar.getAttribute("startDT") ,movedSpan );
					var newDate     = newFullTime.substring( 0 ,8 );
					var newTime     = newFullTime.substring( 8 ,12 );
					var diffDays    = compareDate( newDate ,hilightBar.getAttribute("startDT").substring( 0 ,8) );
					//開始日付の反映
					performDateChange( cnMLeft ,diffDays ,'0');
					//開始時刻の反映
					startTimeInputObj.value = newTime;
					break;
				case cnMRight:
					//終了日付、時刻の計算
					newFullTime     = addTimes( hilightBar.getAttribute("endDT") ,movedSpan );
					var newDate     = newFullTime.substring( 0 ,8 );
					var newTime     = newFullTime.substring( 8 ,12 );
					var diffDays    = compareDate( newDate ,hilightBar.getAttribute("endDT").substring( 0 ,8) );
					//終了日付の反映
					performDateChange( cnMRight ,diffDays ,'0' );
					//終了時刻の反映
					endTimeInputObj.value   = newTime;
					break;
				case cnMMiddle:
					//開始日付、時刻の計算
					var newFullTime = addTimes( hilightBar.getAttribute("startDT") ,movedSpan );
					var newDate     = newFullTime.substring( 0 ,8 );
					var newTime     = newFullTime.substring( 8 ,12 );
					var diffDays    = compareDate( newDate ,hilightBar.getAttribute("startDT").substring( 0 ,8) );
					//開始日付の反映
					performDateChange( cnMLeft ,diffDays ,'0' );
					//開始時刻の反映
					startTimeInputObj.value = newTime;
					//終了日付、時刻の計算
					newFullTime     = addTimes( hilightBar.getAttribute("endDT") ,movedSpan );
					var newDate     = newFullTime.substring( 0 ,8 );
					var newTime     = newFullTime.substring( 8 ,12 );
					var diffDays    = compareDate( newDate ,hilightBar.getAttribute("endDT").substring( 0 ,8) );
					//終了日付の反映
					performDateChange( cnMRight ,diffDays ,'0' );
					//終了時刻の反映
					endTimeInputObj.value   = newTime;
					break;
				default:
			}
			break;
		default:
	}
}
// 行のチェックをonにする
function setRowChecked(oMyForm, sName, bValue)
{
	var nIndexUp;
	var aInputs=document.getElementsByName(sName);
	if(null != aInputs)
	{
		for(nIndexUp = 0; nIndexUp < aInputs.length;  nIndexUp++ )
		{
			var oSetObj  = aInputs[nIndexUp];
			if(("INPUT" == oSetObj.tagName )
			&& (( "checkbox" == oSetObj.type ) || ( "radio" == oSetObj.type )))
			{
				oSetObj.checked = ((undefined == bValue) ? true : bValue);
			}
		}
	}
}

// ガントバーのドラグドロップ処理
// 5.9.4.4 hilightBar.xxxをgetAttributeに変更
function fnMouseDown( event ){
	hilightBar = event.srcElement;

	if( null != hilightBar )
	{
		var nMyWidth = hilightBar.offsetWidth;

		nLeftRightLimit = Math.min( Math.max( nMyWidth / cnBunkatu, 2 ) ,20 );

		switch ( hilightBar.getAttribute('type') ){
			// マイルストーン
			case "0" :
				nMAction = cnMMiddle;
				hilightBar.style.cursor = "move";
				break;
			// バー
			case "1" :
				if( event.offsetX <= nLeftRightLimit ){
					nMAction = cnMLeft;
					hilightBar.style.cursor = "E-resize";
				}
				else if( event.offsetX > ( nMyWidth - nLeftRightLimit )){
					nMAction = cnMRight;
					hilightBar.style.cursor = "E-resize";
				}
				else
				{
					nMAction = cnMMiddle;
					hilightBar.style.cursor = "move";
				}
				break;
			default:
		}

		if( hilightBar.setCapture ) { hilightBar.setCapture(); }				// 2017/09/01

		startX   = event.screenX;
		oriLeft  = hilightBar.parentNode.offsetLeft;
		oriWidth = hilightBar.width;
		oriPixelLeft = hilightBar.parentNode.style.pixelLeft;
	}

}
// ガントバーのドラグドロップ処理
// og.rev 5.9.15.1 (2017/12/09) 
function fnMouseUp( event ){
	if( null != hilightBar )
	{
		hilightBar.style.cursor = "auto";

		if( hilightBar.releaseCapture ) { hilightBar.releaseCapture(); }		// 2017/09/01

		var _refid = hilightBar.getAttribute('refid'); // 2017/12/09 元のiganttbarの値も連動して変更させる
		var _refObj = null;
		if(_refid){
			_refObj = document.getElementById(_refid);
		}
		

		if( startDateInputObj ){
			hilightBar.setAttribute('startDT', startDateInputObj.value);
			if(_refObj){
				_refObj.setAttribute('start', startDateInputObj.value);
			}
		}
		if( endDateInputObj ){
			hilightBar.setAttribute('endDT', endDateInputObj.value);
			if(_refObj){
				_refObj.setAttribute('end', endDateInputObj.value);
			}
		}
		// 時間の加味
		if( startTimeInputObj ){
			hilightBar.setAttribute('startDT',  hilightBar.startDT.substring( 0 ,8 ) + startTimeInputObj.value);
			if(_refObj){
				_refObj.setAttribute('start', hilightBar.startDT.substring( 0 ,8 ) + startTimeInputObj.value);
			}
		}
		if( endTimeInputObj ){
			hilightBar.setAttribute('endDT', hilightBar.endDT.substring( 0 ,8 )   + endTimeInputObj.value);
			if(_refObj){
				_refObj.setAttribute('end', hilightBar.endDT.substring( 0 ,8 )   + endTimeInputObj.value );
			}
		}
		
		// 動的なstackの初期化、計算、描画の想定(コメントアウト)
		// var hilightDiv = hilightBar.parentNode;
		// if( hilightDiv.getAttribute('stackrow') ){
		// flashStack(targetstack); // 対象stackの初期化の新しい
		// costStack( hilightDiv.getAttribute('stackrow'), hilightDiv.getAttribute('ganttrow'), _refObj.getAttribute('start'), _refObj.getAttribute('end'), _refObj.getAttribute('cost') ); // 2016/02/17 MOD
		// viewStack( document.getElementById('stack_'+ hilightDiv.getAttribute('stackrow') ) );
		// }
		
		//
		nMAction      = cnMNone;
		// 行の選択をonにする
		if(hilightBar.getAttribute('chboxid') && ( "" != hilightBar.getAttribute('chboxid'))) {
			setRowChecked(null, hilightBar.getAttribute('chboxid'));
		}
	}
//	DEBUG用
//	alert( debugMsg );
//	debugMsg='';
}
// ガントバーのドラグドロップ処理
// 5.9.4.4 hilightBar.xxxをgetAttributeに変更
function fnMouseMove( event ){
	event.preventDefault();		// 5.10.1.2 (2018/08/03) 6.8.1.4Edge対応
	var moveDist = event.screenX - startX;
	//範囲外の場合処理しない
	if(( nMAction == cnMLeft || nMAction == cnMMiddle ) && oriPixelLeft + moveDist < 0){  // 2013/09/03 MOD
		moveDist = -oriPixelLeft;
//		return false;
	}
	//
//	if(( 1 == event.button ) && ( hilightBar != null )){
	if(( 1 == window.event.buttons || 1 == event.buttons || 1 == event.button ) && ( hilightBar != null )){ // 5.9.4.4
		if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
			moveDist = sign( moveDist ) * Math.ceil( Math.abs( moveDist ) / hilightBar.getAttribute('pixelPreSpan') ) * hilightBar.getAttribute('pixelPreSpan');
		}
		// 2013/09/03 ADD
		if( parseInt( gantZoom ,10 ) >= 20 && parseInt( gantZoom ,10 ) <= 31 ){
			switch ( hilightBar.getAttribute('moveStep') ){
				case "1":	//日単位
					moveDist = sign( moveDist ) * Math.ceil( Math.abs( moveDist ) / ( hilightBar.getAttribute('pixelPreSpan') * gantDaySpan )) * hilightBar.getAttribute('pixelPreSpan') * gantDaySpan;
					break;
				case "2":	//時間単位
					moveDist = sign( moveDist ) * Math.ceil( Math.abs( moveDist ) / hilightBar.getAttribute('pixelPreSpan') ) * hilightBar.getAttribute('pixelPreSpan');
					break;
				default:
			}
		}
		switch ( hilightBar.getAttribute('type') ){
			// マイルストーン
			case "0" :
				switch( nMAction ){
					// 中間
					case cnMMiddle:
						hilightBar.parentNode.style.left = (parseInt( oriLeft ,10 ) + moveDist)+"px";
						break;
					default:
				}
				break;
			// バー
			case "1" :
				switch ( nMAction ){
				case cnMLeft :
					hilightBar.parentNode.style.left  = (parseInt( oriLeft ,10 ) + moveDist)+"px" ;
//					hilightBar.width = (oriWidth - moveDist) +"px";
					hilightBar.style.width = (oriWidth - moveDist) +"px";		// 2013/09/02 MOD
					break;
				case cnMRight:
//					hilightBar.width = (oriWidth + moveDist) +"px";
					hilightBar.style.width = (oriWidth + moveDist) +"px";		// 2013/09/02 MOD
					break;
				case cnMMiddle:
					hilightBar.parentNode.style.left = (parseInt( oriLeft ,10 ) + moveDist) +"px";
					break;
				default:
			}
			break;
			default:
		}
		try{
//			if( parseInt( gantZoom ,10 ) <= 10 ){
			if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
				// Change the date
				performDateChange( nMAction, moveDist / hilightBar.getAttribute('pixelPreSpan') ,'1');
			}
			else{
				if( hilightBar.getAttribute('startTimeInput') != null && hilightBar.getAttribute('startDT').length !=12 ){
					alert( "時間をYYYYMMDDHH24MMのフォーマットで設定してください。("+hilightBar.getAttribute('startDT') + ")" );
					return;
				}
				// Change the time & date
				performTimeChange( nMAction, moveDist / hilightBar.getAttribute('pixelPreSpan') );
			}
		}catch(e){} //例外発生時パス
	}
}
// スタックDivに対してガントバーの積上げを行う = 存在しているガントのみ積上げされる 2012/10/01
function costStack( stackRow, gantRow, startDate, endDate, cost ){
	// 対象tbodyが存在するかどうか
	var stackTbody = document.getElementById('stack_'+stackRow);
	if( stackTbody == null || gantRow == null || startDate == null || endDate == null || cost == null){ return ; }
	//開始カラムの取得
	var startNo = dateColumnNo(startDate);
	var endNo = dateColumnNo(endDate);
	var stackDiv;
	var stackList;
	var stackCost =0;
	
	// endDate = addDays( endDate ,1 );
	
	var stackMother = compareDate( endDate, startDate);
	if( stackMother == 0 ){ return false; }
	// 休みの考慮を入れる場合はここで分母から除く。
	if( stackHoliday == "false"){
		stackMother = stackMother - holidayCount(startDate, endDate);
	}
	
	for( i = startNo; i <= endNo; i++ ){
		try{
			if( stackHoliday == "false" && arrCalender[i] == '1'){ continue; }
			stackDiv = document.getElementById('stack_' + stackRow + '_' + i);
			if( ! stackDiv ){ continue; }
			stackStart = stackDiv.startdate;
			stackEnd = stackDiv.enddate;
			
			if ( endDate < stackStart || stackEnd < startDate ){ continue; } // 外の分
			
			if( stackDiv.getAttribute('costList') == null ){
				var costList = new Array(100);
			}
			else{
				var costList = stackDiv.getAttribute('costList');
				// 5.9.4.1 (2016/01/09)
				if( !document.all ){
					if(costList == null){ continue; } 
					costList = costList.split(',');
				}
			}
			
			var std = (startDate > stackStart) ? startDate : stackStart;
			var end = (endDate < stackEnd) ? endDate : stackEnd;
			
			//積上げコスト計算
			stackCost = cost * compareDate(end,std) / stackMother;
			// margeRows対応 2013/09/11
			if( costList[gantRow] != null ){
//				costList[gantRow] += stackCost;
				costList[gantRow] = Number(costList[gantRow]) +Number(stackCost);	// 5.10.1.2 (2018/07/20) Number変換
			}else{
//				costList[gantRow] = stackCost;
				costList[gantRow] = Number(stackCost);	
			}
			stackDiv.setAttribute('costList',costList);

		}catch(e){}//例外発生時パス
	}
}

// stackのコスト情報の表示 2012/10/01
function viewStack ( tbody ){
	var stackDivs = $(tbody).find('.stackDiv');
	var defaultHeight = stackDivs[0].defHeight;
	var stdCost = tbody.getAttribute('capacity') ? tbody.getAttribute('capacity') : SYS_STDCOST;
	// 2012/09/26 ADD
	var stackCost = new Array( stackDivs.length );
	var maxRowCost= 0;
	for( i = 0; i < stackDivs.length; i++ ){
		stackCost[i] = 0;
		var costList = stackDivs[i].getAttribute('costList');
		if( !document.all ){
			if(costList == null){ continue; } 
			costList = costList.split(',');
		}
				
		for (j in costList){
			if(costList[j] != null && isFinite(costList[j])){
				stackCost[i] += Number(costList[j]);
			}
		}
		// 行の最大コスト値
		if( stackCost[i] > maxRowCost ){ maxRowCost = Number(stackCost[i]); }
	}
	// 2012/09/26 MOD
	for( i = 0; i < stackDivs.length; i++ ){
		// 2012/10/12 例外処理追加
		try{
			//alert(stackDivs[i].nodeName);
			var stdUpper = stdCost * SYS_WARN_BOUND // 2012/09/26 ADD
// 2012/09/26 DEL 行の最大値を計算するため、上に持っていく
//		var stackCost = 0;
//		for (j in costList){
//			if(costList[j] != null && isFinite(costList[j])){
//				stackCost += costList[j];
//			}
//		}
			var newHeight = 0;
			// 条件追加 2012/10/09
			if( maxRowCost > 0 ){
				if( viewMode == '1' ){
					newHeight = Math.round( stackCost[i] / maxRowCost * defaultHeight ); // 行の最大値を基準に高さ計算する 2012/09/26 ADD
				}
				else{
					newHeight = Math.round( stackCost[i] / stdCost * defaultHeight * 2 / 3); // 2/3を１の高さにする
				}
			}
			if( newHeight > defaultHeight){
				newHeight = defaultHeight;
			}
			
			stackDivs[i].style.height = newHeight +"px";
			stackDivs[i].style.top = (defaultHeight - newHeight) +"px";
			
			var stackDiv = $(stackDivs[i]);
			stackDiv.removeClass(SYS_STD_COST);
			stackDiv.removeClass(SYS_UPPER_COST);
			stackDiv.removeClass(SYS_LOWER_COST);

			// 2012/09/26 MOD
			if( stackCost[i] > stdUpper ){
				stackDiv.addClass(SYS_ERROR_COST);
			}
			else if( stackCost[i] <= stdCost ){
				stackDiv.addClass(SYS_STD_COST);
			}
			else{
				stackDiv.addClass(SYS_WARN_COST);
			}

			// Costの数字をspanで表示する
			if( stackCost[i] != 0 ){
				stackDiv.html('<span style="width;'+stackDiv.css('width')+'; text-align: center; bottom:0px; font-size: x-small; position: absolute;">'+stackCost[i].toFixed(2)+'</span>');
			}
		}catch(e){} //例外発生時パス
	}
}

// 積上げ部分の作成 2012/10/01
function makeStackBar( gantTd ,strCalender ,lineHeight ){

	if( gantTd == null  ){ return false; }
	//
	iDiv = document.createElement("div");
	gantTd.appendChild( iDiv );
	iDiv.style.position = "relative";
	iDiv.style.height   = (lineHeight - 2) +"px";
	iDiv.style.width    = "100%";
	iDiv.style.fontSize	="0";

	// 要素のトップ位置
	var iGantPos_Top = ( lineHeight - SYS_BAR_HEIGHT ) / 2 -10;
	
	//横方向にunitPixel分ずつdivを配置していく。
	var iStackDiv;
	for( i = 0; i < strCalender.length; i++ ){
		iStackDiv  = document.createElement("div");
		iStackDiv.className = "stackDiv";
		iStackDiv.style.position = "absolute";
		iStackDiv.style.width = unitPixel[gantZoom] +"px";
		iStackDiv.style.height = lineHeight +"px";
		iStackDiv.defHeight = lineHeight;
		iStackDiv.style.left = (i*unitPixel[gantZoom]) +"px";
		iStackDiv.style.top = "0px";
//		iStackDiv.id = 'stack_' + gantTd.stackrow + '_' + i;
		iStackDiv.id = 'stack_' + gantTd.getAttribute('stackrow') + '_' + i;	// 2016/02/17 MOD
		
//		if( gantZoom != 'MONTH'){
		if( gantZoom != 'MONTH' && gantZoom != '42'){
			iStackDiv.startdate = addDays( gantStartDate , unitSpan[gantZoom] * i );
			iStackDiv.enddate = addDays( gantStartDate , unitSpan[gantZoom] * ( i + 1 ) );
		}
		else{
			iStackDiv.startdate = addMonth( gantStartDate, i, 1 );
			iStackDiv.enddate   = addMonth( gantStartDate, i+1, 1 );
		}
		
		iDiv.appendChild( iStackDiv );
	}
}


// 5.9.4.4 hilightBar.xxxをgetAttributeに変更,eventの対応
// 5.9.11.0 (2016/08/05) 表示領域を超えたバーの表示抑制
function showGantBar( gantTd ,listGantBar ,lineHeight ){
	if( gantTd == null || listGantBar == null ){ return false; }
//	// ガントセル幅
//	var unitPixel = {"0" : 48 ,"1" : 24 ,"2" : 12 ,"3" : 56 ,"4" : 56 ,"5" : 90 ,"6" : 60 ,"7" : 90 ,"8" : 90 ,"9" : 60 ,"10": 24 ,"20": 48 ,"21": 24 ,"22": 48 ,"23": 24 ,"24": 48 ,"25": 24 ,"26": 48 ,"27": 24 ,"28": 48 ,"29": 24 ,"30": 48 ,"31": 24 };
//	// ガントセル毎の日数・時間数
//	var unitSpan  = {"0" : 1  ,"1" : 1  ,"2" : 1  ,"3" : 7  ,"4" : 14 ,"5" : 30 ,"6" : 30 ,"7" : 90 ,"8" :180 ,"9" :180 ,"10":  7 ,"20":  1 ,"21":  1 ,"22":  2 ,"23":  2 ,"24":  4 ,"25":  4 ,"26":  6 ,"27":  6 ,"28":  8 ,"29":  8 ,"30": 12 ,"31": 12 };
	// 一日または一時間当たりのピクセル数
	var pixelPreSpan = unitPixel[gantZoom] / unitSpan[gantZoom] ;
	// 5.6.3.1 (2013/04/05) colorNoList で、length は使わなくなりました。
//	colorNoList.length = -1; // 連想配列にはlengthが存在しないため-1をセット
//	for( cnlKey in colorNoList ){ colorNoList.length++;}

	//
	iDiv 	      		= document.createElement("div");
	gantTd.appendChild( iDiv );
	iDiv.style.position = "relative";
	iDiv.style.height   = (lineHeight - 2) +"px";
	iDiv.style.width    = "100%";
	iDiv.style.left     = SYS_OFFSET_LEFT +"px";
	iDiv.style.fontSize	="0";
	// バー間の上下位置をずらす
	var hPosShift = 10;
	// ガント要素のトップ位置
	var iGantPos_Top = ( lineHeight - SYS_BAR_HEIGHT ) / 2 -10;

	// ガント要素毎に描画する。
	while ( listGantBar.hasnext() ){
		var gantBarObj = listGantBar.next();
		//
		var iGantDiv   = document.createElement("div");
		iGantDiv.style.position = "absolute";
		iGantDiv.style.top =iGantPos_Top +"px";
//		iGantDiv.stackrow = gantTd.stackrow;
//		iGantDiv.ganttrow = gantBarObj.ganttrow;
		iGantDiv.setAttribute('stackrow',gantTd.getAttribute('stackrow')); // 5.9.4.4
		iGantDiv.setAttribute('ganttrow',gantBarObj.getAttribute('ganttrow')); // 5.9.4.4
		// 2013/01/31 MOD
	
		if( gantBarObj.getAttribute('start') != null && gantBarObj.getAttribute('start').length > 0 ){
			// 開始時間（YYYYMMDDHH24MM）
			var startStr  = replaceAll( replaceAll( replaceAll( gantBarObj.getAttribute('start') ,'/','' ) ,' ' ,'') ,':' ,'').substring( 0 ,12 );
		}
		else{
			var startStr = "0";
		}
		if( gantBarObj.getAttribute('end') != null && gantBarObj.getAttribute('end').length > 0 ){
			// 終了時間（YYYYMMDDHH24MM）
			var endStr    = replaceAll( replaceAll( replaceAll( gantBarObj.getAttribute('end') ,'/','' ) ,' ' ,'') ,':' ,'').substring( 0 ,12 );
		}
		else{
			var endStr = "0";
		}
		// 開始日(YYYYMMDD)と開始時間(HHMM)
		
		var startDate = startStr.substring( 0 ,8 );
		var startTime = startStr.substring( 8 ,12 );
		// 終了日(YYYYMMDD)と終了時間(HHMM)
		var endDate   = endStr.substring( 0 ,8 );
		var endTime   = endStr.substring( 8 ,12 );
		
		// 開始・終了時間が設定されていない場合。2013/03/15 
		if( startTime == null || startTime.length == 0 ){ startTime = '0000'; }
		if( endTime == null || endTime.length == 0 ){ endTime = '2400'; }
		
		if(startStr == "0"){ // 5.6.2.2 (2013/03/15) endのみ設定した場合はstartにEndを入れる
				startDate = endDate;
				startTime = endTime;
		}

		// 終了日が無い場合はこの月の最終日にする
		if( ! gantBarObj.getAttribute('end') ){
			gantBarObj.setAttribute('end',addMonth( startDate , 0, 0 )+ "" + startTime);
		}

		// 6.0.2.4 (2014/10/17) 開始-終了が逆転する場合、(24時間を超える)場合は、それぞれ再設定する。
		if( gantEndTime > '2400' ) {
			var gntEndTm = parseInt( gantEndTime ,10 ) - 2400 ;
			var stTm = parseInt( startTime ,10 );
			var edTm = parseInt( endTime ,10 );

			if( stTm < gntEndTm ){
				startTime = (stTm + 2400) + "" ;		// 加算してから文字列化
				startDate = addDays( startDate ,-1 );	// 今日の 08:00は、前日の 32:00 みたいな表現
			}
			if( edTm < gntEndTm ){
				endTime = (edTm + 2400) + "" ;			// 加算してから文字列化
				endDate = addDays( endDate ,-1 );		// 今日の 08:00は、前日の 32:00 みたいな表現
			}
		}

		try{
			var iCenter = null;
			switch( gantBarObj.getAttribute('type') ){
				// ガントマーカー
				case "0":
					// 2012/09/27 ADD 開始日が未設定、設定エラーの場合は描画しない
					if( startDate.length == 8 ){
						// ガントバーはカレンダー範囲外は描画不能
						//if( startDate > gantEndDate ){
						if( startDate >= gantEndDate ){ // 5.9.12.0 (2016/09/02) イコール追加
							startDate = gantEndDate;
							break; // 5.6.1.2 (2013/02/22)
						}
						// 開始日はガント開始日より小さい場合、ガント開始日から描画する
						if( startDate < gantStartDate ){
							startDate = gantStartDate;
							startTime = gantStartTime;			// 5.10.1.2(2018/07/20) 6.0.2.4対応,時間も前に詰める
							break; // 5.6.1.2 (2013/02/22)
						}
						// 開始時間
						if( startTime < gantStartTime ){
							startTime = gantStartTime;
						}
						if( startTime > gantEndTime ){
							startTime = gantEndTime;
						}
						var diffDayS   = compareDate( startDate ,gantStartDate );
						//描画開始、終了位置の計算
						var startPos;
//						if( parseInt( gantZoom ,10 ) <= 10 || isNaN(gantZoom)){
						if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
							startPos   = diffDayS * pixelPreSpan;
							if(startStr == "0"){ // 2013/03/15 開始日が入っていない場合は＋１日する
								startPos += pixelPreSpan;
							}
						}
						else{
							// 休日を飛ばす場合	
							var countHoliday = 0;
							if( skipHoliday == "true" ){
								// 
								countHoliday = 0;
								for( var i = 0 ; i < diffDayS ;i++ ){
									if( arrCalender[i] > 0 ){ countHoliday++; }
								}
								diffDayS -= countHoliday;
							}
							// 描画開始位置 = 日付差分(開始日) + 時間差分(開始時間)
							startPos   = diffDayS * Math.ceil( hoursPreDay / unitSpan[gantZoom] ) * unitPixel[gantZoom] +
										 (( parseInt( startTime.substring( 0 ,2 ) ,10 ) - parseInt( gantStartTime.substring( 0 ,2 ) ,10 ) + 
										 ( parseInt( startTime.substring( 2    ) ,10 ) - parseInt( gantStartTime.substring( 2    ) ,10 )) / 60 ) * pixelPreSpan
										 * (( skipHoliday=="true" && isHoliday(startDate)=='true' ) ? 0:1));
										 
						}
						
						
						iGantDiv.style.left= startPos +"px";

						iCenter    = document.createElement("img");
						iCenter.src    = gantBarObj.getAttribute('src');

						// ツールチップの表示 2012/09/27 MOD 日単位の場合、時間表示しない
//						if( parseInt( gantZoom ,10 ) >= 20 ){
//							iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) 
//											+ " " + startTime.substring( 0 ,2 ) + ":" + startTime.substring( 2 ,4 )
//										  ;
//						}
//						else {
//							iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) ;
//						}
						if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
							iCenter.title = iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) ;
						}
						else{
							iCenter.title = iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) 
											+ " " + startTime.substring( 0 ,2 ) + ":" + startTime.substring( 2 ,4 )
										  ;
						}
						// ガントバーの移動対応
						if((document.getElementById( gantBarObj.getAttribute('startDateInput') ) && gantBarObj.getAttribute('startDateInput') != null ) ||
						   (document.getElementById( gantBarObj.getAttribute('startTimeInput') ) && gantBarObj.getAttribute('startTimeInput') != null )){
							// 値連動用のパラメータ
							iCenter.setAttribute('type', gantBarObj.getAttribute('type'));
							iCenter.setAttribute('startDT', startStr);		// 2013/01/31 MOD
							if( document.getElementById( gantBarObj.getAttribute('startDateInput'))){		// 2013/09/03 ADD
								iCenter.setAttribute('startDateInput', gantBarObj.getAttribute('startDateInput'));
							}
							if( document.getElementById( gantBarObj.getAttribute('startTimeInput'))){		// 2013/09/03 ADD
								iCenter.setAttribute('startTimeInput', gantBarObj.getAttribute('startTimeInput'));
							}
							iCenter.setAttribute('pixelPreSpan', pixelPreSpan);
							iCenter.setAttribute('chboxid ', gantBarObj.getAttribute('chboxid'));
							iCenter.setAttribute('refid', gantBarObj.getAttribute('id'));
//							iCenter.attachEvent( "onmousedown"  , function(){ fnMouseDown( event );} );
//							iCenter.attachEvent( "onmousemove"  , function(){ fnMouseMove( event );} );
//							iCenter.attachEvent( "onmouseup"    , function(){ fnMouseUp(   event );} );
							$(iCenter).mousedown(function(event){ fnMouseDown( event );})
									.mousemove(function(event){ fnMouseMove( event );})
									.mouseup(function(event){ fnMouseUp(   event );});
						}

						// 
						iGantDiv.appendChild( iCenter );
						//
						iGantDiv.style.top = (iGantPos_Top * 1 + SYS_MARKER_OFFSET_H) +"px";
					}
					break;
				// ガントバー
				case "1":
					// バーを縦方向でずらして描画
					if( verticalShift == "true" ){
						hPosShift = hPosShift == -SYS_BAR_HEIGHT/2 ? SYS_BAR_HEIGHT/2 : -SYS_BAR_HEIGHT/2;
					}
					else{
						hPosShift = 0;
					}
					iGantPos_Top = ( lineHeight - SYS_BAR_HEIGHT ) / 4 + hPosShift;
					iGantDiv.style.top = iGantPos_Top +"px";

					var endDate2   = endDate;
// 2013/03/15 場所移動
//					// 開始時間が設定されていない場合は0000に見なす。2013/01/30 ADD
//					if( startTime == null || startTime.length == 0 ){ startTime = '0000'; }
//					// 終了時間が設定されていない場合は2400に見なす。2013/01/30 ADD
//					if( endTime == null || endTime.length == 0 ){ endTime = '2400'; }

					// 開始日と終了日逆転は描画不能
					if( startDate > endDate ){
						break;
					}
					// ガントバーはカレンダー範囲外は描画不能
					if( startDate > gantEndDate || endDate < gantStartDate ){
						break;
					}
//					// 終了時間は開始時間より小さい場合、終了日は次の日で計算する。（夜勤の場合）
//					if( endTime < startTime ){
//						endDate = addDays( endDate ,1 );
//					}
					endDate = addDays( endDate ,1 );
					// 開始日はガント開始日より小さい場合、ガント開始日から描画する
					if( startDate < gantStartDate ){
						startDate = gantStartDate;
						startTime = gantStartTime;			// 6.0.2.4 (2014/10/17) 時間も前に詰める。
					}
					// 終了日はガント終了日より多きい場合、ガント終了日まで描画する
					if( endDate > gantEndDate ){
						// 2013/04/19 時間と日では最終日の計算方法を変える
						if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){
						    endDate = addDays(gantEndDate,1,null);
						}
						else{
							endDate = gantEndDate;
						}
						endTime = gantEndTime;				// 5.10.1.2(2018/07/20) 6.0.2.4対応分,時間も後ろにずらす
					}
					// 開始時間
					if( startTime < gantStartTime ){
						startTime = gantStartTime;
					}
					if( startTime > gantEndTime ){
						startTime = gantEndTime;
					}
					// 終了時間
					if( endTime > gantEndTime ){
						endTime = gantEndTime;
					}
					if( endTime < gantStartTime ){
						endTime = gantStartTime;
					}
					var diffDayS   = compareDate( startDate ,gantStartDate );
					var diffDayE   = compareDate( endDate   ,gantStartDate );
					//描画開始、終了位置の計算
					var startPos;
			        var endPos  ;
//					if( parseInt( gantZoom ,10 ) <= 10 || isNaN(gantZoom) ){
					if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
						startPos   = diffDayS * pixelPreSpan;
						endPos     = diffDayE * pixelPreSpan;
					}
					else{
						// 休日を飛ばす場合	
						var countHoliday = 0;
						if( skipHoliday == "true" ){
							// 
							countHoliday = 0;
							for( var i = 0 ; i < diffDayS ;i++ ){
								if( arrCalender[i] > 0 ){ countHoliday++; }
							}
							diffDayS -= countHoliday;
							// 
							countHoliday = 0;
							for( var i = 0 ; i < diffDayE ;i++ ){
								if( arrCalender[i] > 0 ){ countHoliday++; }
							}
							diffDayE -= countHoliday;
						}
						// 描画開始位置 = 日付差分(開始日) + 時間差分(開始時間)
						startPos   = diffDayS * Math.ceil( hoursPreDay / unitSpan[gantZoom] ) * unitPixel[gantZoom] +
									 ( parseInt( startTime.substring( 0 ,2 ) ,10 ) - parseInt( gantStartTime.substring( 0 ,2 ) ,10 ) + 
									 ( parseInt( startTime.substring( 2    ) ,10 ) - parseInt( gantStartTime.substring( 2    ) ,10 )) / 60 ) * pixelPreSpan;
						// 描画終了位置 = 日付差分(終了日) + 時間差分(終了時間)
						endPos     = ( diffDayE - 1 ) * Math.ceil( hoursPreDay / unitSpan[gantZoom] ) * unitPixel[gantZoom] + 
									 ( parseInt( endTime.substring( 0 ,2 ) ,10 ) - parseInt( gantStartTime.substring( 0 ,2 ) ,10 ) + 
									 ( parseInt( endTime.substring( 2    ) ,10 ) - parseInt( gantStartTime.substring( 2    ) ,10 )) / 60 ) * pixelPreSpan;
					}
					if( startPos > endPos ){ break; } // 5.9.11.0 (2016/08/05)
					
					iGantDiv.style.left= startPos +"px";
					
					// 表示しない場合は以下処理しない
					if(viewGantt == "true"){

						iCenter    = document.createElement("img");
						//ガント図の元画像
						// 5.6.3.1 (2013/04/05) アクセス方法の変更。color で決め打ちして、なければ画像が表示されないだけ。
						var clrNm = gantBarObj.getAttribute('color');
						if( clrNm ) {
							if( clrNm.indexOf("src:") == 0 ) {
								iCenter.src = clrNm.substring(4)+".png";
							}
							else{
								iCenter.src = "../image/W_" + clrNm.toLowerCase() + ".png";		// 強制的に小文字に変換してしまう。
							}
						}
						else {
							// 2013/02/22 色番号の対応表。色コード(clrNm)がない場合のみ、色コードを求める。
							var clrNo = gantBarObj.getAttribute('colorNo');
	//						if( gantBarObj.getAttribute('colorNo') ) {
							if( clrNo ) {
								// 5.6.3.1 (2013/04/05) アクセス方法の変更。colorNo で連想配列から取得し、マッチしなければ、数字化して取得を試みる。
								var chrCode = colorNoList[ clrNo ];
								if( !chrCode ) {
									clrNo = parseInt(clrNo,10) % colorNoList.length ;			// なければ、連想配列の長さで割り算し、余を求める。
									chrCode = colorNoList[ clrNo ];
								}
								if( chrCode ) {
									iCenter.src    = "../image/W_" + chrCode + ".png";
								}
								else{
									iCenter.src    = "../image/W_blue.png";
								}

								// 数字0を0に割り当てるために+2する
	//							var chrCode = (gantBarObj.getAttribute('colorNo').charCodeAt( gantBarObj.getAttribute('colorNo').length-1 )+2)%colorNoList.length;
	//							iCenter.src    = "../image/W_" + colorNoList[chrCode] + ".png";
							}
						}

						// 5.6.3.1 (2013/04/05) アクセス方法の変更。switch ～ case は取りやめ
//						switch( gantBarObj.getAttribute('color') ){
//							case "blue":
//								iCenter.src    = "../image/W_blue.png";
//								break;
//							case "lightblue":
//								iCenter.src    = "../image/W_lightblue.png";
//								break;
//							case "green":
//								iCenter.src    = "../image/W_green.png";
//								break;
//							case "lightgreen":
//								iCenter.src    = "../image/W_lightgreen.png";
//								break;
//							case "red":
//								iCenter.src    = "../image/W_red.png";
//								break;
//							case "pink":
//								iCenter.src    = "../image/W_pink.png";
//								break;
//							case "orange":
//								iCenter.src    = "../image/W_orange.png";
//								break;
//							case "brown":
//								iCenter.src    = "../image/W_brown.png";
//								break;
//							case "purple":
//								iCenter.src    = "../image/W_purple.png";
//								break;
//							case "black":
//								iCenter.src    = "../image/W_black.png";
//								break;
//							case "black2":
//								iCenter.src    = "../image/W_black2.png";
//								break;
//							case "yellow":
//								iCenter.src    = "../image/W_yellow.png";
//								break;
//							case "violet":
//								iCenter.src    = "../image/W_violet.png";
//								break;
//							case "navy":
//								iCenter.src    = "../image/W_navy.png";
//								break;
//							case "glay":
//								iCenter.src    = "../image/W_glay.png";
//								break;
//							case "darkgreen":
//								iCenter.src    = "../image/W_darkgreen.png";
//								break;
//							case "teal":
//								iCenter.src    = "../image/W_teal.png";
//								break;
//							case "indigo":
//								iCenter.src    = "../image/W_indigo.png";
//								break;
//							case "chocolate":
//								iCenter.src    = "../image/W_chocolate.png";
//								break;
//							case "slategray":
//								iCenter.src    = "../image/W_slategray.png";
//								break;
//							case "darkslategray":
//								iCenter.src    = "../image/W_darkslategray.png";
//								break;
//							default:
//								if( gantBarObj.getAttribute('color') && gantBarObj.getAttribute('color').indexOf("src:") == 0 ){ // 2013/03/01
//									iCenter.src    = gantBarObj.getAttribute('color').substring(4)+".png";
//								}
//								else{
//									iCenter.src    = "../image/W_blue.png";
//								}
//								break;
//						}

						// 5.6.4.2 (2013/05/17) ガントバーの間の区切りスペース paddingLeft , paddingRigth属性
						// 左右のpaddingが、ガントバーの幅より小さい場合のみ有効にする。（幅をマイナスにしない）
						var barWidth = (endPos - startPos);						// 計算のため
						if( paddingLeft > 0 && paddingLeft < barWidth ) {
							iCenter.style.paddingLeft  = paddingLeft + "px";	// [左]
							barWidth = barWidth - paddingLeft ;
						}
						if( paddingRigth > 0 && paddingRigth < barWidth ) {
							iCenter.style.paddingRigth = paddingRigth + "px";	// [右]
							barWidth = barWidth - paddingRigth ;
						}
						iCenter.style.width  = barWidth +"px";
						iCenter.style.height = SYS_BAR_HEIGHT +"px";
						
						// ツールチップの表示 2012/09/27 MOD 日単位の場合、時間表示しない
//						if( parseInt( gantZoom ,10 ) >= 20 ){
//							iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) 
//											+ " " + startTime.substring( 0 ,2 ) + ":" + startTime.substring( 2 ,4 ) + "-" + 
//										  endDate2.substring( 0 ,4 )   + "/" + endDate2.substring( 4 ,6 )   + "/" + endDate2.substring( 6 ,8 )
//											+ " " + endTime.substring( 0 ,2 ) + ":" + endTime.substring( 2 ,4 )
//										  ;
//						}
//						else {
//							iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) + "-" + 
//										   endDate2.substring( 0 ,4 ) + "/" +  endDate2.substring( 4 ,6 ) + "/" +  endDate2.substring( 6 ,8 );
//						}
						if( parseInt( gantZoom ,10 ) <= 13 || (parseInt( gantZoom ,10 ) >= 40 && parseInt( gantZoom ,10 ) <= 49) || isNaN(gantZoom) ){ // 2013/03/01
							iCenter.title = iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) + "-" + 
							endDate2.substring( 0 ,4 ) + "/" +  endDate2.substring( 4 ,6 ) + "/" +  endDate2.substring( 6 ,8 );
						}
						else{
							iCenter.title = iCenter.alt = startDate.substring( 0 ,4 ) + "/" + startDate.substring( 4 ,6 ) + "/" + startDate.substring( 6 ,8 ) 
											+ " " + startTime.substring( 0 ,2 ) + ":" + startTime.substring( 2 ,4 ) + "-" + 
										  endDate2.substring( 0 ,4 )   + "/" + endDate2.substring( 4 ,6 )   + "/" + endDate2.substring( 6 ,8 )
											+ " " + endTime.substring( 0 ,2 ) + ":" + endTime.substring( 2 ,4 )
										  ;
						}
						// 
						iGantDiv.appendChild( iCenter );
						// ガントバーの移動対応
						if(( document.getElementById( gantBarObj.getAttribute('startDateInput') ) && gantBarObj.getAttribute('startDateInput') != null  &&
							 document.getElementById( gantBarObj.getAttribute('endDateInput')   ) && gantBarObj.getAttribute('endDateInput')   != null ) ||
						   ( document.getElementById( gantBarObj.getAttribute('startTimeInput') ) && gantBarObj.getAttribute('startTimeInput') != null  &&
							 document.getElementById( gantBarObj.getAttribute('endTimeInput')   ) && gantBarObj.getAttribute('endTimeInput')   != null ) ){
							// 値連動用のパラメータ
							iCenter.setAttribute('type', gantBarObj.getAttribute('type'));
							iCenter.setAttribute('startDT', startStr);		// 2013/01/31 MOD
							iCenter.setAttribute('endDT', endStr);			// 2013/01/31 MOD
							if( document.getElementById( gantBarObj.getAttribute('startDateInput'))){	// 2013/09/03 ADD
								iCenter.setAttribute('startDateInput', gantBarObj.getAttribute('startDateInput'));
							}
							if( document.getElementById( gantBarObj.getAttribute('startTimeInput'))){	// 2013/09/03 ADD
								iCenter.setAttribute('startTimeInput', gantBarObj.getAttribute('startTimeInput'));
							}
							if( document.getElementById( gantBarObj.getAttribute('endDateInput'))){		// 2013/09/03 ADD
								iCenter.setAttribute('endDateInput', gantBarObj.getAttribute('endDateInput'));
							}
							if( document.getElementById( gantBarObj.getAttribute('endTimeInput'))){		// 2013/09/03 ADD
								iCenter.setAttribute('endTimeInput', gantBarObj.getAttribute('endTimeInput'));
							}
							iCenter.setAttribute('moveStep', gantBarObj.getAttribute('moveStep'));				// 2013/09/03 ADD
							iCenter.setAttribute('pixelPreSpan', pixelPreSpan);
							iCenter.setAttribute('chboxid', gantBarObj.getAttribute('chboxid'));
							iCenter.setAttribute('refid', gantBarObj.getAttribute('id'));
			//				iCenter.attachEvent( "onmousedown"  , function(){ fnMouseDown( event );} );
			//				iCenter.attachEvent( "onmousemove"  , function(){ fnMouseMove( event );} );
			//				iCenter.attachEvent( "onmouseup"    , function(){ fnMouseUp(   event );} );
							
							$(iCenter).mousedown(function(event){ fnMouseDown( event );})
									.mousemove(function(event){ fnMouseMove( event );})
									.mouseup(function(event){ fnMouseUp(   event );});
						}

						// 改行
						var iBr    = document.createElement("br");
						iGantDiv.appendChild( iBr );
					}
				
			}
		}catch(e){}//例外発生時にパス
		// 注釈
		iGantDiv.style.fontSize	="12px";
		// リンク追加 2012/09/27 ADD
		if( iCenter ){
			if( gantBarObj.getAttribute('href') ){
				if( gantBarObj.getAttribute('barLink') ){ // 5.6.2.0 (2013/03/01) BarLink対応
					iGantDiv.appendChild( document.createTextNode( gantBarObj.getAttribute('text') ));
					_target = gantBarObj.getAttribute('target') ? gantBarObj.getAttribute('target') : SYS_LINK_TARGET;
					$(iGantDiv).html('<a href="'+gantBarObj.getAttribute('href')+'" target="'+_target+'">'+$(iGantDiv).html()+'</a>');
				}
				else{
					var linkObj = document.createElement("a");
					linkObj.href   = gantBarObj.getAttribute('href');
					linkObj.target = gantBarObj.getAttribute('target') ? gantBarObj.getAttribute('target') : SYS_LINK_TARGET;
					var linkMsg = document.createTextNode( gantBarObj.getAttribute('text') );
					linkObj.appendChild(linkMsg);
					iGantDiv.appendChild( linkObj );
				}
			}
			else {
				// 注釈をガント要素の下方に表示させる
//				iGantDiv.appendChild( document.createTextNode( gantBarObj.getAttribute('text') ));
				$(iGantDiv).append( gantBarObj.getAttribute('text') );
			}
		}

		// 
		iDiv.appendChild( iGantDiv );
		// 工数を積み上げる
		if( gantBarObj.getAttribute('type') == '1' && gantBarObj.getAttribute('cost') ){
//			costStack( iGantDiv.stackrow, iGantDiv.ganttrow, startDate, endDate, gantBarObj.getAttribute('cost') );
			costStack( iGantDiv.getAttribute('stackrow'), iGantDiv.getAttribute('ganttrow'), startDate, endDate, gantBarObj.getAttribute('cost') ); // 2016/02/17 MOD
		}
	}
}

// メイン処理（画面から呼び出す）
// 5.9.4.4 (2016/01/22) getAttribute
function adjustGantt(){
	// viewTableのオブジェクトの取得
	var viewTableObj = document.getElementById( "viewTable" );
	// viewTableが存在しなければ終了
	if( viewTableObj == null ){ return false; } 

	// ganttHeaderオブジェクトの取得
	var gantHeaderObj = document.getElementById( "ganttHeaderData" );
	// gantHeaderObjが存在しなければ終了
	if( gantHeaderObj == null ){ return false; }
	
	// iGantオブジェクト取得
	var iGantObjs = document.getElementsByTagName( "iGantt" );
	// iGantObjsが存在しなければ終了
	if( iGantObjs == null || iGantObjs.length == 0 ){ return false; }

	// 休憩時間の網掛けを非表示（高さ調整前）
	$(".breaktime").hide();
	// カレンダーの文字列
	var strCalender   = gantHeaderObj.getAttribute('calDB');
	// カレンダーが読み込まれていない場合は処理しない
	if( strCalender == null || strCalender.length == 0 ){ return false; }
	// 描画可能なズーム
	var gantZooms = ["0","1","2","3","4","5","6","7","8","9","10","13","20","21","22","23","24","25","26","27","28","29","30","31"
						,"DAY","WEEK","MONTH","40","41","42"];
	// 属性値の取得
	// ガントズーム
	gantZoom      = gantHeaderObj.getAttribute('zoom');
	// ガントの描画開始日付(時間)
	gantStartDate = gantHeaderObj.getAttribute('startDate');
	gantEndDate   = gantHeaderObj.getAttribute('endDate');
	// 一日の描画時間数(0700-2000)
	daySpan		  = gantHeaderObj.getAttribute('daySpan');
	// 休日を飛ばすか
	skipHoliday   = gantHeaderObj.getAttribute('skipHoliday');
	// stack関係 2012/10/01
// 2012/09/26 DEL
//	stdUpper 	  = iGantObjs[0].stdUpper ? iGantObjs[0].stdUpper : stdUpper;
//	stdCost 	  = iGantObjs[0].stdCost ? iGantObjs[0].stdCost : stdCost;
//	stdLower 	  = iGantObjs[0].stdLower ? iGantObjs[0].stdLower : stdLower;
	viewGantt	  = iGantObjs[0].getAttribute('viewGantt') ? iGantObjs[0].getAttribute('viewGantt') : viewGantt;	// 2012/09/26 ADD
	viewMode	  = iGantObjs[0].getAttribute('viewMode') ? iGantObjs[0].getAttribute('viewMode') : viewMode;		// 2012/09/26 ADD
	stackHoliday  = iGantObjs[0].getAttribute('stackHoliday') ? iGantObjs[0].getAttribute('stackHoliday') : stackHoliday;
	// 複数行のマージ
	margeRows 	  = iGantObjs[0].getAttribute('margeRows');
	// 縦方向でずらすか
	verticalShift = ( iGantObjs[0].getAttribute('verticalShift') != null  ) ? iGantObjs[0].getAttribute('verticalShift') : verticalShift;
	// 5.6.4.2 (2013/05/17) ガントバーの間の区切りスペース 
	paddingLeft  = ( iGantObjs[0].getAttribute('paddingLeft')  != null  ) ? iGantObjs[0].getAttribute('paddingLeft')  : paddingLeft;
	paddingRigth = ( iGantObjs[0].getAttribute('paddingRigth') != null  ) ? iGantObjs[0].getAttribute('paddingRigth') : paddingRigth;
	// 固定列
	fixedCols 	  = iGantObjs[0].getAttribute('fixedCols');
	// 縞々背景色の使用 2012/09/26 add
	useBgColor 	  = ( iGantObjs[0].getAttribute('useBgColor') != null ) ? iGantObjs[0].getAttribute('useBgColor') : useBgColor;

	// viewTableに番号列が表示されるか
	viewNumberType	  = iGantObjs[0].getAttribute('viewNumberType');

	// 必須属性のチェック、設定していなければ終了
	if( gantZoom == null || gantStartDate == null || gantEndDate == null || daySpan == null ){ return false; }
	// gantZoomのチェック
	if( !gantZooms.contains( gantZoom ) ){ return false; }

	// 始業時間(0700-xxxx)
	gantStartTime	  = daySpan.split("-")[0];
	// 終業時間(xxxx-2000)
	gantEndTime	  	  = daySpan.split("-")[1];
	// 時間数 2013/09/03 ADD
	gantDaySpan = toHour( gantEndTime ) - toHour( gantStartTime );

	// 終業時間が大きい場合、始業時間と終業時間ともに同日の時間で計算する
	if( gantEndTime > gantStartTime ){
		hoursPreDay = parseInt( gantEndTime.substring( 0 ,2 ) ,10 ) - parseInt( gantStartTime.substring( 0 ,2 ) ,10 ) + 
					( parseInt( gantEndTime.substring( 2    ) ,10 ) - parseInt( gantStartTime.substring( 2    ) ,10 )) / 60;
	}
	// 始業時間が大きい場合、始業時間は終業時間の次の日の時間として計算する(夜勤)
	else{
		hoursPreDay = 24 + 
					  parseInt( gantStartTime.substring( 0 ,2 ) ,10 ) - parseInt( gantEndTime.substring( 0 ,2 ) ,10 ) + 
					( parseInt( gantStartTime.substring( 2    ) ,10 ) - parseInt( gantEndTime.substring( 2    ) ,10 )) / 60;
	}
	// カレンダー解析（パス）
	if( skipHoliday == "true" || stackHoliday == "false" ){
		calenderDays = strCalender.length;
		arrCalender = new Array( calenderDays );
		for( i = 0 ;i < calenderDays ;i++ ){
			arrCalender[i] = strCalender.substr( i ,1 );
		}
	}

	// viewTableよりデータノードを作成する。
	// theadオブジェクトの取得（一つしかない）
//	var headerObjs   = viewTableObj.all.tags("THEAD");
	var headerObjs   = $(viewTableObj).find("THEAD");
	// theadにタイトルの物理的な行数
//	var tHeadLines   = headerObjs[0].all.tags("TR").length;
	var tHeadLines   = $(headerObjs[0]).find("TR").length;
	//
	var bodyHeight = 0;
	
	// tbodyオブジェクトの取得（業務データの一行分）
//	var tBodyObjs   = viewTableObj.all.tags("TBODY");
//	var tBodyObjs   = $(viewTableObj).find("TBODY");		※ガントが横に並ばない
	// 5.9.0.0 (2015/09/04) all.tagsがHTML5で使えない対応
	var tBodyObjs   = viewTableObj.all ? viewTableObj.all.tags("TBODY") : $(viewTableObj).find("TBODY");


	var countTBody = tBodyObjs.length;
	// tbodyに業務データの物理的な行数
//	var countLines = tBodyObjs[0].all.tags("TR").length;
	var countLines = $(tBodyObjs[0]).find("TR").length;
	// tbody毎のセル数
//	var countCells = tBodyObjs[0].all.tags("TD").length;
	var countCells = $(tBodyObjs[0]).find("TD").length;
	// 業務データ行(tBody)の高さ
	var lineHeight = tBodyObjs[0].offsetHeight;
	// ２段組でガントバーを上下シフトして表示させる
	if( verticalShift == "true" ){
		if( lineHeight < SYS_MIN_HEIGHT_SHIFT    ){ lineHeight = SYS_MIN_HEIGHT_SHIFT; }
	}
	else{
		if( lineHeight < SYS_MIN_HEIGHT_NO_SHIFT ){ lineHeight = SYS_MIN_HEIGHT_NO_SHIFT; }
	}

	// ガント要素のリスト
	// 描画の行単位でキャッシュする、行マージする場合はマージ後の行となる
	var listGantBar = new List();
	// 前後行のデータ
	var cellValPre  = new Array( countCells );
	var cellValNext = new Array( countCells );
	// 前後行の比較結果（0:同様(マージできる) 1:同様じゃない(マージできない)）
	var fgDiff      = 0;
	var gantTd		= null;
	// tBodyの数分ループ（業務データの一行(tBody)ずつ描画させる）
	for( var i = 0; i < countTBody; i++ ){
		// ガント要素のリスト
		// 業務データの行単位(tBody)のガント要素をキャッシュする。行マージする場合はマージ前の行となる
		var swapGantBar = new List();
		// 業務データの行(tBody)毎のセル
//		var lineTdObjs = tBodyObjs[i].all.tags("TD");
		var lineTdObjs = $(tBodyObjs[i]).find("TD");
		// ガント要素の親TD
		var swapGantTd = null;
		// stack判定 2012/10/01
		var stackTbody = tBodyObjs[i].getAttribute('stackline');
		var stackrow = tBodyObjs[i].getAttribute('stackrow');
		for( var j = 0; j < countCells; j++ ){
			// 前方の行番号など、比較対象外
			if( j < SYS_NUMBER_CELLS && viewNumberType !='delete' ){
				cellValNext[j] = "";
			}
			// ガント要素、比較対象外
			else if( lineTdObjs[j].firstChild && lineTdObjs[j].firstChild.tagName == "IGANTTBAR" ){
				var childObjs = lineTdObjs[j].childNodes;
				// 
				for( var k = 0; k < childObjs.length; k++ ){
					childObjs[k].setAttribute('ganttrow',i); 
					swapGantBar.add( childObjs[k] );
					// 2012/09/26 ADD
//					if( childObjs[k].capacity && parseInt( childObjs[k].capacity ,10 ) > 0 ){
// 2012/11/12 MOD
//					if( childObjs[k].capacity && parseFloat( childObjs[k].capacity ) > 0 ){
					// 5.9.4.1 (2016/01/09) Attribute
					if( childObjs[k].getAttribute('capacity') && parseFloat( childObjs[k].getAttribute('capacity') ) > 0 ){
//						document.getElementById('stack_' + tBodyObjs[i].getAttribute('stackrow') ).capacity = childObjs[k].capacity;
						document.getElementById('stack_' + tBodyObjs[i].getAttribute('stackrow') ).setAttribute('capacity', childObjs[k].getAttribute('capacity'));
					//	$("#stack_"+).attr("capacity" ,childObjs[k].capacity);
					}
				}
				cellValNext[j] = "";
				swapGantTd = lineTdObjs[j];
				swapGantTd.setAttribute('stackrow',stackrow); 
			}
			else{
				cellValNext[j] = lineTdObjs[j].innerHTML;
			}
		}
		// 前行の初期値
		if( i == 0 ){
			cellValPre = cellValNext.clone();
			if( stackTbody == "true" ){ // 2012/10/01
				makeStackBar( swapGantTd ,strCalender ,lineHeight );
				listGantBar.head = null;
				listGantBar.size = 0;
			}
			else{
				gantTd     = swapGantTd;
				// ガント要素を描画リストに追加
				while ( swapGantBar.hasnext() ){
					listGantBar.add( swapGantBar.next() );
				}
			}
		}
		else{
			// 行のマージを行う場合
			if( margeRows == "true" ){
				// 前後行データの比較
				fgDiff = 0;
				for( var j = 0; j < countCells; j++ ){
					if( cellValPre[j] != cellValNext[j] ){
						cellValPre = cellValNext.clone();
						// 不一致あり
						fgDiff = 1;
						break;
					}
				}
			}
			// 行のマージを行わない場合
			else{
				fgDiff = 1;
			}
			// 
			if( fgDiff == 1 ){
				// ガント要素の出力
				bodyHeight += lineHeight + 2;
				if( stackTbody == "true" ){ // 2010/10/01
					//gantTd = swapGantTd;
					makeStackBar( swapGantTd ,strCalender ,lineHeight );
					listGantBar.head = null;
					listGantBar.size = 0;
				}
				else{
					// ガント要素の描画
					showGantBar( gantTd ,listGantBar ,lineHeight );
					// リスト削除
					listGantBar.head = null;
					listGantBar.size = 0;

					// 
					gantTd = swapGantTd;
					// ガント要素を描画リストに追加
					while ( swapGantBar.hasnext() ){
						listGantBar.add( swapGantBar.next() );
					}
				}
			}
			// マージされるため、行要素の削除
			else{
				// ガント要素を描画リストに追加
				while ( swapGantBar.hasnext() ){
					listGantBar.add( swapGantBar.next() );
				}
				tBodyObjs[i].parentNode.removeChild( tBodyObjs[i] );  //DOM上からremove
				if( typeof tBodyObjs.splice == 'function' ){ // 古いブラウザは存在しないのでチェック
					tBodyObjs.splice( i, 1 ) ; // 配列を削除 5.9.30.1 (2018/03/09)
				}
				
				// 5.9.4.1 (2016/01/09) これはIE10以前の対策となる。removeで配列の数は変化しない
				if( tBodyObjs.length < countTBody ){
					i--;
					countTBody--;
				}

			}
		}
	}
	// 2012/09/25 ADD 背景色のリセット
	var countTBody = tBodyObjs.length;
	if( useBgColor == 'true' ){
		for( i = 0 ;i < countTBody ;i++ ){
			tBodyObjs[i].className = "row_" + i%2;
		}
	}
	// 2012/09/25 ADD 行番号のリセット
	if( viewNumberType != 'delete' ){
		for( i = 0 ;i < countTBody ;i++ ){
			//tBodyObjs[i].all.tags("TD")[2].innerText = i + 1;
			$($(tBodyObjs[i]).find("TD")[2]).text(i + 1);
		}
	}

	// 最後一行の出力
	bodyHeight += lineHeight + 2;
	// ガント要素の描画
	showGantBar( gantTd ,listGantBar ,lineHeight );
	//ガント描画不要の場合 2010/10/01
	if ( viewGantt  == 'false' ){
		$("tbody[stackline=false]").hide();
	}
	else if( viewGantt == 'expand' ){
		$("tbody[stackline=false]").hide();
		// 展開表示のための処理を行う場合はここに入れるが、ガントの表示の考慮必要
	}
	
	// リスト削除
	listGantBar.head = null;
	listGantBar.size = 0;
	//
//	var headSpanObjs = headerObjs[0].all.tags("SPAN");
	var headSpanObjs = $(headerObjs[0]).find("SPAN");
	var countBreakTimeSpan = 0;
	for( var i = 0; i < headSpanObjs.length; i++ ){
		if( headSpanObjs[i].className == "breaktime" ) countBreakTimeSpan++;
	}

	// breakTimeの調整
//	var spanObjs = viewTableObj.all.tags("SPAN");
	var spanObjs = $(viewTableObj).find("SPAN");
	var indexBreakTimeSpan = 0;
	if( spanObjs != null ){
		for( var i = 0 ;i < spanObjs.length ;i++  ){
			if( spanObjs[i].className == "breaktime" ){
				indexBreakTimeSpan++;
				if( indexBreakTimeSpan <= countBreakTimeSpan ){
					spanObjs[i].style.height = bodyHeight +"px";
				}
				else{
					spanObjs[i].style.height = 0 +"px";
				}
			}
		}
	}
	
	// 積上げ部分の描画を行う 2010/10/01
//	tBodyObjs   = viewTableObj.all.tags("TBODY");
	tBodyObjs   = $(viewTableObj).find("TBODY");
	countTBody = tBodyObjs.length;
	for( i = 0; i < countTBody; i++ ){
		if( tBodyObjs[i].getAttribute('stackline') == 'true' ){
			viewStack(tBodyObjs[i]);
		}
	}
	

	//固定列数が設定される場合、テーブルの２分割処理を行う。
	if( fixedCols > 0 ){
		// 二分割の処理を行う。
		makeSuperTable( "viewTable" ,fixedCols );
	
	}
	// 休憩時間の網掛けを表示させる（高さ調整済）
	$(".breaktime").show();
	//2012/10/31 ADD 
	$("#viewTable").css("visibility" ,"visible");

};

//状態をコピー 2012/10/12 ADD
function copyState(from, to){
	if(typeof(from.checked) != 'undefined'){
		if(from.type == 'radio'){
			to.checked = from.checked;  //ラジオボタン(IE専用)
		}
		else {
			to.checked = from.checked;  //チェックボックス(IE用)
		}
	}
	else if(typeof(from.selected) != 'undefined'){
		to.selected = from.selected;    //プルダウン(IE、Firefox用)
	}
	else if(from.type == 'textarea'){
		to.value = from.value;      //テキストエリア(Firefox用)
	}
    var node, copy;
	try{
		for(var i=0; i<from.childNodes.length; i++){
			node = from.childNodes.item(i);
			copy = to.childNodes.item(i);
			copyState( node, copy );
		}
	}catch(e){}
}

/* version: 0.0.1 
 * author : Sen Li
 * date   : 2012/05/10
 * 機能   : テーブルの左右2分割処理
 */

// セルの位置情報( 行 ,列 )
function cellNode( inRow ,inCol ){ 
	this.row   = inRow;
	this.col   = inCol;
}
// テーブル２分割処理
function makeSuperTable( viewTableId, fixedCols ) {
	// 初期化
	var scrollBarWidth  = 16;
	var scrollBarHeight = 20;
	// 左側の固定列数（初期値：0）
	fixedCols = parseInt( fixedCols || "0" ,10 );
	// 各列の幅
	colWidths = [];
	
	// 各枠のDIV要素作成
	ourterDiv = document.createElement( "DIV" );

	// ヘッダーの固定部
	fixedHeaderDiv  = ourterDiv.cloneNode( false );

	// ヘッダーのスクロール部分のベース枠
	scrollHeaderBaseDiv = ourterDiv.cloneNode( false );

	// ヘッダーのスクロール部分の枠
	scrollHeaderDiv = ourterDiv.cloneNode( false );

	// ボディの左固定部分のベース枠
	fixBodyBaseDiv = ourterDiv.cloneNode( false );

	// ボディの左固定部分の枠
	fixBodyDiv = ourterDiv.cloneNode( false );

	// ボディの右スクロール部分の枠
	scrollBodyDiv = ourterDiv.cloneNode( false );

	// ボディの右スクロール部分のテーブル
	scrollBodyTable = document.getElementById( viewTableId );
	// viewTableが存在しなければ終了
	if( scrollBodyTable == null ){ return false; }
	// 元のテーブルの縦横幅の取得
	var tableWidth  = scrollBodyTable.offsetWidth;
	var tableHeight = scrollBodyTable.offsetHeight;

	var sHeaderHeight;
	var tHead = scrollBodyTable.tHead;

	if( tHead ){
		sHeaderHeight = tHead.offsetHeight;
	}
	else{
		sHeaderHeight = scrollBodyTable.tBody[0].offsetHeight;
	}

	if( scrollBodyTable == null || fixedCols <= 0 ){ return true; }

	// スタイルの設定
	// -----------------------------------------------------
	// 外枠のスタイル
	ourterDiv.id		= "ourterDiv";
	// ヘッダーの固定部
	fixedHeaderDiv.id 	= "fixedHeaderDiv";
	// ヘッダーのスクロール部分のベース枠
	scrollHeaderBaseDiv.id = "scrollHeaderBaseDiv";
	// ヘッダーのスクロール部分の枠
	scrollHeaderDiv.id	   = "scrollHeaderDiv";
	// ボディの左固定部分のベース枠
	fixBodyBaseDiv.id	   = "fixBodyBaseDiv";
	// ボディの左固定部分の枠
	fixBodyDiv.id		   = "fixBodyDiv";
	// ボディの右スクロール部分の枠
	scrollBodyDiv.id	   = "scrollBodyDiv";

	// -----------------------------------------------------
	// カラムスタイル
	colGroupStyle    = document.createElement("COLGROUP");

	// IE幅
	var windowWidth  = getClientWidth();
	// テーブルのトップ位置
	var tableTop= scrollBodyTable.offsetTop;

	// IEの高さ
	var windowHeight = getClientHeight();
	// 
	// テーブルの実レイアウトによりCOLGROUPを作成するため、既存のCOLGROUPを削除する。
	for( i = scrollBodyTable.getElementsByTagName( "COLGROUP" ).length-1 ;i >= 0 ;i-- ){
		scrollBodyTable.removeChild( scrollBodyTable.getElementsByTagName( "COLGROUP" )[i] );
	}
	// 
	sParent 		 = scrollBodyTable.parentNode;
	sParentHeight 	 = sParent.offsetHeight;
	sParentWidth 	 = sParent.offsetWidth;
	
	// スワップ変数
	var alpha, beta, i, j;
	// ヘッダーのスクロール部分のテーブル作成
	scrollHeaderTable = scrollBodyTable.cloneNode( false );
	// ヘッダーのスクロール部分のテーブルのスタイル設定
	scrollHeaderTable.id ="scrollHeaderTable" ;

	// 元のテーブルにtHeadが存在すれば、そのtHeadをコピーする。
	if( tHead ) {
		alpha = tHead;
		// ヘッダーのスクロール部分のテーブル作成
		scrollHeaderTable.appendChild( alpha.cloneNode( true ));
	} else {
		alpha = scrollBodyTable.tBodies[0];
		scrollHeaderTable.appendChild( alpha.cloneNode( true ));
	}

	// ヘッダーのスクロール部分のテーブルをDIVに入れる。
	scrollHeaderDiv.appendChild( scrollHeaderTable );
	
	fixedHeaderTable = scrollHeaderTable.cloneNode( true );
	// スタイル設定
	fixedHeaderTable.id = "fixedHeaderTable";

	fixedHeaderDiv.appendChild(fixedHeaderTable);
	// ボディの左固定部のテーブル

	fixedBodyTable = scrollBodyTable.cloneNode( true );
	// cloneNode後、selectの選択状態が初期に戻ってしまう不具合対応 2012/10/12 ADD
	copyState(scrollBodyTable, fixedBodyTable);  
	// ボディの左固定部のテーブルのスタイル
	fixedBodyTable.id = "fixedBodyTable";
	fixBodyDiv.appendChild( fixedBodyTable );
	
	// カラムスタイルの設定
	var tBodyRows       = scrollBodyTable.tBodies[0].rows;
	var tBodyRowsLength = tBodyRows.length;
	var maxCellRow      = 0;
	var countRowCells   = 0;

	// クリティカルパスの作成準備
	var cellColSpan     = 0;
	var cellRowSpan     = 0;
	var countSingleCol  = 0;
	var colLength       = tBodyRows[0].cells.length;
	for( i = 0; i < colLength; i++ ){
		countSingleCol += tBodyRows[0].cells[i].colSpan;
	}
	// 
	var cellGridMap     = new Array( tBodyRowsLength );

	// 行毎のセル番号のキャッシュ
	var colIndex = new Array( tBodyRowsLength );
//	for( rowId = 0; rowId < tBodyRowsLength + 1; rowId++ ){
	for( rowId = 0; rowId < tBodyRowsLength + 1; rowId++ ){ // 5.6.2.1 (2013/03/08) +i部分を考慮して+1する
		cellGridMap[rowId] = new Array( countSingleCol );
		colIndex[rowId]=0;
	}
	// cellGridMapの作成
	for( rowId = 0; rowId < tBodyRowsLength; rowId++ ){
		colLength    = tBodyRows[rowId].cells.length;
		for( colId = 0; colId < colLength; colId++ ){
			cellRowSpan = tBodyRows[rowId].cells[colId].rowSpan;
			cellColSpan = tBodyRows[rowId].cells[colId].colSpan;
			for( j = 0 ;j < cellColSpan ;j++ ){
				for( i = 0 ;i < cellRowSpan ;i++ ){
					// 空セルを探す。
					for( m =0 ;m < countSingleCol; m++ ){
//						if( cellGridMap[rowId + i][ colIndex[rowId]] != null ) { colIndex[rowId]++;}
						if( cellGridMap[rowId + i] != null && cellGridMap[rowId + i][ colIndex[rowId]] != null ) { colIndex[rowId]++;}
					}
					// セル情報のキャッシュ
					cellGridMap[rowId + i][ colIndex[rowId] ] = new cellNode( rowId ,colId );		
				}
				colIndex[rowId]++;
			}

		}
	}
	// クリティカルパスの作成
	var keyCells = [];
	var index    = 0;
	for( j = 0 ;j < countSingleCol ;j++ ){
		for( i = 0 ;i < tBodyRowsLength ;i++ ){
			cellColSpan = tBodyRows[ cellGridMap[i][j].row ].cells[ cellGridMap[i][j].col ].colSpan;
			if( cellColSpan == 1 ){
				keyCells[index] = new cellNode( cellGridMap[i][j].row ,cellGridMap[i][j].col );
				index++
				break;
			}
		}
	}

	// クリティカルパスにより、各列の幅を取得する。
	for( i=0; i < countSingleCol; i++){
		colWidths[i] = tBodyRows[ keyCells[i].row ].cells[ keyCells[i].col ].offsetWidth;
	}

	// colspanによる幅の誤差計算
	var fixedDivDiff = 0;
	var totalDiff    = 0;
	index = 0;
	// 誤差計算
	for( i = 0 ; i < countSingleCol ;i++ ){
		if( colWidths[i] > SYS_CELLPADDING ){
			colWidths[i] -= SYS_CELLPADDING;
		}
		else{
			if( i < fixedCols ){
				fixedDivDiff += SYS_CELLPADDING * 1;
			}
			totalDiff        += SYS_CELLPADDING * 1;
		}
		i += tHead.rows[0].cells[index++].colSpan - 1 ;
	}

	// 誤差を加味する。
	var fixedHeaderDivWidth = tBodyRows[ keyCells[fixedCols].row ].cells[ keyCells[fixedCols].col ].offsetLeft + fixedDivDiff;

	// カラムスタイルを一致させる
	for( i = 0, j = colWidths.length; i < j; i++ ){
		colGroupStyle.appendChild( document.createElement( "COL" ));
		colGroupStyle.lastChild.setAttribute( "width", colWidths[i] +"px" );
		$(colGroupStyle.lastChild).css( "width", colWidths[i]  );
	}

	// ボディ部のスクロールテーブル
	scrollBodyTable.insertBefore(    colGroupStyle.cloneNode( true ), scrollBodyTable.firstChild   );
	$(scrollBodyTable).css('width',tableWidth+"px");
	
	// ヘッダー部のスクロールテーブル
	scrollHeaderTable.insertBefore(  colGroupStyle.cloneNode( true ), scrollHeaderTable.firstChild );
	$(scrollHeaderTable).css('width',tableWidth+"px");
	
	// ボディの固定部分
	fixedBodyTable.insertBefore(     colGroupStyle.cloneNode( true ), fixedBodyTable.firstChild    );
	$(fixedBodyTable).css('width',tableWidth+"px");
	
	// ヘッダーの固定部分
	fixedHeaderTable.insertBefore(   colGroupStyle.cloneNode( true ), fixedHeaderTable.firstChild  );
	$(fixedHeaderTable).css('width',tableWidth+"px");
	
	// 画面に外枠(ourterDiv)の出力
	sParent.insertBefore( ourterDiv, scrollBodyTable );

	// ヘッダーの固定部を外枠(ourterDiv)に入れる
	ourterDiv.appendChild( fixedHeaderDiv );
	// 
	scrollHeaderBaseDiv.appendChild( scrollHeaderDiv );
	// ヘッダーのスクロール部を外枠(ourterDiv)に入れる
	ourterDiv.appendChild( scrollHeaderBaseDiv );

	// ボディの固定部を外枠(ourterDiv)に入れる
	ourterDiv.appendChild( fixBodyBaseDiv );

	fixBodyBaseDiv.appendChild( fixBodyDiv );
	// ボディのスクロール部を外枠(ourterDiv)に入れる
	ourterDiv.appendChild( scrollBodyDiv );

	scrollBodyDiv.appendChild( scrollBodyTable );

	//スクロール部分の入力欄を無効にする 2012/09/05 ADD
	var scrollInputObjs = scrollBodyTable.getElementsByTagName("input")
	var cnt = scrollInputObjs.length;
	while( --cnt>=0 ) {
		scrollInputObjs[cnt].setAttribute("disabled" ,"true");
	}
	//スクロール部分のプルダウンを無効にする 2013/06/17 ADD
	var scrollSelectObjs = scrollBodyTable.getElementsByTagName("select")
	var cnt = scrollSelectObjs.length;
	while( --cnt>=0 ) {
		scrollSelectObjs[cnt].setAttribute("disabled" ,"true");
	}

	// 左固定部の幅を設定する。
	fixedHeaderDiv.style.width = fixedHeaderDivWidth + "px";
	
	// テーブルのスタイル設定
	var scrollBodyDivStyles, scrollBodyTableStyles;

	scrollBodyTableStyles = "margin-top: " + ( sHeaderHeight * -1 ) + "px;";
	scrollBodyDivStyles   = "margin-top: " +   sHeaderHeight + "px;";

	// テーブル幅のトータル誤差を加味する。
	tableWidth = tableWidth + totalDiff;
	var ourterDivWidth = ( tableWidth  + scrollBarWidth  ) > windowWidth             ? windowWidth             : ( tableWidth  + scrollBarWidth ) ;
	var ourterDivHeight= ( tableHeight + scrollBarHeight ) > windowHeight - tableTop ? windowHeight - tableTop : ( tableHeight + scrollBarHeight) ;

	ourterDiv.style.width  = ourterDivWidth +"px";
	ourterDiv.style.height = ourterDivHeight +"px";

	scrollBodyDivStyles += "height: " + (ourterDivHeight - sHeaderHeight) + "px;";

	// ボディのスクロール部のテーブルのスタイル
	scrollBodyTableStyles += "margin-left: " + (fixedHeaderDivWidth * -1) + "px;";
	scrollBodyTableStyles += "table-layout: fixed;";
	//2012/10/31 ADD 
	scrollBodyTableStyles += "visibility:visible;";

	// ボディのスクロール部の枠のスタイル
	scrollBodyDivStyles += "margin-left: " + fixedHeaderDivWidth + "px;";
	scrollBodyDivStyles += "width: " + ( ourterDivWidth - fixedHeaderDivWidth ) + "px;";

	scrollBodyDiv.style.cssText   = scrollBodyDivStyles;
	scrollBodyTable.style.cssText = scrollBodyTableStyles;

	// スクロールのイベント処理
	scrollBodyDiv.onscroll = function () {
		// scrollHeaderDivをscrollBodyDivのスクロール（横方向）と連動させる。
		scrollHeaderDiv.style.right = scrollBodyDiv.scrollLeft + "px";
		// fixBodyDivをscrollBodyDivのスクロール（縦方向）と連動させる。
		fixBodyDiv.style.top = (scrollBodyDiv.scrollTop * -1) + "px";
	};
	return true;
};

// メイン処理（画面から呼び出す）
function adjustTable(){
	// iTable
	var iTable = document.getElementsByTagName( "iTable" );
	// iTableが存在しなければ終了
	if( iTable == null || iTable.length == 0 ){ return false; }
	// 
	fixedCols = parseInt( iTable[0].getAttribute('fixedCols') || "0" ,10 );
	
	// 二分割の処理を行う。
	makeSuperTable( "viewTable" ,fixedCols );
};

// 積上げ負荷のガント作成（横方向左固定、右は積上げ負荷のガント表示、スクロール可能）2013/03/08 ADD
function adjustTask(){
	// iTask
	var iTask = document.getElementsByTagName( "iTask" );
	// iTaskが存在しなければ終了
	if( iTask == null || iTask.length == 0 ){ return false; }
	// -------------------------------------Start----------------------------------//
	// viewTableのオブジェクトの取得
	var viewTableObj = document.getElementById( "viewTable" );
	// viewTableが存在しなければ終了
	if( viewTableObj == null ){ return false; } 
	// ganttHeaderオブジェクトの取得
	var gantHeaderObj = document.getElementById( "ganttHeaderData" );
	// gantHeaderObjが存在しなければ終了
	if( gantHeaderObj == null ){ return false; }
	// ガントズーム
	gantZoom      = gantHeaderObj.getAttribute('zoom');
	// tbodyオブジェクトの取得（業務データの一行分）
//	var tBodyObjs   = viewTableObj.all.tags("TBODY");
	var tBodyObjs   = $(viewTableObj).find("TBODY");
	var countTBody = tBodyObjs.length;
	// 業務データ行(tBody)の高さ
	var lineHeight = tBodyObjs[0].offsetHeight;
	// ２段組でガントバーを上下シフトして表示させる
	if( lineHeight < SYS_MIN_HEIGHT_NO_SHIFT    ){ lineHeight = SYS_MIN_HEIGHT_NO_SHIFT; }
	var stackDivParentObj = $(".stackDivParent");
	var countLines = stackDivParentObj.size();

	for( i = 0 ;i < countLines ;i++){
		var stackDivObjs = stackDivParentObj[i].childNodes;
		var parentTdObj  = stackDivParentObj[i].parentNode;
		var capacity     = parseFloat( stackDivParentObj[i].getAttribute('capacity') );
		parentTdObj.style.cssText ="text-align:left;background-image: url('../image/stackBG"+gantZoom+".gif')";
		//
		stackDivParentObj[i].style.height   = lineHeight +"px";
		stackDivParentObj[i].style.overflow = "hidden";
		stackDivParentObj[i].style.top      = 0 +"px";
		var countCells   = stackDivObjs.length;
		for( j = 0 ; j < countCells ; j++ ){
			if( stackDivObjs[j].className == "stackDiv" ){
				stackDivObjs[j].style.left   = (j * unitPixel[gantZoom] - 1) +"px";
				stackDivObjs[j].style.width  = unitPixel[gantZoom] +"px";
				var stackCost   = parseFloat( stackDivObjs[j].getAttribute('stackedCost') );
				var stackHeight = 0;
				if( stackCost <= capacity ){
					$( stackDivObjs[j] ).addClass( SYS_STD_COST );
					stackHeight = stackCost * lineHeight / capacity * SYS_WARN_BOUND;					// 2013/06/17 MOD
				}
				else if( stackCost <= capacity * SYS_WARN_BOUND ){
					$( stackDivObjs[j] ).addClass( SYS_WARN_COST );
					stackHeight = stackCost * lineHeight / capacity * SYS_WARN_BOUND;					// 2013/06/17 MOD
				}
				else if( stackCost > capacity * SYS_WARN_BOUND ){
					$( stackDivObjs[j] ).addClass( SYS_ERROR_COST );
					stackHeight = lineHeight;
				}
				stackDivObjs[j].style.height = stackHeight +"px";
				stackDivObjs[j].style.top    = (lineHeight - stackHeight) +"px";
				if( stackCost > 0 ){
					$(stackDivObjs[j]).html('<span style="text-align: center; bottom:0px; font-size: x-small; position: absolute;">'+stackCost.toFixed(2)+'</span>');
				}
			}
		}
	}
	// --------------------------------------End-----------------------------------//
	fixedCols = parseInt( iTask[0].getAttribute('fixedCols') || "0" ,10 );
	// 二分割の処理を行う。
	makeSuperTable( "viewTable" ,fixedCols );
};

// 実際に呼び出す場合は引数でコントロールする
return function(_mode){
	addBrowserClass();					//  5.10.2.0 (2018/08/03) 6.0.2.5 HTML5関係。ブラウザ判定処理追加

	if(_mode == 'adjustTable'){
		adjustTable();
	}
	else if(_mode == 'adjustGantt'){
		adjustGantt();
	}
	// 2013/03/08 追加
	else if(_mode == 'adjustTask'){
		adjustTask();
	}
};
})();
;

// クロージャー外からのCall用
// 5.9.9.3 (2016/06/24) bodyサイズ未確定の場合の遅延実行
function adjustTable(){
	// 5.10.7.1 (2019/01/18) jQuery1.12対応
	// if( $('body').width() == 0 ){
	if( $('body').width() == 0 || $('body').width() == 100 ){
		setTimeout( function(){adjustTable();},1);
		return;
	}
	adjustGanttTable('adjustTable');
};

function adjustGantt(){
	// 5.10.7.1 (2019/01/18) jQuery1.12対応
	// if( $('body').width() == 0 ){
	if( $('body').width() == 0 || $('body').width() == 100 ){
		setTimeout( function(){adjustGantt();},1);
		return;
	}
	adjustGanttTable('adjustGantt');
};

// 積上げ負荷のガント作成（横方向左固定、右は積上げ負荷のガント表示、スクロール可能）2013/03/08 ADD
function adjustTask(){
	// 5.10.7.1 (2019/01/18) jQuery1.12対応
	// if( $('body').width() == 0 ){
	if( $('body').width() == 0 || $('body').width() == 100 ){
		setTimeout( function(){adjustTask();},1);
		return;
	}
	adjustGanttTable('adjustTask');
};
