/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.opengion.fukurou.model.AbstractFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFileFilter;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileOperation_AZURE
extends AbstractFileOperation {
    private final CloudBlobContainer azureContainer;
    private final String conBuket;

    public FileOperation_AZURE(String string, String string2) {
        super(StringUtil.nval((String)string, (String)HybsSystem.sys((String)"CLOUD_BUCKET")), string2);
        this.conBuket = string;
        String string3 = HybsSystem.sys((String)"CLOUD_STORAGE_AZURE_KEY");
        if (StringUtil.isNull((String)string3)) {
            String string4 = "Azure\u7528\u8a8d\u8a3c\u30ad\u30fc(CLOUD_STORAGE_AZURE_KEY)\u304c\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string4);
        }
        try {
            CloudStorageAccount cloudStorageAccount = CloudStorageAccount.parse((String)string3);
            CloudBlobClient cloudBlobClient = cloudStorageAccount.createCloudBlobClient();
            this.azureContainer = cloudBlobClient.getContainerReference(this.bucket);
            this.azureContainer.createIfNotExists();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("\u30b3\u30f3\u30c6\u30ca\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002container\uff1a").append(this.bucket);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void write(InputStream inputStream) throws IOException {
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            byte[] byArray = this.toByteArray(inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            cloudBlockBlob.upload((InputStream)byteArrayInputStream, (long)byArray.length);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("Azure\u30b9\u30c8\u30ec\u30fc\u30b8\u306b\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.path);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new IOException(stringBuilder.toString());
        }
    }

    public InputStream read() throws FileNotFoundException {
        BlobInputStream blobInputStream;
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            blobInputStream = cloudBlockBlob.openInputStream();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("Azure\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u8aad\u307f\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.path);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new FileNotFoundException(stringBuilder.toString());
        }
        return blobInputStream;
    }

    public boolean delete() {
        boolean bl = false;
        try {
            this.azureContainer.getBlockBlobReference(this.path).delete();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean copy(String string) {
        boolean bl = false;
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            CloudBlockBlob cloudBlockBlob2 = this.azureContainer.getBlockBlobReference(string);
            cloudBlockBlob2.startCopy(cloudBlockBlob);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public long length() {
        long l = 0L;
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            l = cloudBlockBlob.getProperties().getLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long lastModified() {
        long l = 0L;
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            l = cloudBlockBlob.getProperties().getLastModified().getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean isFile() {
        boolean bl = false;
        try {
            CloudBlockBlob cloudBlockBlob = this.azureContainer.getBlockBlobReference(this.path);
            if (cloudBlockBlob.exists()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl = false;
        for (ListBlobItem listBlobItem : this.azureContainer.listBlobs(this.rTrim(this.path, '/'))) {
            if (!(listBlobItem instanceof CloudBlobDirectory)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public FileOperation[] listFiles(FileOperationFileFilter fileOperationFileFilter) {
        if (!this.exists()) {
            return new FileOperationInfo[0];
        }
        String string = this.path;
        if (this.isDirectory()) {
            string = this.setDirTail(this.path);
        }
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        for (ListBlobItem listBlobItem : this.azureContainer.listBlobs(string)) {
            FileOperationInfo fileOperationInfo;
            CloudBlob cloudBlob;
            if (listBlobItem instanceof CloudBlob) {
                cloudBlob = (CloudBlob)listBlobItem;
                fileOperationInfo = new FileOperationInfo();
                fileOperationInfo.setPath(cloudBlob.getName());
                fileOperationInfo.setName(this.drawName(cloudBlob.getName()));
                fileOperationInfo.setParent(this.drawParent(cloudBlob.getName()));
                fileOperationInfo.setLastModifiedValue(cloudBlob.getProperties().getLastModified().getTime());
                fileOperationInfo.setSize(cloudBlob.getProperties().getLength());
                fileOperationInfo.setFile(true);
                arrayList.add(fileOperationInfo);
                continue;
            }
            if (!(listBlobItem instanceof CloudBlobDirectory)) continue;
            cloudBlob = (CloudBlobDirectory)listBlobItem;
            fileOperationInfo = new FileOperationInfo();
            String string2 = this.rTrim(cloudBlob.getPrefix(), '/');
            fileOperationInfo.setPath(string2);
            fileOperationInfo.setName(this.drawName(string2));
            fileOperationInfo.setParent(this.drawParent(string2));
            fileOperationInfo.setDirectory(true);
            arrayList.add(fileOperationInfo);
        }
        FileOperation[] fileOperationArray = this.filter(arrayList, fileOperationFileFilter);
        return fileOperationArray;
    }

    public FileOperation getParentFile() {
        return new FileOperation_AZURE(this.conBuket, this.getParent());
    }
}

