/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.AWSStaticCredentialsProvider;
import com.ibm.cloud.objectstorage.client.builder.AwsClientBuilder;
import com.ibm.cloud.objectstorage.oauth.BasicIBMOAuthCredentials;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientBuilder;
import com.ibm.cloud.objectstorage.services.s3.model.AmazonS3Exception;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsV2Request;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsV2Result;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectListing;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.services.s3.model.PutObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.S3Object;
import com.ibm.cloud.objectstorage.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.opengion.fukurou.model.AbstractFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFileFilter;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileOperation_IBM
extends AbstractFileOperation {
    private final AmazonS3 amazonS3;
    private final String conBuket;
    private static final String COS_AUTH_ENDPOINT = "https://iam.ng.bluemix.net/oidc/token";

    public FileOperation_IBM(String string, String string2) {
        super(StringUtil.nval((String)string, (String)HybsSystem.sys((String)"CLOUD_BUCKET")), string2);
        this.conBuket = string;
        SDKGlobalConfiguration.IAM_ENDPOINT = COS_AUTH_ENDPOINT;
        String string3 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_APIKEY");
        String string4 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SERVICEINSTANCEID");
        BasicIBMOAuthCredentials basicIBMOAuthCredentials = new BasicIBMOAuthCredentials(string3, string4);
        String string5 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SERVICE_END_POINT");
        String string6 = HybsSystem.sys((String)"CLOUD_STORAGE_S3_REGION");
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(string5, string6);
        this.amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicIBMOAuthCredentials))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(endpointConfiguration)).build();
        try {
            if (!this.amazonS3.doesBucketExist(this.bucket)) {
                this.amazonS3.createBucket(this.bucket);
            }
        }
        catch (AmazonS3Exception amazonS3Exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("\u30a2\u30af\u30bb\u30b9\u30ad\u30fc\u306b\u3088\u308b\u8a8d\u8a3c\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            stringBuilder.append(" CLOUD_STORAGE_S3_APIKEY\uff1a").append(string3);
            stringBuilder.append(" CLOUD_STORAGE_S3_SERVICEINSTANCEID\uff1a").append(string4);
            stringBuilder.append(" CLOUD_STORAGE_S3_SERVICE_END_POINT\uff1a").append(string5);
            stringBuilder.append(" CLOUD_STORAGE_S3_REGION\uff1a").append(string6);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(amazonS3Exception.getMessage());
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void write(InputStream inputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            byte[] byArray = this.toByteArray(inputStream);
            objectMetadata.setContentLength((long)byArray.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, this.path, (InputStream)byteArrayInputStream, objectMetadata);
            this.amazonS3.putObject(putObjectRequest);
        }
        catch (Exception exception) {
            try {
                StringBuilder stringBuilder = new StringBuilder(200);
                stringBuilder.append("BLUEMIX\u30d0\u30b1\u30c3\u30c8\u306b\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.path);
                stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
                throw new IOException(stringBuilder.toString());
            }
            catch (Throwable throwable) {
                Closer.ioClose(byteArrayInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)byteArrayInputStream);
    }

    public InputStream read() throws FileNotFoundException {
        S3Object s3Object = null;
        try {
            s3Object = this.amazonS3.getObject(this.bucket, this.path);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("BLUEMIX\u30d0\u30b1\u30c3\u30c8\u304b\u3089\u8aad\u307f\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.path);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new FileNotFoundException(stringBuilder.toString());
        }
        return s3Object.getObjectContent();
    }

    public boolean delete() {
        boolean bl = false;
        try {
            if (this.isFile()) {
                this.amazonS3.deleteObject(this.bucket, this.path);
            } else if (this.isDirectory()) {
                ObjectListing objectListing = this.amazonS3.listObjects(this.bucket, this.path);
                List list = objectListing.getObjectSummaries();
                for (S3ObjectSummary s3ObjectSummary : list) {
                    this.amazonS3.deleteObject(this.bucket, s3ObjectSummary.getKey());
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean copy(String string) {
        boolean bl = false;
        try {
            this.amazonS3.copyObject(this.bucket, this.path, this.bucket, string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public long length() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.bucket, this.path);
            l = objectMetadata.getContentLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long lastModified() {
        long l = 0L;
        try {
            ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(this.bucket, this.path);
            l = objectMetadata.getLastModified().getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean isFile() {
        return this.amazonS3.doesObjectExist(this.bucket, this.path);
    }

    public boolean isDirectory() {
        boolean bl = false;
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            return true;
        }
        ObjectListing objectListing = this.amazonS3.listObjects(this.bucket, this.setDirTail(this.path));
        List list = objectListing.getObjectSummaries();
        bl = list.size() != 0;
        return bl;
    }

    public FileOperation[] listFiles(FileOperationFileFilter fileOperationFileFilter) {
        Object object;
        String string;
        Object object22;
        if (!this.exists()) {
            return new FileOperationInfo[0];
        }
        String string2 = this.path;
        if (this.isDirectory()) {
            string2 = this.setDirTail(this.path);
        }
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.bucket).withPrefix(string2).withDelimiter("/");
        ListObjectsV2Result listObjectsV2Result = this.amazonS3.listObjectsV2(listObjectsV2Request);
        List list = listObjectsV2Result.getObjectSummaries();
        for (Object object22 : list) {
            string = object22.getKey();
            object = new FileOperationInfo();
            object.setPath(string);
            object.setName(this.drawName(string));
            object.setParent(this.drawParent(string));
            object.setLastModified(object22.getLastModified().getTime());
            object.setFile(true);
            object.setSize(object22.getSize());
            arrayList.add((FileOperationInfo)object);
        }
        List list2 = listObjectsV2Result.getCommonPrefixes();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            string = (String)object22.next();
            object = this.rTrim(string, '/');
            FileOperationInfo fileOperationInfo = new FileOperationInfo();
            fileOperationInfo.setPath((String)object);
            fileOperationInfo.setName(this.drawName((String)object));
            fileOperationInfo.setParent(this.drawParent((String)object));
            fileOperationInfo.setDirectory(true);
            arrayList.add(fileOperationInfo);
        }
        object22 = this.filter(arrayList, fileOperationFileFilter);
        return object22;
    }

    public FileOperation getParentFile() {
        return new FileOperation_IBM(this.conBuket, this.getParent());
    }
}

