/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.event.ProgressListener;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.ssl.SdkTLSSocketFactory;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import com.ibm.cloud.objectstorage.protocol.json.SdkJsonGenerator;
import com.ibm.cloud.objectstorage.services.aspera.transfer.Aspera;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaConfig;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaFaspManagerWrapper;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaKeyCache;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransactionImpl;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferException;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferManagerConfig;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferSpecRequest;
import com.ibm.cloud.objectstorage.services.aspera.transfer.Node;
import com.ibm.cloud.objectstorage.services.aspera.transfer.NodePath;
import com.ibm.cloud.objectstorage.services.aspera.transfer.Path;
import com.ibm.cloud.objectstorage.services.aspera.transfer.StorageCredentials;
import com.ibm.cloud.objectstorage.services.aspera.transfer.Tags;
import com.ibm.cloud.objectstorage.services.aspera.transfer.Token;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferListener;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferRequest;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferSpec;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferSpecs;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaDownloadCallable;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaDownloadDirectoryCallable;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaTransferManagerUtils;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaUploadCallable;
import com.ibm.cloud.objectstorage.services.aspera.transfer.internal.AsperaUploadDirectoryCallable;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.model.FASPConnectionInfo;
import com.ibm.cloud.objectstorage.services.s3.transfer.TransferProgress;
import com.ibm.cloud.objectstorage.services.s3.transfer.internal.S3ProgressListenerChain;
import com.ibm.cloud.objectstorage.services.s3.transfer.internal.TransferProgressUpdatingListener;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class AsperaTransferManager {
    protected static final InternalLogApi log = InternalLogFactory.getLog(AsperaTransferManager.class);
    private AsperaConfig asperaConfig;
    private TokenManager tokenManager;
    private AmazonS3 s3Client;
    private AsperaKeyCache akCache;
    private ExecutorService executorService;
    private AsperaFaspManagerWrapper asperaFaspManagerWrapper;
    private AsperaTransferManagerConfig asperaTransferManagerConfig;

    protected AsperaTransferManager(AmazonS3 s3Client, TokenManager tokenManager, AsperaConfig asperaConfig, AsperaTransferManagerConfig asperaTransferManagerConfig) {
        if (s3Client == null) {
            throw new SdkClientException("s3Client has not been set for AsperaTransferManager");
        }
        if (asperaTransferManagerConfig == null) {
            throw new SdkClientException("asperaTransferManagerConfig has not been set for AsperaTransferManager");
        }
        this.tokenManager = tokenManager;
        this.akCache = new AsperaKeyCache(asperaTransferManagerConfig.getMaxFaspCacheSize());
        this.s3Client = s3Client;
        this.executorService = AsperaTransferManagerUtils.createDefaultExecutorService();
        this.asperaTransferManagerConfig = asperaTransferManagerConfig;
        this.asperaFaspManagerWrapper = new AsperaFaspManagerWrapper();
        this.asperaConfig = asperaConfig;
        if (null != asperaTransferManagerConfig.getAscpLogPath()) {
            this.asperaFaspManagerWrapper.configureLogLocation(asperaTransferManagerConfig.getAscpLogPath());
        }
    }

    public Future<AsperaTransaction> upload(String bucket, File localFileName, String remoteFileName) {
        return this.upload(bucket, localFileName, remoteFileName, this.asperaConfig, null);
    }

    public Future<AsperaTransaction> upload(String bucket, File localFileName, String remoteFileName, AsperaConfig sessionDetails, ProgressListener progressListener) {
        log.trace((Object)("AsperaTransferManager.upload >> Starting Upload " + System.nanoTime()));
        this.checkAscpThreshold();
        if (bucket == null || bucket.isEmpty()) {
            throw new SdkClientException("Bucket name has not been specified for upload");
        }
        if (localFileName == null || !localFileName.exists()) {
            throw new SdkClientException("localFileName has not been specified for upload");
        }
        if (remoteFileName == null || remoteFileName.isEmpty()) {
            throw new SdkClientException("remoteFileName has not been specified for upload");
        }
        AsperaUploadCallable uploadCallable = new AsperaUploadCallable(this, bucket, localFileName, remoteFileName, sessionDetails, progressListener);
        Future<AsperaTransaction> asperaTransaction = this.executorService.submit(uploadCallable);
        log.trace((Object)("AsperaTransferManager.upload << Ending Upload " + System.nanoTime()));
        return asperaTransaction;
    }

    public Future<AsperaTransaction> download(String bucket, File localFileName, String remoteFileName) {
        return this.download(bucket, localFileName, remoteFileName, this.asperaConfig, null);
    }

    public Future<AsperaTransaction> download(String bucket, File localFileName, String remoteFileName, AsperaConfig sessionDetails, ProgressListener listenerChain) {
        log.trace((Object)("AsperaTransferManager.download >> Starting Download " + System.nanoTime()));
        this.checkAscpThreshold();
        if (bucket == null || bucket.isEmpty()) {
            throw new SdkClientException("Bucket name has not been specified for download");
        }
        if (localFileName == null || !localFileName.exists()) {
            throw new SdkClientException("localFile does not exist");
        }
        if (remoteFileName == null || remoteFileName.isEmpty()) {
            throw new SdkClientException("remoteFileName has not been specified for download");
        }
        AsperaDownloadCallable downloadCallable = new AsperaDownloadCallable(this, bucket, localFileName, remoteFileName, sessionDetails, listenerChain);
        Future<AsperaTransaction> asperaTransaction = this.executorService.submit(downloadCallable);
        log.trace((Object)("AsperaTransferManager.download << Ending Download " + System.nanoTime()));
        return asperaTransaction;
    }

    public Future<AsperaTransaction> downloadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory) {
        return this.downloadDirectory(bucketName, virtualDirectoryKeyPrefix, directory, null, null);
    }

    public Future<AsperaTransaction> downloadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, AsperaConfig sessionDetails, ProgressListener progressListener) {
        log.trace((Object)("AsperaTransferManager.downloadDirectory >> Starting Download " + System.nanoTime()));
        this.checkAscpThreshold();
        if (bucketName == null || bucketName.isEmpty()) {
            throw new SdkClientException("Bucket name has not been specified for upload");
        }
        if (directory == null || !directory.exists()) {
            throw new SdkClientException("localFileName has not been specified for upload");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.isEmpty()) {
            throw new SdkClientException("remoteFileName has not been specified for upload");
        }
        AsperaDownloadDirectoryCallable downloadDirectoryCallable = new AsperaDownloadDirectoryCallable(this, bucketName, directory, virtualDirectoryKeyPrefix, sessionDetails, progressListener);
        Future<AsperaTransaction> asperaTransaction = this.executorService.submit(downloadDirectoryCallable);
        log.trace((Object)("AsperaTransferManager.downloadDirectory << Ending Download " + System.nanoTime()));
        return asperaTransaction;
    }

    public Future<AsperaTransaction> uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories) {
        return this.uploadDirectory(bucketName, virtualDirectoryKeyPrefix, directory, includeSubdirectories, this.asperaConfig, null);
    }

    public Future<AsperaTransaction> uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories, AsperaConfig sessionDetails, ProgressListener progressListener) {
        log.trace((Object)("AsperaTransferManager.uploadDirectory >> Starting Upload " + System.nanoTime()));
        this.checkAscpThreshold();
        if (bucketName == null || bucketName.isEmpty()) {
            throw new SdkClientException("Bucket name has not been specified for upload");
        }
        if (directory == null || !directory.exists()) {
            throw new SdkClientException("localFileName has not been specified for upload");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.isEmpty()) {
            throw new SdkClientException("remoteFileName has not been specified for upload");
        }
        AsperaUploadDirectoryCallable uploadDirectoryCallable = new AsperaUploadDirectoryCallable(this, bucketName, directory, virtualDirectoryKeyPrefix, sessionDetails, includeSubdirectories, progressListener);
        Future<AsperaTransaction> asperaTransaction = this.executorService.submit(uploadDirectoryCallable);
        log.trace((Object)("AsperaTransferManager.uploadDirectory << Ending Upload " + System.nanoTime()));
        return asperaTransaction;
    }

    public AsperaTransaction processTransfer(String transferSpecStr, String bucketName, String key, String fileName, ProgressListener progressListener) {
        String xferId = UUID.randomUUID().toString();
        AsperaTransactionImpl asperaTransaction = null;
        try {
            TransferProgress transferProgress = new TransferProgress();
            S3ProgressListenerChain listenerChain = new S3ProgressListenerChain(new ProgressListener[]{new TransferProgressUpdatingListener(transferProgress), progressListener});
            log.trace((Object)("AsperaTransferManager.processTransfer >> creating AsperaTransactionImpl " + System.nanoTime()));
            asperaTransaction = new AsperaTransactionImpl(xferId, bucketName, key, fileName, transferProgress, listenerChain);
            log.trace((Object)("AsperaTransferManager.processTransfer << creating AsperaTransactionImpl " + System.nanoTime()));
            this.asperaFaspManagerWrapper.setAsperaTransaction(asperaTransaction);
            log.trace((Object)("AsperaTransferManager.processTransfer >> start transfer " + System.nanoTime()));
            this.asperaFaspManagerWrapper.startTransfer(xferId, transferSpecStr);
            log.trace((Object)("AsperaTransferManager.processTransfer >> end transfer " + System.nanoTime()));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        return asperaTransaction;
    }

    public FASPConnectionInfo getFaspConnectionInfo(String bucketName) {
        log.trace((Object)("AsperaTransferManager.getFaspConnectionInfo >> start " + System.nanoTime()));
        FASPConnectionInfo faspConnectionInfo = (FASPConnectionInfo)this.akCache.get(bucketName);
        if (null == faspConnectionInfo) {
            log.trace((Object)("AsperaTransferManager.getFaspConnectionInfo >> retrieve from COS " + System.nanoTime()));
            faspConnectionInfo = this.s3Client.getBucketFaspConnectionInfo(bucketName);
            log.trace((Object)("AsperaTransferManager.getFaspConnectionInfo << retrieve from COS " + System.nanoTime()));
            if (null == faspConnectionInfo) {
                throw new SdkClientException("Failed to retrieve faspConnectionInfo for bucket: " + bucketName);
            }
            this.akCache.put(bucketName, faspConnectionInfo);
        }
        log.trace((Object)("AsperaTransferManager.getFaspConnectionInfo << end " + System.nanoTime()));
        return faspConnectionInfo;
    }

    public TransferSpecs getTransferSpec(FASPConnectionInfo faspConnectionInfo, String localFileName, String remoteFileName, String direction) throws SdkClientException, AmazonServiceException {
        log.trace((Object)("AsperaTransferManager.getTransferSpec >> start " + System.nanoTime()));
        TransferSpecs transferSpecs = null;
        URL ats_url = null;
        try {
            ats_url = new URL(faspConnectionInfo.getAtsEndpoint());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        URI ats_uri = null;
        try {
            ats_uri = ats_url.toURI();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        log.trace((Object)("AsperaTransferManager.getTransferSpec >> retrieve delegate token " + System.nanoTime()));
        Token token = new Token().withDelegate_token(this.tokenManager.getToken());
        log.trace((Object)("AsperaTransferManager.getTransferSpec << retrieve delegate token " + System.nanoTime()));
        log.trace((Object)("AsperaTransferManager.getTransferSpec >> prepare transfer request " + System.nanoTime()));
        StorageCredentials storageCredentials = new StorageCredentials().withType("token").withToken(token);
        Node node = new Node().withStorage_credentials(storageCredentials);
        Aspera aspera = new Aspera().withNode(node);
        Tags tags = new Tags().withAspera(aspera);
        ArrayList<Path> paths = new ArrayList<Path>();
        Path path = new Path().withSource(localFileName).withDestination(remoteFileName);
        paths.add(path);
        ArrayList<TransferRequest> transferRequests = new ArrayList<TransferRequest>();
        TransferRequest transferRequest = new TransferRequest().withPaths(paths).withDestination_root("").withTags(tags).withRemote_host(ats_uri.getHost());
        transferRequests.add(transferRequest);
        AsperaTransferSpecRequest transferSpecRequest = new AsperaTransferSpecRequest().withTransfer_requests(transferRequests);
        ObjectMapper mapper = new ObjectMapper();
        String jsonTransferRequest = null;
        try {
            jsonTransferRequest = mapper.writeValueAsString((Object)transferSpecRequest);
        }
        catch (SdkJsonGenerator.JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.trace((Object)("AsperaTransferManager.getTransferSpec << prepare transfer request " + System.nanoTime()));
        try {
            SSLContext sslContext;
            log.trace((Object)("AsperaTransferManager.getTransferSpec >> prepare post request " + System.nanoTime()));
            if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"SSL Certificate checking for endpoints has been explicitly disabled.");
                }
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new ApacheConnectionManagerFactory.TrustingX509TrustManager()}, null);
            } else {
                sslContext = SSLContexts.createDefault();
            }
            SdkTLSSocketFactory sslsf = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            CloseableHttpClient client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            HttpPost post = new HttpPost(faspConnectionInfo.getAtsEndpoint() + "/files/" + direction + "_setup");
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            String authStr = faspConnectionInfo.getAccessKeyId() + ":" + faspConnectionInfo.getAccessKeySecret();
            post.setHeader("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])authStr.getBytes("UTF-8")));
            post.setHeader("Accept", "application/json");
            post.setHeader("X-Aspera-Storage-Credentials", "{\"type\": \"token\", \"token\" : {\"delegated_refresh_token\":\"" + this.tokenManager.getToken() + "\"}}");
            StringEntity transferParams = new StringEntity(jsonTransferRequest);
            transferParams.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
            post.setEntity((HttpEntity)transferParams);
            log.trace((Object)("AsperaTransferManager.getTransferSpec << prepare post request " + System.nanoTime()));
            log.trace((Object)("AsperaTransferManager.getTransferSpec >> post request " + System.nanoTime()));
            HttpResponse response = client.execute((HttpUriRequest)post);
            log.trace((Object)("AsperaTransferManager.getTransferSpec << post request " + System.nanoTime()));
            if (response.getStatusLine().getStatusCode() != 200) {
                log.info((Object)("Response code= " + response.getStatusLine().getStatusCode() + ", Reason= " + response.getStatusLine().getReasonPhrase() + ".Throwing AsperaTransferException"));
                AsperaTransferException exception = new AsperaTransferException("Failed to get Aspera Transfer Spec");
                exception.setStatusCode(response.getStatusLine().getStatusCode());
                exception.setStatusMessage(response.getStatusLine().getReasonPhrase());
                throw exception;
            }
            HttpEntity entity = response.getEntity();
            String resultStr = EntityUtils.toString((HttpEntity)entity);
            log.trace((Object)("AsperaTransferManager.getTransferSpec >> mapping transfer spec " + System.nanoTime()));
            transferSpecs = (TransferSpecs)mapper.readValue(resultStr, TransferSpecs.class);
            log.trace((Object)("AsperaTransferManager.getTransferSpec << mapping transfer spec " + System.nanoTime()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        log.trace((Object)("AsperaTransferManager.getTransferSpec << end " + System.nanoTime()));
        return transferSpecs;
    }

    public void checkMultiSessionAllGlobalConfig(TransferSpecs transferSpecs) {
        if (this.asperaTransferManagerConfig.isMultiSession()) {
            for (TransferSpec transferSpec : transferSpecs.transfer_specs) {
                transferSpec.setRemote_host(this.updateRemoteHost(transferSpec.getRemote_host()));
            }
        }
    }

    public void modifyTransferSpec(AsperaConfig sessionDetails, TransferSpecs transferSpecs) {
        for (TransferSpec transferSpec : transferSpecs.transfer_specs) {
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getTargetRateKbps()))) {
                transferSpec.setTarget_rate_kbps(sessionDetails.getTargetRateKbps());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getTargetRateCapKbps()))) {
                transferSpec.setTarget_rate_cap_kbps(sessionDetails.getTargetRateCapKbps());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getMinRateCapKbps()))) {
                transferSpec.setMin_rate_cap_kbps(sessionDetails.getMinRateCapKbps());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getMinRateKbps()))) {
                transferSpec.setMin_rate_kbps(sessionDetails.getMinRateKbps());
            }
            if (!StringUtils.isNullOrEmpty((String)sessionDetails.getRatePolicy())) {
                transferSpec.setRate_policy(sessionDetails.getRatePolicy());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.isLockMinRate()))) {
                transferSpec.setLock_min_rate(sessionDetails.isLockMinRate());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.isLockTargetRate()))) {
                transferSpec.setLock_target_rate(sessionDetails.isLockTargetRate());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.isLockRatePolicy()))) {
                transferSpec.setLock_rate_policy(sessionDetails.isLockRatePolicy());
            }
            if (!StringUtils.isNullOrEmpty((String)sessionDetails.getDestinationRoot())) {
                transferSpec.setDestination_root(sessionDetails.getDestinationRoot());
            }
            if (!StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getMultiSession()))) {
                transferSpec.setMulti_session(sessionDetails.getMultiSession());
            }
            if (StringUtils.isNullOrEmpty((String)String.valueOf(sessionDetails.getMultiSessionThreshold()))) continue;
            transferSpec.setMulti_session_threshold(sessionDetails.getMultiSessionThreshold());
        }
    }

    public void excludeSubdirectories(File directory, TransferSpecs transferSpecs) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        LinkedList<File> files = new LinkedList<File>();
        this.listFiles(directory, files);
        for (TransferSpec transferSpec : transferSpecs.transfer_specs) {
            Vector<NodePath> paths = new Vector<NodePath>();
            for (File f : files) {
                NodePath path = new NodePath();
                path.setDestination(f.getName());
                path.setSource(f.getAbsolutePath());
                paths.add(path);
            }
            transferSpec.setPaths(paths);
        }
    }

    private void listFiles(File dir, List<File> results) {
        File[] found = dir.listFiles();
        if (found != null) {
            for (File f : found) {
                if (f.isDirectory()) continue;
                results.add(f);
            }
        }
    }

    private String updateRemoteHost(String remoteHost) {
        String[] splitStr = remoteHost.split("\\.");
        remoteHost = new StringBuilder(remoteHost).insert(splitStr[0].length(), "-all").toString();
        return remoteHost;
    }

    private void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    protected AsperaTransferManager withTokenManager(TokenManager tokenManager) {
        this.setTokenManager(tokenManager);
        return this;
    }

    private void setAsperaTransferManagerConfig(AsperaTransferManagerConfig asperaTransferManagerConfig) {
        this.asperaTransferManagerConfig = asperaTransferManagerConfig;
    }

    protected AsperaTransferManager withAsperaTransferManagerConfig(AsperaTransferManagerConfig asperaTransferManagerConfig) {
        this.setAsperaTransferManagerConfig(asperaTransferManagerConfig);
        return this;
    }

    public void shutdownThreadPools() {
        this.executorService.shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdownThreadPools();
    }

    protected void checkAscpThreshold() {
        if (TransferListener.getAscpCount() >= this.asperaTransferManagerConfig.getAscpMaxConcurrent()) {
            log.error((Object)("ASCP process threshold has been reached, there are currently " + TransferListener.getAscpCount() + " processes running"));
            throw new AsperaTransferException("ASCP process threshold has been reached");
        }
    }
}

