/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.model;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.MultiPart;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import oracle.cloud.storage.model.StorageInputStream;

public class StorageInputMultistream
extends StorageInputStream {
    private final List<BodyPart> parts;
    private int entity;

    public StorageInputMultistream(MultiPart m, HashMap<String, String> customMetadata) {
        super(((BodyPartEntity)((BodyPart)m.getBodyParts().get(0)).getEntity()).getInputStream(), customMetadata);
        this.parts = m.getBodyParts();
        this.entity = 0;
    }

    @Override
    public int read() throws IOException {
        int in = this.is.read();
        if (in == -1 && this.entity < this.parts.size() - 1) {
            BodyPartEntity b = (BodyPartEntity)this.parts.get(++this.entity).getEntity();
            this.is = b.getInputStream();
            return this.is.read();
        }
        return in;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int in = this.is.read(b, off, len);
        if (in == -1 && this.entity < this.parts.size() - 1) {
            BodyPartEntity part = (BodyPartEntity)this.parts.get(++this.entity).getEntity();
            this.is = part.getInputStream();
            return this.is.read(b, off, len);
        }
        return in;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

