/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.retry.Backoff;

public class LinearBackoff
extends Backoff {
    private static final int DEFAULT_BASE = 1;

    public LinearBackoff() {
        this(true);
    }

    public LinearBackoff(boolean useAttempt) {
        this(1.0, useAttempt);
    }

    public LinearBackoff(double base) {
        this(base, true);
    }

    public LinearBackoff(double base, boolean useAttempt) {
        this(500L, TimeUnit.MILLISECONDS, base, useAttempt);
    }

    public LinearBackoff(long initialDelay, TimeUnit units) {
        this(initialDelay, units, true);
    }

    public LinearBackoff(long initialDelay, TimeUnit units, boolean useAttempt) {
        this(initialDelay, units, 1.0, useAttempt);
    }

    public LinearBackoff(long initialDelay, TimeUnit units, double base) {
        super(initialDelay, units, base, true);
    }

    public LinearBackoff(long initialDelay, TimeUnit units, double base, boolean useAttempt) {
        super(initialDelay, units, base, useAttempt);
    }

    @Override
    protected long calculateMultiplier(int iteration) {
        long multiplier = (long)(this.getBase() * (double)iteration);
        return multiplier;
    }
}

