/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.get;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import oracle.cloudstorage.api.get.GetObjectReply;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.get.IGetRequestProcessor;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.request.processor.AbstractRequestProcessor;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.stripe.JoiningInputStream;
import oracle.cloudstorage.api.stripe.StripeSegmentConfig;
import oracle.cloudstorage.io.Md5VerifyingInputStream;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GetRequestProcessor
extends AbstractRequestProcessor<IGetRequestBuilder, IGetRequestProcessor>
implements IGetRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GetRequestProcessor.class);

    protected GetRequestProcessor(IProcessorFactory factory) {
        super(factory);
    }

    private JoiningInputStream joiningInputStream(int width, InputStream[] stripeSegments) {
        try {
            ExecutorService executor = this.getSession().getExecutor();
            return new JoiningInputStream(executor, width, stripeSegments);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IGetObjectReply object() throws RetryException, InterruptedException {
        final GetObjectReply reply = this.atomicObject();
        int width = Header.stripedSegmentWidth.getInt(reply);
        boolean unencrypted = reply.getHeader(Header.envelopeKey1) == null;
        boolean ignoreEncryption = ((IGetRequestBuilder)this.getBuilder()).ignoreEncryption();
        if (width <= 0 || ((IGetRequestBuilder)this.getBuilder()).ignoreStriping()) {
            if (width > 0) {
                logger.info(Marker.get.marker, "GET ignoring stripe segments for manifest {}.", (Object)this.getObjectUrl());
            }
            if (unencrypted) {
                logger.debug(Marker.get.and(Marker.cipher), "No encryption headers found.");
                return reply;
            }
            if (ignoreEncryption) {
                logger.info(Marker.get.and(Marker.cipher), "Ignoring encrypted data.");
            }
            InputStream rawData = reply.getData();
            final InputStream decrypted = ignoreEncryption ? rawData : this.getSession().decrypt(reply, rawData);
            final boolean encrypted = decrypted == rawData;
            GetObjectReply getObjectReply = reply;
            getObjectReply.getClass();
            GetObjectReply.Wrapper decryptedReply = new GetObjectReply.Wrapper(getObjectReply){

                @Override
                public InputStream getData() {
                    return decrypted;
                }

                @Override
                public boolean isEncrypted() {
                    return encrypted;
                }
            };
            return decryptedReply;
        }
        String uuid = Header.stripedObjectUuid.get(reply);
        String expectedMd5 = Header.stripedObjectMd5.get(reply);
        int count = Integer.parseInt(Header.stripedSegmentCount.get(reply));
        String accountId = ((IGetRequestBuilder)this.getBuilder()).getAccountId();
        String containerId = ((IGetRequestBuilder)this.getBuilder()).getContainerId();
        final InputStream[] stripeSegments = new InputStream[count];
        for (int segment = 0; segment < count; ++segment) {
            String stripeSegmentSuffix = StripeSegmentConfig.calculateSegmentSuffix(uuid, segment);
            String objectId = ((IGetRequestBuilder)this.getBuilder()).getObjectId() + stripeSegmentSuffix;
            IGetObjectReply segmentReply = ((IGetRequestBuilder.Object)((IGetRequestBuilder.Container)this.getInternalRequestBuilderRoot().get().account(accountId).container(containerId)).object(objectId)).ignoreEncryption().send();
            if (segmentReply == null) {
                return null;
            }
            Status.Family family = segmentReply.getStatus().getFamily();
            if (family != Status.Family.SUCCESSFUL) {
                return segmentReply;
            }
            stripeSegments[segment] = segmentReply.getData();
        }
        JoiningInputStream joiningInputStream = this.joiningInputStream(width, stripeSegments);
        JoiningInputStream decrypted = ignoreEncryption ? joiningInputStream : this.getSession().decrypt(reply, joiningInputStream);
        final boolean encrypted = decrypted == joiningInputStream && !unencrypted;
        final Md5VerifyingInputStream verifiedInputStream = new Md5VerifyingInputStream(expectedMd5, decrypted);
        GetObjectReply getObjectReply = reply;
        getObjectReply.getClass();
        GetObjectReply.Wrapper joinedReply = new GetObjectReply.Wrapper(getObjectReply){

            @Override
            public void close() throws IOException {
                for (InputStream inputStream : stripeSegments) {
                    inputStream.close();
                }
                reply.close();
                verifiedInputStream.close();
            }

            @Override
            public InputStream getData() {
                return verifiedInputStream;
            }

            @Override
            public boolean isEncrypted() {
                return encrypted;
            }
        };
        return joinedReply;
    }

    protected abstract GetObjectReply atomicObject() throws RetryException;
}

