/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.apache.utils;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.util.FakeIOException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class ApacheUtils {
    public static HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpEntity newBufferedHttpEntity(HttpEntity entity) throws FakeIOException {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (FakeIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    public static HttpClientContext newClientContext(HttpClientSettings settings, Map<String, ? extends Object> attributes) {
        HttpClientContext clientContext = new HttpClientContext();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, ? extends Object> entry : attributes.entrySet()) {
                clientContext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        ApacheUtils.addPreemptiveAuthenticationProxy(clientContext, settings);
        return clientContext;
    }

    public static CredentialsProvider newProxyCredentialsProvider(HttpClientSettings settings) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(ApacheUtils.newAuthScope(settings), ApacheUtils.newNTCredentials(settings));
        return provider;
    }

    private static Credentials newNTCredentials(HttpClientSettings settings) {
        return new NTCredentials(settings.getProxyUsername(), settings.getProxyPassword(), settings.getProxyWorkstation(), settings.getProxyDomain());
    }

    private static AuthScope newAuthScope(HttpClientSettings settings) {
        return new AuthScope(settings.getProxyHost(), settings.getProxyPort());
    }

    private static void addPreemptiveAuthenticationProxy(HttpClientContext clientContext, HttpClientSettings settings) {
        if (settings.isPreemptiveBasicProxyAuth()) {
            HttpHost targetHost = new HttpHost(settings.getProxyHost(), settings.getProxyPort());
            CredentialsProvider credsProvider = ApacheUtils.newProxyCredentialsProvider(settings);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            clientContext.setCredentialsProvider(credsProvider);
            clientContext.setAuthCache((AuthCache)authCache);
        }
    }
}

