/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.murano.v1.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.murano.v1.MuranoEnvironmentService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.murano.v1.domain.Environment;
import org.openstack4j.openstack.murano.v1.domain.MuranoEnvironment;
import org.openstack4j.openstack.murano.v1.internal.BaseMuranoServices;

public class MuranoEnvironmentServiceImpl
extends BaseMuranoServices
implements MuranoEnvironmentService {
    public List<? extends MuranoEnvironment> list() {
        return this.get(MuranoEnvironment.MuranoEnvironments.class, this.uri("/environments", new Object[0])).execute().getList();
    }

    @Override
    public Environment get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(MuranoEnvironment.class, this.uri("/environments/%s", id)).execute();
    }

    @Override
    public Environment create(Environment env) {
        Preconditions.checkNotNull((Object)env);
        return this.post(MuranoEnvironment.class, this.uri("/environments", new Object[0])).entity(env).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/environments/%s", id)).execute();
    }

    @Override
    public Environment rename(String id, String name) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)name);
        return this.put(MuranoEnvironment.class, this.uri("/environments/%s", id)).entity(new RenameEnvironmentRequest(name)).execute();
    }

    private class RenameEnvironmentRequest
    implements ModelEntity {
        public static final long serialVersionUID = 1L;
        private String name;

        RenameEnvironmentRequest(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

