/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.put.IPutDataReply;
import oracle.cloudstorage.api.reply.Reply;

abstract class PutDataReply
extends Reply
implements IPutDataReply {
    private final Future<String> futureMd5;

    public PutDataReply(Map<String, ?> headers, int statusCode, String message, Future<String> futureMd5, IReply.Context context) {
        super(headers, statusCode, message, context);
        this.futureMd5 = futureMd5;
    }

    @Override
    public int getRetryAttempts() {
        if (this.getContext() == null || this.getContext().getRetryState() == null) {
            return 0;
        }
        return this.getContext().getRetryState().getAttempt();
    }

    @Override
    public String toString() {
        return super.toString() + ", retryAttemps: " + this.getRetryAttempts();
    }

    @Override
    public String getMd5(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isSuccessful()) {
            return this.futureMd5 == null ? null : this.futureMd5.get(timeout, unit);
        }
        try {
            String md5 = this.futureMd5.get(timeout, unit);
            return md5;
        }
        catch (TimeoutException e) {
            return null;
        }
    }
}

